/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.client.overlay;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.api.player.util.IAetherBoss;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.entities.passive.mountable.EntityMoa;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.player.PlayerAether;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AetherOverlay {
    private static final ResourceLocation TEXTURE_JUMPS = Aether.locate("textures/gui/jumps.png");
    private static final ResourceLocation TEXTURE_COOLDOWN_BAR = Aether.locate("textures/gui/cooldown_bar.png");
    private static final ResourceLocation TEXTURE_POISON_VIGNETTE = Aether.locate("textures/blur/poison_vignette.png");
    private static final ResourceLocation TEXTURE_CURE_VIGNETTE = Aether.locate("textures/blur/cure_vignette.png");

    public static void renderPoison(Minecraft mc) {
        PlayerAether playerAether = PlayerAether.get((EntityPlayer)mc.field_71439_g);
        if (playerAether.poisonTime > 0) {
            ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            Tessellator tessellator = Tessellator.field_78398_a;
            float alpha = AetherOverlay.getPoisonAlpha((float)(playerAether.poisonTime % 50) / 50.0f);
            int width = scaledresolution.func_78326_a();
            int height = scaledresolution.func_78328_b();
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3008);
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)alpha);
            mc.field_71446_o.func_110577_a(TEXTURE_POISON_VIGNETTE);
            tessellator.func_78382_b();
            tessellator.func_78374_a(0.0, (double)height, -90.0, 0.0, 1.0);
            tessellator.func_78374_a((double)width, (double)height, -90.0, 1.0, 1.0);
            tessellator.func_78374_a((double)width, 0.0, -90.0, 1.0, 0.0);
            tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public static void renderCure(Minecraft mc) {
        PlayerAether playerAether = PlayerAether.get((EntityPlayer)mc.field_71439_g);
        if (playerAether.isCured()) {
            ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            Tessellator tessellator = Tessellator.field_78398_a;
            float alpha = 0.5f;
            int width = scaledresolution.func_78326_a();
            int height = scaledresolution.func_78328_b();
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3008);
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)alpha);
            mc.field_71446_o.func_110577_a(TEXTURE_CURE_VIGNETTE);
            tessellator.func_78382_b();
            tessellator.func_78374_a(0.0, (double)height, -90.0, 0.0, 1.0);
            tessellator.func_78374_a((double)width, (double)height, -90.0, 1.0, 1.0);
            tessellator.func_78374_a((double)width, 0.0, -90.0, 1.0, 0.0);
            tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public static void renderIronBubble(Minecraft mc) {
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        mc.field_71446_o.func_110577_a(Gui.field_110324_m);
        int bubbleAmount = PlayerAether.get((EntityPlayer)mc.field_71439_g).getAccessoryInventory().getAccessoryCount(new ItemStack(ItemsAether.iron_bubble));
        if (mc.field_71442_b.func_78755_b() && mc.field_71439_g.func_70090_H() && mc.field_71439_g.func_70055_a(Material.field_151586_h)) {
            for (int i = 0; i < bubbleAmount; ++i) {
                AetherOverlay.drawTexturedModalRect(width / 2 - 8 * i + 81, height - 49, 16.0f, 18.0f, 9.0f, 9.0f);
            }
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void renderCooldown(Minecraft mc) {
        PlayerAether playerInfo = PlayerAether.get((EntityPlayer)mc.field_71439_g);
        if (playerInfo.getHammerCooldown() != 0) {
            ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int cooldownRemaining = (int)((float)playerInfo.getHammerCooldown() / (float)playerInfo.getHammerMaxCooldown() * 128.0f);
            int width = scaledresolution.func_78326_a();
            mc.field_71466_p.func_78261_a(playerInfo.getHammerName() + " " + I18n.func_135052_a((String)"item.notch_hammer.cooldown", (Object[])new Object[0]), width / 2 - mc.field_71466_p.func_78256_a(playerInfo.getHammerName() + " Cooldown") / 2, 32, -1);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3008);
            mc.field_71446_o.func_110577_a(TEXTURE_COOLDOWN_BAR);
            AetherOverlay.drawTexturedModalRect(width / 2 - 64, 42.0f, 0.0f, 8.0f, 128.0f, 8.0f);
            AetherOverlay.drawTexturedModalRect(width / 2 - 64, 42.0f, 0.0f, 0.0f, cooldownRemaining, 8.0f);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public static void renderJumps(Minecraft mc) {
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.field_70154_o == null || !(player.field_70154_o instanceof EntityMoa)) {
            return;
        }
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        EntityMoa moa = (EntityMoa)player.field_70154_o;
        int width = scaledresolution.func_78326_a();
        GL11.glPushMatrix();
        mc.field_71446_o.func_110577_a(TEXTURE_JUMPS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int jump = 0; jump < moa.getMaxJumps(); ++jump) {
            int yPos = 18;
            int xPos = width / 2 + jump * 8 - moa.getMaxJumps() * 8 / 2;
            if (jump < moa.getRemainingJumps()) {
                AetherOverlay.drawTexturedModalRect(xPos, yPos, 0.0f, 0.0f, 9.0f, 11.0f);
                continue;
            }
            AetherOverlay.drawTexturedModalRect(xPos, yPos, 10.0f, 0.0f, 9.0f, 11.0f);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void renderAetherPortal(float timeInPortal, ScaledResolution scaledRes) {
        if (timeInPortal < 1.0f) {
            timeInPortal *= timeInPortal;
            timeInPortal *= timeInPortal;
            timeInPortal = timeInPortal * 0.8f + 0.2f;
        }
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)timeInPortal);
        IIcon iicon = BlocksAether.aether_portal.func_149733_h(1);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        float f = iicon.func_94209_e();
        float f1 = iicon.func_94206_g();
        float f2 = iicon.func_94212_f();
        float f3 = iicon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)scaledRes.func_78328_b(), -90.0, (double)f, (double)f3);
        tessellator.func_78374_a((double)scaledRes.func_78326_a(), (double)scaledRes.func_78328_b(), -90.0, (double)f2, (double)f3);
        tessellator.func_78374_a((double)scaledRes.func_78326_a(), 0.0, -90.0, (double)f2, (double)f1);
        tessellator.func_78374_a(0.0, 0.0, -90.0, (double)f, (double)f1);
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderBossHP(Minecraft mc) {
        PlayerAether player = PlayerAether.get((EntityPlayer)mc.field_71439_g);
        IAetherBoss boss = player.getFocusedBoss();
        if (player.getFocusedBoss() != null) {
            if (player.getFocusedBoss().getBossHealth() <= 0.0f) {
                player.setFocusedBoss(null);
                return;
            }
            String bossTitle = boss.getBossName();
            ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int healthRemaining = (int)(boss.getBossHealth() / boss.getMaxBossHealth() * 256.0f);
            int width = scaledresolution.func_78326_a();
            GL11.glPushMatrix();
            mc.field_71466_p.func_78261_a(bossTitle, width / 2 - mc.field_71466_p.func_78256_a(bossTitle) / 2, 2, -1);
            mc.field_71446_o.func_110577_a(Aether.locate("textures/gui/boss_bar.png"));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AetherOverlay.drawTexturedModalRect(width / 2 - 128, 12.0f, 0.0f, 16.0f, 256.0f, 32.0f);
            AetherOverlay.drawTexturedModalRect(width / 2 - 128, 12.0f, 0.0f, 0.0f, healthRemaining, 16.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public static void drawTexturedModalRect(float x, float y, float u, float v, float width, float height) {
        float zLevel = -90.0f;
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + height), (double)zLevel, (double)((u + 0.0f) * var7), (double)((v + height) * var8));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)((u + width) * var7), (double)((v + height) * var8));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0.0f), (double)zLevel, (double)((u + width) * var7), (double)((v + 0.0f) * var8));
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel, (double)((u + 0.0f) * var7), (double)((v + 0.0f) * var8));
        tessellator.func_78381_a();
    }

    public static float getPoisonAlpha(float f) {
        return f * f / 5.0f + 0.4f;
    }

    public static float getCureAlpha(float f) {
        return f * f / 10.0f + 0.4f;
    }
}

