/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.client.gui.dialogue.entity;

import com.gildedgames.the_aether.client.gui.dialogue.DialogueOption;
import com.gildedgames.the_aether.client.gui.dialogue.GuiDialogue;
import com.gildedgames.the_aether.entities.bosses.valkyrie_queen.EntityValkyrieQueen;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.network.AetherNetwork;
import com.gildedgames.the_aether.network.packets.PacketInitiateValkyrieFight;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumDifficulty;

public class GuiValkyrieDialogue
extends GuiDialogue {
    private EntityValkyrieQueen valkyrieQueen;
    private String title = this.getDialogue();
    private int medalSlotId = -1;

    public GuiValkyrieDialogue(EntityValkyrieQueen valkyrieQueen) {
        super("[\u00a7e" + valkyrieQueen.getName() + ", " + I18n.func_135052_a((String)"title.aether_legacy.valkyrie_queen.name", (Object[])new Object[0]) + "\u00a7r]", new DialogueOption(I18n.func_135052_a((String)"gui.queen.dialog.0", (Object[])new Object[0])), new DialogueOption(I18n.func_135052_a((String)"gui.queen.dialog.1", (Object[])new Object[0])), new DialogueOption(I18n.func_135052_a((String)"gui.queen.dialog.2", (Object[])new Object[0])));
        this.valkyrieQueen = valkyrieQueen;
    }

    @Override
    public void dialogueClicked(DialogueOption dialogue) {
        if (this.getDialogueOptions().size() == 3) {
            if (dialogue.getDialogueId() == 0) {
                this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.queen.answer.0", (Object[])new Object[0]));
                this.dialogueTreeCompleted();
            } else if (dialogue.getDialogueId() == 1) {
                DialogueOption medalDialogue = new DialogueOption(this.getMedalDiaulogue());
                this.addDialogueWithOptions(this.title + ": " + I18n.func_135052_a((String)"gui.queen.answer.1", (Object[])new Object[0]), medalDialogue, new DialogueOption(I18n.func_135052_a((String)"gui.valkyrie.dialog.player.denyfight", (Object[])new Object[0])));
            } else if (dialogue.getDialogueId() == 2) {
                this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.queen.answer.2", (Object[])new Object[0]));
                this.dialogueTreeCompleted();
            }
        } else if (dialogue.getDialogueId() == 0) {
            if (this.field_146297_k.field_71441_e.field_73013_u == EnumDifficulty.PEACEFUL) {
                this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.queen.peaceful", (Object[])new Object[0]));
                this.dialogueTreeCompleted();
                return;
            }
            if (this.medalSlotId != -1) {
                AetherNetwork.sendToServer(new PacketInitiateValkyrieFight(this.medalSlotId, this.valkyrieQueen.func_145782_y()));
                this.valkyrieQueen.setBossReady(true);
                this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.valkyrie.dialog.ready", (Object[])new Object[0]));
                this.dialogueTreeCompleted();
            } else {
                this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.valkyrie.dialog.nomedals", (Object[])new Object[0]));
                this.dialogueTreeCompleted();
            }
        } else if (dialogue.getDialogueId() == 1) {
            this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.valkyrie.dialog.nofight", (Object[])new Object[0]));
            this.dialogueTreeCompleted();
        }
    }

    private String getMedalDiaulogue() {
        for (int slotId = 0; slotId < this.field_146297_k.field_71439_g.field_71071_by.field_70462_a.length; ++slotId) {
            ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.field_70462_a[slotId];
            if (stack == null || stack.func_77973_b() != ItemsAether.victory_medal) continue;
            if (stack.field_77994_a >= 10) {
                this.medalSlotId = slotId;
                return I18n.func_135052_a((String)"gui.valkyrie.dialog.player.havemedals", (Object[])new Object[0]);
            }
            return I18n.func_135052_a((String)"gui.valkyrie.dialog.player.lackmedals", (Object[])new Object[0]) + " (" + stack.field_77994_a + "/10)";
        }
        return I18n.func_135052_a((String)"gui.valkyrie.dialog.player.lackmedals", (Object[])new Object[0]) + " (0/10)";
    }
}

