/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.client.gui.dialogue;

import com.gildedgames.the_aether.client.gui.dialogue.DialogueOption;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class GuiDialogue
extends GuiScreen {
    private ArrayList<DialogueOption> dialogueOptions = new ArrayList();
    private String dialogue;

    public GuiDialogue(String dialogue) {
        this.dialogue = dialogue;
    }

    public GuiDialogue(String dialogue, DialogueOption ... options) {
        this(dialogue);
        this.addDialogueOptions(options);
    }

    public void addDialogueWithOptions(String dialogue, DialogueOption ... options) {
        this.dialogue = dialogue;
        this.dialogueOptions.clear();
        this.addDialogueOptions(options);
        this.positionDialogueOptions(this.getDialogueOptions());
    }

    public void func_73866_w_() {
        this.positionDialogueOptions(this.getDialogueOptions());
    }

    private void positionDialogueOptions(ArrayList<DialogueOption> options) {
        int lineNumber = 0;
        for (DialogueOption option : options) {
            option.setDialogueId(lineNumber);
            option.setXPosition(this.field_146294_l / 2 - option.getWidth() / 2);
            option.setYPosition(this.field_146295_m / 2 + this.field_146289_q.func_78271_c(this.dialogue, 300).size() * 12 + 12 * lineNumber);
            ++lineNumber;
        }
    }

    public void addDialogueOptions(DialogueOption ... options) {
        for (DialogueOption option : options) {
            this.dialogueOptions.add(option);
        }
    }

    public void addDialogueMessage(String dialogueMessage) {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(dialogueMessage));
    }

    public void dialogueTreeCompleted() {
        this.field_146297_k.func_147108_a(null);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int optionWidth = 0;
        for (String theDialogue : this.field_146289_q.func_78271_c(this.dialogue, 300)) {
            int stringWidth = this.field_146289_q.func_78256_a(theDialogue);
            this.func_73733_a(this.field_146294_l / 2 - stringWidth / 2 - 2, this.field_146295_m / 2 + optionWidth * 12 - 2, this.field_146294_l / 2 + stringWidth / 2 + 2, this.field_146295_m / 2 + optionWidth * 10 + 10, 0x66000000, 0x66000000);
            this.func_73731_b(this.field_146289_q, theDialogue, this.field_146294_l / 2 - stringWidth / 2, this.field_146295_m / 2 + optionWidth * 10, 0xFFFFFF);
            ++optionWidth;
        }
        for (DialogueOption dialogue : this.dialogueOptions) {
            dialogue.renderDialogue(mouseX, mouseY);
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (DialogueOption dialogue : this.dialogueOptions) {
                if (!dialogue.isMouseOver(mouseX, mouseY)) continue;
                dialogue.playPressSound(this.field_146297_k.func_147118_V());
                try {
                    this.dialogueClicked(dialogue);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void dialogueClicked(DialogueOption dialogue) throws IOException {
    }

    public ArrayList<DialogueOption> getDialogueOptions() {
        return this.dialogueOptions;
    }

    public String getDialogue() {
        return this.dialogue;
    }
}

