/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.blocks.portal;

import com.gildedgames.the_aether.blocks.BlocksAether;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.world.World;

public class AetherPortalSize {
    private final World world;
    private final int axis;
    public final int rightDir;
    public final int leftDir;
    public int portalBlockCount = 0;
    public ChunkCoordinates bottomLeft;
    public int height;
    public int width;

    public AetherPortalSize(World worldIn, int x, int y, int z, int axis) {
        this.world = worldIn;
        this.axis = axis;
        this.leftDir = BlockPortal.field_150001_a[axis][0];
        this.rightDir = BlockPortal.field_150001_a[axis][1];
        int i1 = y;
        while (y > i1 - 21 && y > 0 && this.isEmptyBlock(worldIn.func_147439_a(x, y - 1, z))) {
            --y;
        }
        int i = this.getDistanceUntilEdge(x, y, z, this.leftDir) - 1;
        if (i >= 0) {
            this.bottomLeft = new ChunkCoordinates(x + i * Direction.field_71583_a[this.leftDir], y, z + i * Direction.field_71581_b[this.leftDir]);
            this.width = this.getDistanceUntilEdge(this.bottomLeft.field_71574_a, this.bottomLeft.field_71572_b, this.bottomLeft.field_71573_c, this.rightDir);
            if (this.width < 2 || this.width > 21) {
                this.bottomLeft = null;
                this.width = 0;
            }
        }
        if (this.bottomLeft != null) {
            this.height = this.calculatePortalHeight();
        }
    }

    protected int getDistanceUntilEdge(int x, int y, int z, int leftDir) {
        Block block1;
        Block block;
        int i1;
        int j1 = Direction.field_71583_a[leftDir];
        int k1 = Direction.field_71581_b[leftDir];
        for (i1 = 0; i1 < 22 && this.isEmptyBlock(block = this.world.func_147439_a(x + j1 * i1, y, z + k1 * i1)) && (block1 = this.world.func_147439_a(x + j1 * i1, y - 1, z + k1 * i1)) == Blocks.field_150426_aN; ++i1) {
        }
        block = this.world.func_147439_a(x + j1 * i1, y, z + k1 * i1);
        return block == Blocks.field_150426_aN ? i1 : 0;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected int calculatePortalHeight() {
        this.height = 0;
        block0: while (this.height < 21) {
            for (int i = 0; i < this.width; ++i) {
                int k = this.bottomLeft.field_71574_a + i * Direction.field_71583_a[BlockPortal.field_150001_a[this.axis][1]];
                int l = this.bottomLeft.field_71573_c + i * Direction.field_71581_b[BlockPortal.field_150001_a[this.axis][1]];
                Block block = this.world.func_147439_a(k, this.bottomLeft.field_71572_b + this.height, l);
                if (!this.isEmptyBlock(block)) break block0;
                if (block == BlocksAether.aether_portal) {
                    ++this.portalBlockCount;
                }
                if (i == 0 ? (block = this.world.func_147439_a(k + Direction.field_71583_a[BlockPortal.field_150001_a[this.axis][0]], this.bottomLeft.field_71572_b + this.height, l + Direction.field_71581_b[BlockPortal.field_150001_a[this.axis][0]])) != Blocks.field_150426_aN : i == this.width - 1 && (block = this.world.func_147439_a(k + Direction.field_71583_a[BlockPortal.field_150001_a[this.axis][1]], this.bottomLeft.field_71572_b + this.height, l + Direction.field_71581_b[BlockPortal.field_150001_a[this.axis][1]])) != Blocks.field_150426_aN) break block0;
            }
            ++this.height;
        }
        for (int j = 0; j < this.width; ++j) {
            int i = this.bottomLeft.field_71574_a + j * Direction.field_71583_a[BlockPortal.field_150001_a[this.axis][1]];
            int k = this.bottomLeft.field_71572_b + this.height;
            int l = this.bottomLeft.field_71573_c + j * Direction.field_71581_b[BlockPortal.field_150001_a[this.axis][1]];
            if (this.world.func_147439_a(i, k, l) == Blocks.field_150426_aN) continue;
            this.height = 0;
            break;
        }
        if (this.height <= 21 && this.height >= 3) {
            return this.height;
        }
        this.bottomLeft = null;
        this.width = 0;
        this.height = 0;
        return 0;
    }

    protected boolean isEmptyBlock(Block blockIn) {
        return blockIn.func_149688_o() == Material.field_151579_a || blockIn == Blocks.field_150480_ab || blockIn == BlocksAether.aether_portal;
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void placePortalBlocks() {
        for (int i = 0; i < this.width; ++i) {
            int j = this.bottomLeft.field_71574_a + Direction.field_71583_a[this.rightDir] * i;
            int k = this.bottomLeft.field_71573_c + Direction.field_71581_b[this.rightDir] * i;
            for (int l = 0; l < this.height; ++l) {
                int i1 = this.bottomLeft.field_71572_b + l;
                this.world.func_147465_d(j, i1, k, BlocksAether.aether_portal, this.axis, 2);
            }
        }
    }
}

