/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerPatternItemRenamer;
import com.glodblock.github.client.gui.container.base.FCContainerEncodeTerminal;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class SPacketPatternItemRenamer
implements IMessage {
    private GuiType guiType;
    private String name = "";
    private int valueIndex;

    public SPacketPatternItemRenamer() {
    }

    public SPacketPatternItemRenamer(GuiType guiType, String text, int valIndex) {
        this.guiType = guiType;
        this.name = text;
        this.valueIndex = valIndex;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.guiType != null ? this.guiType.ordinal() : 0);
        buf.writeInt(this.valueIndex);
        buf.writeInt(this.name.length());
        for (int i = 0; i < this.name.length(); ++i) {
            buf.writeChar((int)this.name.charAt(i));
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.guiType = GuiType.getByOrdinal(buf.readByte());
        this.valueIndex = buf.readInt();
        int leName = buf.readInt();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < leName; ++i) {
            sb.append(buf.readChar());
        }
        this.name = sb.toString();
    }

    public static class Handler
    implements IMessageHandler<SPacketPatternItemRenamer, IMessage> {
        @Nullable
        public IMessage onMessage(SPacketPatternItemRenamer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container instanceof ContainerPatternItemRenamer) {
                Slot slot;
                ContainerPatternItemRenamer cpv = (ContainerPatternItemRenamer)container;
                ContainerOpenContext context = cpv.getOpenContext();
                if (context == null) {
                    return null;
                }
                TileEntity te = context.getTile();
                if (te != null) {
                    InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(te), Objects.requireNonNull(context.getSide()), message.guiType);
                } else {
                    Object object = cpv.getTarget();
                    if (object instanceof IWirelessTerminal) {
                        IWirelessTerminal iwt = (IWirelessTerminal)object;
                        InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(iwt.getInventorySlot(), Util.GuiHelper.encodeType(0, Util.GuiHelper.GuiType.ITEM), 0), Objects.requireNonNull(context.getSide()), message.guiType);
                    }
                }
                if (player.field_71070_bA instanceof FCContainerEncodeTerminal && (slot = player.field_71070_bA.func_75139_a(message.valueIndex)) != null && slot.func_75216_d()) {
                    ItemStack nextStack = slot.func_75211_c().func_77946_l();
                    nextStack.func_82841_c(2);
                    nextStack.func_151001_c(message.name);
                    slot.func_75215_d(nextStack);
                }
            }
            return null;
        }
    }
}

