/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei;

import appeng.api.AEApi;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import codechicken.nei.SearchField;
import codechicken.nei.SearchTokenParser;
import codechicken.nei.api.ItemFilter;
import com.glodblock.github.common.storage.IFluidCellInventory;
import com.glodblock.github.common.storage.IFluidCellInventoryHandler;
import com.glodblock.github.common.storage.IStorageFluidCell;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class NEISearchFilter
implements SearchTokenParser.ISearchParserProvider {
    public ItemFilter getFilter(String searchText) {
        Pattern pattern = SearchField.getPattern((String)searchText);
        return pattern == null ? null : new Filter(pattern);
    }

    public char getPrefix() {
        return '\u0000';
    }

    public EnumChatFormatting getHighlightedColor() {
        return null;
    }

    public SearchTokenParser.SearchMode getSearchMode() {
        return SearchTokenParser.SearchMode.ALWAYS;
    }

    public static class Filter
    implements ItemFilter {
        Pattern pattern;

        public Filter(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean matches(ItemStack itemStack) {
            IFluidCellInventoryHandler handler;
            IFluidCellInventory cellInventory;
            IMEInventoryHandler inventory;
            if (itemStack.func_77973_b() instanceof IStorageFluidCell && (inventory = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.FLUIDS)) instanceof IFluidCellInventoryHandler && (cellInventory = (handler = (IFluidCellInventoryHandler)inventory).getCellInv()) != null) {
                for (IAEFluidStack fluid : cellInventory.getContents()) {
                    boolean result = this.pattern.matcher(fluid.getFluidStack().getLocalizedName().toLowerCase()).find();
                    if (!result) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

