/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.config.Settings;
import appeng.api.config.SidelessMode;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.IConfigManager;
import appeng.helpers.IInterfaceHost;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.misc.TileInterface;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.AEFluidInventory;
import com.glodblock.github.inventory.IAEFluidTank;
import com.glodblock.github.inventory.IDualHost;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.util.DualityFluidInterface;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileFluidInterface
extends TileInterface
implements IDualHost {
    private final IConfigManager dualityConfigManager = this.getInterfaceDuality().getConfigManager();
    private final DualityFluidInterface fluidDuality = new DualityFluidInterface(this.getProxy(), (IInterfaceHost)this){

        @Override
        public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
            SidelessMode mode = (SidelessMode)TileFluidInterface.this.dualityConfigManager.getSetting(Settings.SIDELESS_MODE);
            if (mode == SidelessMode.SIDELESS) {
                return this.getTanks().drain(from, maxDrain, doDrain);
            }
            return this.getTanks().drain(from.ordinal(), maxDrain, doDrain);
        }
    };
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory((IAEAppEngInventory)this, 6);

    public TileFluidInterface() {
        super.getInterfaceDuality().getConfigManager().registerSetting(Settings.SIDELESS_MODE, (Enum)SidelessMode.SIDELESS);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.fluidDuality.onChannelStateChange(c);
        super.stateChange(c);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.fluidDuality.onPowerStateChange(c);
        super.stateChange(c);
    }

    public void gridChanged() {
        super.gridChanged();
        this.fluidDuality.gridChanged();
    }

    @Override
    public DualityFluidInterface getDualityFluid() {
        return this.fluidDuality;
    }

    @Override
    public AEFluidInventory getInternalFluid() {
        return this.fluidDuality.getTanks();
    }

    @Override
    public AppEngInternalAEInventory getConfig() {
        Util.mirrorFluidToPacket((IInventory)this.config, this.fluidDuality.getConfig());
        return this.config;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        TickingRequest item = super.getTickingRequest(node);
        TickingRequest fluid = this.fluidDuality.getTickingRequest(node);
        return new TickingRequest(Math.min(item.minTickRate, fluid.minTickRate), Math.max(item.maxTickRate, fluid.maxTickRate), item.isSleeping && fluid.isSleeping, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        TickRateModulation item = super.tickingRequest(node, ticksSinceLastCall);
        TickRateModulation fluid = this.fluidDuality.tickingRequest(node, ticksSinceLastCall);
        if (item.ordinal() >= fluid.ordinal()) {
            return item;
        }
        return fluid;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    protected void writeToStream(ByteBuf data) throws IOException {
        for (int i = 0; i < this.config.func_70302_i_(); ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.config.func_70301_a(i));
        }
        this.getInternalFluid().writeToBuf(data);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean changed = false;
        for (int i = 0; i < this.config.func_70302_i_(); ++i) {
            ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)data);
            if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.config.func_70301_a(i))) continue;
            this.config.func_70299_a(i, stack);
            changed = true;
        }
        this.fluidDuality.loadConfigFromPacket((IInventory)this.config);
        return changed |= this.getInternalFluid().readFromBuf(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTEvent(NBTTagCompound data) {
        this.config.readFromNBT(data, "ConfigInv");
        this.fluidDuality.loadConfigFromPacket((IInventory)this.config);
        this.getInternalFluid().readFromNBT(data, "FluidInv");
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public NBTTagCompound writeToNBTEvent(NBTTagCompound data) {
        this.config.writeToNBT(data, "ConfigInv");
        this.getInternalFluid().writeToNBT(data, "FluidInv");
        return data;
    }

    @Nullable
    protected ItemStack getItemFromTile(Object obj) {
        if (obj instanceof TileFluidInterface) {
            return ItemAndBlockHolder.INTERFACE.stack();
        }
        return null;
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.getInterfaceDuality().getInstalledUpgrades(u);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fluidDuality.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.fluidDuality.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.fluidDuality.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fluidDuality.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.fluidDuality.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.fluidDuality.getTankInfo(from);
    }

    @Override
    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        this.saveChanges();
        this.markForUpdate();
        this.fluidDuality.onFluidInventoryChanged(inv, slot);
    }

    @Override
    public void setConfig(int id, IAEFluidStack fluid) {
        if (id >= 0 && id < 6) {
            this.config.func_70299_a(id, ItemFluidPacket.newDisplayStack(fluid == null ? null : fluid.getFluidStack()));
            this.fluidDuality.getConfig().setFluidInSlot(id, this.fluidDuality.getStandardFluid(fluid));
        }
    }

    @Override
    public void setFluidInv(int id, IAEFluidStack fluid) {
        if (id >= 0 && id < 6) {
            this.getInternalFluid().setFluidInSlot(id, fluid);
        }
    }

    public void getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        this.fluidDuality.addDrops(drops);
        this.fluidDuality.convertDrops(drops, this.getInterfaceDuality().getWaitingToSend());
        super.getDrops(w, x, y, z, drops);
    }
}

