/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.client.texture.CableBusTextures;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.me.GridAccessException;
import appeng.parts.automation.PartUpgradeable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import com.glodblock.github.api.registries.ILevelViewable;
import com.glodblock.github.api.registries.LevelItemInfo;
import com.glodblock.github.api.registries.LevelState;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.Util;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class PartFluidLevelEmitter
extends PartUpgradeable
implements IStackWatcherHost,
ICraftingWatcherHost,
IMEMonitorHandlerReceiver<IAEFluidStack>,
IGridTickable,
ILevelViewable {
    private static final int FLAG_ON = 8;
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory((IAEAppEngInventory)this, 1);
    private boolean prevState = false;
    private long lastReportedValue = 0L;
    private long reportingValue = 0L;
    private IStackWatcher myWatcher;
    private double centerX;
    private double centerY;
    private double centerZ;
    private int lastWorkingTick = 0;
    private boolean delayedUpdatesQueued = false;

    public PartFluidLevelEmitter(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_EMITTER, (Enum)RedstoneMode.LOW_SIGNAL);
        if (MinecraftServer.func_71276_C() != null) {
            this.delayedUpdatesQueued = true;
            this.lastWorkingTick = MinecraftServer.func_71276_C().func_71259_af();
        }
    }

    public long getReportingValue() {
        return this.reportingValue;
    }

    public void setReportingValue(long v) {
        this.reportingValue = v;
        this.updateState();
    }

    @MENetworkEventSubscribe
    public void powerChanged(MENetworkPowerStatusChange c) {
        this.updateState();
    }

    private void updateState() {
        boolean isOn = this.isLevelEmitterOn();
        if (this.prevState != isOn) {
            this.getHost().markForUpdate();
            TileEntity te = this.getHost().getTile();
            this.prevState = isOn;
            Platform.notifyBlocksOfNeighbors((World)te.func_145831_w(), (int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e);
            Platform.notifyBlocksOfNeighbors((World)te.func_145831_w(), (int)(te.field_145851_c + this.getSide().offsetX), (int)(te.field_145848_d + this.getSide().offsetY), (int)(te.field_145849_e + this.getSide().offsetZ));
        }
    }

    private boolean isLevelEmitterOn() {
        if (Platform.isClient()) {
            return (this.getClientFlags() & 8) == 8;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        Enum redstoneEmitterSetting = this.getConfigManager().getSetting(Settings.REDSTONE_EMITTER);
        boolean result = redstoneEmitterSetting == RedstoneMode.LOW_SIGNAL ? this.reportingValue >= this.lastReportedValue + 1L : this.reportingValue < this.lastReportedValue + 1L;
        return result;
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelsChanged c) {
        this.updateState();
    }

    protected int populateFlags(int cf) {
        return cf | (this.prevState ? 8 : 0);
    }

    public IIcon getBreakingTexture() {
        return this.getItemStack().func_77954_c();
    }

    public void updateWatcher(ICraftingWatcher newWatcher) {
        this.configureWatchers();
    }

    public void onRequestChange(ICraftingGrid craftingGrid, IAEItemStack what) {
        this.updateState();
    }

    private IAEFluidStack getIAEFluidStack() {
        FluidStack fs = ItemFluidPacket.getFluidStack(this.config.getAEStackInSlot(0));
        if (fs != null) {
            return Util.FluidUtil.createAEFluidStack(fs);
        }
        return null;
    }

    private void configureWatchers() {
        IAEFluidStack myStack = this.getIAEFluidStack();
        if (this.myWatcher != null) {
            this.myWatcher.clear();
        }
        try {
            this.getProxy().getStorage().getFluidInventory().removeListener((IMEMonitorHandlerReceiver)this);
            if (this.myWatcher != null && myStack != null) {
                this.myWatcher.add((Object)myStack);
            }
            if (myStack == null) {
                this.getProxy().getStorage().getFluidInventory().addListener((IMEMonitorHandlerReceiver)this, (Object)this.getProxy().getGrid());
            }
            this.updateReportingValue((IMEMonitor<IAEFluidStack>)this.getProxy().getStorage().getFluidInventory());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateReportingValue(IMEMonitor<IAEFluidStack> monitor) {
        IAEFluidStack myStack = this.getIAEFluidStack();
        if (myStack == null) {
            this.lastReportedValue = 0L;
            for (IAEFluidStack st : monitor.getStorageList()) {
                this.lastReportedValue += st.getStackSize();
            }
        } else {
            IAEFluidStack r = (IAEFluidStack)monitor.getStorageList().findPrecise((IAEStack)myStack);
            this.lastReportedValue = r == null ? 0L : r.getStackSize();
        }
        this.updateState();
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, BaseActionSource src, StorageChannel chan) {
        if (chan == StorageChannel.FLUIDS && fullStack.equals((Object)this.getIAEFluidStack())) {
            this.lastReportedValue = fullStack.getStackSize();
            this.updateState();
        }
    }

    public boolean isValid(Object effectiveGrid) {
        try {
            return this.getProxy().getGrid() == effectiveGrid;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(AEConfig.instance.levelEmitterDelay / 2, AEConfig.instance.levelEmitterDelay, !this.delayedUpdatesQueued, true);
    }

    private boolean canDoWork() {
        int currentTick = MinecraftServer.func_71276_C().func_71259_af();
        return currentTick - this.lastWorkingTick > AEConfig.instance.levelEmitterDelay;
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.delayedUpdatesQueued && this.canDoWork()) {
            this.delayedUpdatesQueued = false;
            this.lastWorkingTick = MinecraftServer.func_71276_C().func_71259_af();
            this.onListUpdate();
        }
        return this.delayedUpdatesQueued ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        if (this.canDoWork()) {
            if (this.delayedUpdatesQueued) {
                this.delayedUpdatesQueued = false;
                try {
                    this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
                }
                catch (GridAccessException e) {
                    AELog.error((Throwable)e, (String)"Couldn't put level emitter to sleep after cancelling delayed updates");
                }
            }
            this.lastWorkingTick = MinecraftServer.func_71276_C().func_71259_af();
            this.updateReportingValue((IMEMonitor<IAEFluidStack>)((IMEMonitor)monitor));
        } else if (!this.delayedUpdatesQueued) {
            this.delayedUpdatesQueued = true;
            try {
                this.getProxy().getTick().alertDevice(this.getProxy().getNode());
            }
            catch (GridAccessException e) {
                AELog.error((Throwable)e, (String)"Couldn't wake up level emitter for delayed updates");
            }
        }
    }

    public void onListUpdate() {
        try {
            this.updateReportingValue((IMEMonitor<IAEFluidStack>)this.getProxy().getStorage().getFluidInventory());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(this.getItemStack().func_77954_c());
        Tessellator.field_78398_a.func_78382_b();
        this.renderTorchAtAngle(0.0, -0.5, 0.0);
        Tessellator.field_78398_a.func_78381_a();
    }

    private void renderTorchAtAngle(double baseX, double baseY, double baseZ) {
        boolean isOn = this.isLevelEmitterOn();
        IIcon offTexture = this.getItemStack().func_77954_c();
        IIcon IIcon2 = isOn ? CableBusTextures.LevelEmitterTorchOn.getIcon() : offTexture;
        this.centerX = baseX + 0.5;
        this.centerY = baseY + 0.5;
        this.centerZ = baseZ + 0.5;
        baseY += 0.4375;
        float var16 = IIcon2.func_94209_e();
        float var17 = IIcon2.func_94212_f();
        float var18 = IIcon2.func_94206_g();
        float var19 = IIcon2.func_94210_h();
        double var20b = offTexture.func_94214_a(7.0);
        double var24b = offTexture.func_94214_a(9.0);
        double var20 = IIcon2.func_94214_a(7.0);
        double var24 = IIcon2.func_94214_a(9.0);
        double var22 = IIcon2.func_94207_b(6.0 + (isOn ? 0.0 : 1.0));
        double var26 = IIcon2.func_94207_b(8.0 + (isOn ? 0.0 : 1.0));
        double var28 = IIcon2.func_94214_a(7.0);
        double var30 = IIcon2.func_94207_b(13.0);
        double var32 = IIcon2.func_94214_a(9.0);
        double var34 = IIcon2.func_94207_b(15.0);
        double var22b = IIcon2.func_94207_b(9.0);
        double var26b = IIcon2.func_94207_b(11.0);
        double var36 = (baseX += 0.5) - 0.5;
        double var38 = baseX + 0.5;
        double var40 = (baseZ += 0.5) - 0.5;
        double var42 = baseZ + 0.5;
        double toff = 0.0;
        if (!isOn) {
            toff = 0.0625;
        }
        Tessellator var12 = Tessellator.field_78398_a;
        if (isOn) {
            var12.func_78386_a(1.0f, 1.0f, 1.0f);
            var12.func_78380_c(0xB000B0);
        }
        double TorchLen = 0.625;
        double var44 = 0.0625;
        double Zero = 0.0;
        double par10 = 0.0;
        double x = baseX + 0.0 - 0.0625;
        double x1 = baseX + 0.0 + 0.0625;
        double y = baseY + 0.625 - toff;
        double var422 = 0.254;
        double y1 = baseY + 0.254;
        double z = baseZ + 0.0 - 0.0625;
        double z1 = baseZ + 0.0 + 0.0625;
        this.addVertexWithUV(x, y, z, var20, var22);
        this.addVertexWithUV(x, y, z1, var20, var26);
        this.addVertexWithUV(x1, y, z1, var24, var26);
        this.addVertexWithUV(x1, y, z, var24, var22);
        this.addVertexWithUV(x1, y1, z, var24b, var22b);
        this.addVertexWithUV(x1, y1, z1, var24b, var26b);
        this.addVertexWithUV(x, y1, z1, var20b, var26b);
        this.addVertexWithUV(x, y1, z, var20b, var22b);
        this.addVertexWithUV(baseX + 0.0625 + 0.0, baseY, baseZ - 0.0625 + 0.0, var32, var30);
        this.addVertexWithUV(baseX + 0.0625 + 0.0, baseY, baseZ + 0.0625 + 0.0, var32, var34);
        this.addVertexWithUV(baseX - 0.0625 + 0.0, baseY, baseZ + 0.0625 + 0.0, var28, var34);
        this.addVertexWithUV(baseX - 0.0625 + 0.0, baseY, baseZ - 0.0625 + 0.0, var28, var30);
        this.addVertexWithUV(baseX - 0.0625, baseY + 1.0, var40, var16, var18);
        this.addVertexWithUV(baseX - 0.0625 + 0.0, baseY + 0.0, var40 + 0.0, var16, var19);
        this.addVertexWithUV(baseX - 0.0625 + 0.0, baseY + 0.0, var42 + 0.0, var17, var19);
        this.addVertexWithUV(baseX - 0.0625, baseY + 1.0, var42, var17, var18);
        this.addVertexWithUV(baseX + 0.0625, baseY + 1.0, var42, var16, var18);
        this.addVertexWithUV(baseX + 0.0 + 0.0625, baseY + 0.0, var42 + 0.0, var16, var19);
        this.addVertexWithUV(baseX + 0.0 + 0.0625, baseY + 0.0, var40 + 0.0, var17, var19);
        this.addVertexWithUV(baseX + 0.0625, baseY + 1.0, var40, var17, var18);
        this.addVertexWithUV(var36, baseY + 1.0, baseZ + 0.0625, var16, var18);
        this.addVertexWithUV(var36 + 0.0, baseY + 0.0, baseZ + 0.0625 + 0.0, var16, var19);
        this.addVertexWithUV(var38 + 0.0, baseY + 0.0, baseZ + 0.0625 + 0.0, var17, var19);
        this.addVertexWithUV(var38, baseY + 1.0, baseZ + 0.0625, var17, var18);
        this.addVertexWithUV(var38, baseY + 1.0, baseZ - 0.0625, var16, var18);
        this.addVertexWithUV(var38 + 0.0, baseY + 0.0, baseZ - 0.0625 + 0.0, var16, var19);
        this.addVertexWithUV(var36 + 0.0, baseY + 0.0, baseZ - 0.0625 + 0.0, var17, var19);
        this.addVertexWithUV(var36, baseY + 1.0, baseZ - 0.0625, var17, var18);
    }

    private void addVertexWithUV(double x, double y, double z, double u, double v) {
        double m;
        Tessellator var12 = Tessellator.field_78398_a;
        x -= this.centerX;
        y -= this.centerY;
        z -= this.centerZ;
        if (this.getSide() == ForgeDirection.DOWN) {
            y = -y;
            z = -z;
        }
        if (this.getSide() == ForgeDirection.EAST) {
            m = x;
            x = y;
            y = m;
            y = -y;
        }
        if (this.getSide() == ForgeDirection.WEST) {
            m = x;
            x = -y;
            y = m;
        }
        if (this.getSide() == ForgeDirection.SOUTH) {
            m = z;
            z = y;
            y = m;
            y = -y;
        }
        if (this.getSide() == ForgeDirection.NORTH) {
            m = z;
            z = -y;
            y = m;
        }
        var12.func_78374_a(x += this.centerX, y += this.centerY, z += this.centerZ, u, v);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(this.getItemStack().func_77954_c());
        renderer.field_147837_f = true;
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78380_c(rh.getBlock().func_149677_c((IBlockAccess)this.getHost().getTile().func_145831_w(), x, y, z));
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        this.renderTorchAtAngle(x, y, z);
        renderer.field_147837_f = false;
        rh.setBounds(7.0f, 7.0f, 11.0f, 9.0f, 9.0f, 12.0f);
        this.renderLights(x, y, z, rh, renderer);
    }

    public int isProvidingStrongPower() {
        return this.prevState ? 15 : 0;
    }

    public int isProvidingWeakPower() {
        return this.prevState ? 15 : 0;
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
        if (this.isLevelEmitterOn()) {
            ForgeDirection d = this.getSide();
            double d0 = (double)((float)d.offsetX * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)d.offsetY * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)d.offsetZ * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.func_72869_a("reddust", 0.5 + (double)x + d0, 0.5 + (double)y + d1, 0.5 + (double)z + d2, 0.0, 0.0, 0.0);
        }
    }

    public int cableConnectionRenderTo() {
        return 16;
    }

    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            InventoryHandler.openGui(player, this.getHost().getTile().func_145831_w(), new BlockPos(this.getHost().getTile()), Objects.requireNonNull(this.getSide()), GuiType.FLUID_LEVEL_EMITTER);
            return true;
        }
        return false;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.configureWatchers();
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.config) {
            this.configureWatchers();
        }
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
    }

    public void upgradesChanged() {
        this.configureWatchers();
    }

    public boolean canConnectRedstone() {
        return true;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.lastReportedValue = data.func_74763_f("lastReportedValue");
        this.reportingValue = data.func_74763_f("reportingValue");
        this.prevState = data.func_74767_n("prevState");
        this.config.readFromNBT(data, "config");
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74772_a("lastReportedValue", this.lastReportedValue);
        data.func_74772_a("reportingValue", this.reportingValue);
        data.func_74757_a("prevState", this.prevState);
        this.config.writeToNBT(data, "config");
    }

    public void setFluidInSlot(int id, IAEFluidStack fluid) {
        ItemStack tmp = ItemFluidPacket.newDisplayStack(fluid == null ? null : fluid.getFluidStack());
        this.config.func_70299_a(id, tmp);
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public LevelItemInfo[] getLevelItemInfoList() {
        ItemStack stack = this.config.func_70301_a(0);
        if (stack == null) {
            return new LevelItemInfo[]{null};
        }
        return new LevelItemInfo[]{new LevelItemInfo(stack, this.getReportingValue(), -1L, this.isProvidingStrongPower() > 0 ? LevelState.Craft : LevelState.Idle)};
    }
}

