/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import appeng.api.AEApi;
import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.features.IWirelessTermRegistry;
import appeng.core.localization.PlayerMessages;
import appeng.items.tools.powered.ToolWirelessTerminal;
import appeng.util.Platform;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IItemInventory;
import com.glodblock.github.loader.recipe.WirelessTerminalEnergyRecipe;
import com.glodblock.github.loader.recipe.WirelessTerminalRecipe;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.NameConst;
import com.glodblock.github.util.Util;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemBaseWirelessTerminal
extends ToolWirelessTerminal
implements IItemInventory {
    protected GuiType type;
    public static String infinityBoosterCard = "infinityBoosterCard";
    public static String infinityEnergyCard = "InfinityEnergyCard";
    public static String restockItems = "restock";

    public ItemBaseWirelessTerminal(GuiType t) {
        this.type = t;
    }

    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer player) {
        if (player.func_70093_af()) {
            return this.removeInfinityBoosterCard(player, item);
        }
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)item, (int)1) > 0) {
            if (Platform.isClient()) {
                return item;
            }
            IWirelessTermRegistry term = AEApi.instance().registries().wireless();
            if (!term.isWirelessTerminal(item)) {
                player.func_145747_a(PlayerMessages.DeviceNotWirelessTerminal.get());
                return item;
            }
            IWirelessTermHandler handler = term.getWirelessTerminalHandler(item);
            String unparsedKey = handler.getEncryptionKey(item);
            if (unparsedKey.isEmpty()) {
                player.func_145747_a(PlayerMessages.DeviceNotLinked.get());
                return item;
            }
            long parsedKey = Long.parseLong(unparsedKey);
            ILocatable securityStation = AEApi.instance().registries().locatable().getLocatableBy(parsedKey);
            if (securityStation == null) {
                player.func_145747_a(PlayerMessages.StationCanNotBeLocated.get());
                return item;
            }
            if (handler.hasPower(player, 0.5, item)) {
                InventoryHandler.openGui(player, w, new BlockPos(player.field_71071_by.field_70461_c, 0, 0), ForgeDirection.UNKNOWN, this.guiGuiType(item));
            } else {
                player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
            }
        }
        return item;
    }

    private ItemStack removeInfinityBoosterCard(EntityPlayer player, ItemStack is) {
        if (Util.hasInfinityBoosterCard(is)) {
            if (!player.field_71071_by.func_70441_a(WirelessTerminalRecipe.getInfinityBoosterCard())) {
                player.func_70099_a(WirelessTerminalRecipe.getInfinityBoosterCard(), 0.0f);
            }
            is.func_77978_p().func_74757_a(infinityBoosterCard, false);
        }
        return is;
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
        if (GuiScreen.func_146271_m()) {
            lines.add(NameConst.i18n("ae2fc.tooltip.wireless.installed"));
            if (Util.hasInfinityBoosterCard(stack)) {
                lines.add("  " + EnumChatFormatting.GOLD + WirelessTerminalRecipe.getInfinityBoosterCard().func_82833_r());
            }
            if (Util.DimensionalCoordSide.hasEnergyCard(stack)) {
                lines.add("  " + EnumChatFormatting.GOLD + WirelessTerminalEnergyRecipe.getEnergyCard().func_82833_r());
            }
        } else {
            lines.add(NameConst.i18n("ae2fc.tooltip.ctrl_for_more"));
        }
    }

    public boolean canHandle(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() instanceof ItemBaseWirelessTerminal;
    }

    public ItemStack stack() {
        return new ItemStack((Item)this, 1);
    }

    @Override
    public Object getInventory(ItemStack stack, World world, int x, int y, int z, EntityPlayer player) {
        return null;
    }

    public GuiType guiGuiType(ItemStack stack) {
        return this.type;
    }

    public static void toggleRestockItemsMode(ItemStack is, boolean state) {
        NBTTagCompound data = Platform.openNbtData((ItemStack)is);
        data.func_74757_a(restockItems, state);
    }
}

