/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.storage.data.IAEStack;
import appeng.container.AEBaseContainer;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.SlotPatternOutputs;
import appeng.container.slot.SlotRestrictedInput;
import appeng.items.storage.ItemBasicStorageCell;
import appeng.tile.inventory.AppEngInternalInventory;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.common.item.FCBaseItemCell;
import com.glodblock.github.common.tile.TileSuperStockReplenisher;
import com.glodblock.github.inventory.slot.OptionalFluidSlotFake;
import com.glodblock.github.network.SPacketSuperStockReplenisherUpdate;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ContainerSuperStockReplenisher
extends AEBaseContainer
implements IOptionalSlotHost {
    private final TileSuperStockReplenisher tile;
    private final IInventory configFluids;
    private final IInventory configItems;
    private int lastUpdated = 0;

    public ContainerSuperStockReplenisher(InventoryPlayer ipl, TileSuperStockReplenisher tile) {
        super(ipl, (Object)tile);
        this.tile = tile;
        this.configFluids = tile.getConfigFluid();
        this.configItems = tile.getConfigItems();
        AppEngInternalInventory cell = tile.getCell();
        int x = 8;
        int fy = 8;
        this.func_75146_a((Slot)new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.WORKBENCH_CELL, (IInventory)cell, 0, 173, 8, this.getInventoryPlayer()));
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new OptionalFluidSlotFake(this.configFluids, this, i, 8, 8, i, 0, 0));
        }
        int io = 29;
        for (int y = 0; y < 7; ++y) {
            for (int ix = 0; ix < 9; ++ix) {
                this.func_75146_a((Slot)new SlotPatternOutputs(this.configItems, (IOptionalSlotHost)this, y * 9 + ix, 8, 29, ix, y, y));
            }
        }
        this.bindPlayerInventory(ipl, 0, 169);
    }

    public ItemStack func_75144_a(int slotId, int clickedButton, int mode, EntityPlayer player) {
        if (slotId == 0 && player.field_71071_by.func_70445_o() == null && this.isConfigurated()) {
            return null;
        }
        return super.func_75144_a(slotId, clickedButton, mode, player);
    }

    public boolean isSlotEnabled(int idx) {
        return true;
    }

    public void func_75132_a(ICrafting p_75132_1_) {
        super.func_75132_a(p_75132_1_);
        this.lastUpdated = 24;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.lastUpdated > 20) {
            int i;
            this.lastUpdated = 0;
            HashMap tmp = new HashMap();
            for (i = 0; i < this.tile.getInternalFluid().getSlots(); ++i) {
                tmp.put(i, (IAEStack<?>)this.tile.getInternalFluid().getFluidInSlot(i));
            }
            for (i = 0; i < this.tile.getInternalInventory().func_70302_i_(); ++i) {
                tmp.put(i + 100, (IAEStack<?>)this.tile.getInternalAEInventory().getAEStackInSlot(i));
            }
            for (Object g : this.field_75149_d) {
                if (!(g instanceof EntityPlayer)) continue;
                FluidCraft.proxy.netHandler.sendTo(new SPacketSuperStockReplenisherUpdate(tmp), (EntityPlayerMP)g);
            }
        }
        ++this.lastUpdated;
    }

    private boolean isConfigurated() {
        int i;
        for (i = 0; i < this.configItems.func_70302_i_(); ++i) {
            if (this.configItems.func_70301_a(i) == null) continue;
            return true;
        }
        for (i = 0; i < this.configFluids.func_70302_i_(); ++i) {
            if (this.configFluids.func_70301_a(i) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isValidForSlot(Slot s, ItemStack is) {
        if (s.field_75222_d == 0 && s.func_75216_d() && this.isConfigurated()) {
            FCBaseItemCell fcbic;
            ItemBasicStorageCell ibsc;
            long currentBytes = 0L;
            long newBytes = -1L;
            Item item = s.func_75211_c().func_77973_b();
            if (item instanceof ItemBasicStorageCell) {
                ibsc = (ItemBasicStorageCell)item;
                currentBytes = ibsc.getBytesLong(is);
            } else {
                item = s.func_75211_c().func_77973_b();
                if (item instanceof FCBaseItemCell) {
                    fcbic = (FCBaseItemCell)item;
                    currentBytes = fcbic.getBytes(is);
                }
            }
            item = is.func_77973_b();
            if (item instanceof ItemBasicStorageCell) {
                ibsc = (ItemBasicStorageCell)item;
                newBytes = ibsc.getBytesLong(is);
            } else {
                item = is.func_77973_b();
                if (item instanceof FCBaseItemCell) {
                    fcbic = (FCBaseItemCell)item;
                    newBytes = fcbic.getBytes(is);
                }
            }
            if (currentBytes > newBytes) {
                return false;
            }
        }
        return super.isValidForSlot(s, is);
    }

    public TileSuperStockReplenisher getTile() {
        return this.tile;
    }
}

