/*
 * Decompiled with CFR 0.152.
 */
package oneeyemaker.ztones.proxy;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import oneeyemaker.ztones.ModConfiguration;
import oneeyemaker.ztones.Ztones;
import oneeyemaker.ztones.items.ZtoneGenericItemBlock;
import oneeyemaker.ztones.network.ModNetwork;
import oneeyemaker.ztones.proxy.CommonProxy;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static boolean isVariantCyclingEnabledByServer;
    private static KeyBinding cycleKey;

    @Override
    public void preInitialize(FMLPreInitializationEvent event) {
        super.preInitialize(event);
        isVariantCyclingEnabledByServer = ModConfiguration.isVariantCyclingEnabled;
    }

    @Override
    public void initialize(FMLInitializationEvent event) {
        super.initialize(event);
        cycleKey = new KeyBinding(StatCollector.func_74838_a((String)String.format("%s.keybinding.cycle", "Ztones")), 29, StatCollector.func_74838_a((String)String.format("%s.keybindings", "Ztones")));
        ClientRegistry.registerKeyBinding((KeyBinding)cycleKey);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public boolean isVariantCyclingEnabled() {
        return isVariantCyclingEnabledByServer;
    }

    @Override
    public void setVariantCyclingEnabled(boolean isVariantCyclingEnabled) {
        isVariantCyclingEnabledByServer = isVariantCyclingEnabled;
        Ztones.LOG.info("Configuration is updated by server.");
        Ztones.LOG.info(String.format("Ztone variant cycling is %s", isVariantCyclingEnabledByServer ? "enabled" : "disabled"));
    }

    @Override
    public String getCyclingKeybinding() {
        return Keyboard.getKeyName((int)cycleKey.func_151463_i());
    }

    @SubscribeEvent
    public void processMouseEvent(MouseEvent event) {
        ItemStack itemStack;
        if (!isVariantCyclingEnabledByServer) {
            return;
        }
        if (event.dwheel == 0 || !cycleKey.func_151470_d()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityClientPlayerMP entityPlayer = minecraft.field_71439_g;
        if (entityPlayer != null && minecraft.field_71462_r == null && (itemStack = entityPlayer.func_70694_bm()) != null && itemStack.func_77973_b() instanceof ZtoneGenericItemBlock) {
            ModNetwork.cycleZtone((EntityPlayer)entityPlayer, event.dwheel > 0);
            event.setCanceled(true);
        }
    }
}

