/*
 * Decompiled with CFR 0.152.
 */
package oneeyemaker.ztones.integration;

import com.cricketcraft.chisel.api.carving.CarvingUtils;
import net.minecraft.block.Block;
import oneeyemaker.ztones.ModConfiguration;
import oneeyemaker.ztones.ZtoneType;
import oneeyemaker.ztones.blocks.ModBlocks;

public class ChiselIntegration {
    public static void registerCarvingRecipes() {
        if (!ModConfiguration.isChiselIntegrationEnabled) {
            return;
        }
        if (ModConfiguration.chiselCarvingMode == 0) {
            ChiselIntegration.cycleThroughTypes();
        } else {
            ChiselIntegration.cycleThroughVariants();
        }
    }

    private static void cycleThroughTypes() {
        for (int metadata = 0; metadata < 16; ++metadata) {
            int order = 0;
            for (ZtoneType type : ZtoneType.values()) {
                if (!type.isEnabled()) continue;
                CarvingUtils.chisel.addVariation(String.format("ZtoneTile%d", metadata), (Block)ModBlocks.getBlock(type), metadata, order++);
            }
        }
    }

    private static void cycleThroughVariants() {
        for (ZtoneType type : ZtoneType.values()) {
            if (!type.isEnabled()) continue;
            for (int metadata = 0; metadata < 16; ++metadata) {
                CarvingUtils.chisel.addVariation(type.name(), (Block)ModBlocks.getBlock(type), metadata, metadata);
            }
        }
    }
}

