/*
 * Decompiled with CFR 0.152.
 */
package oneeyemaker.ztones.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import oneeyemaker.ztones.ModConfiguration;
import oneeyemaker.ztones.ZtoneType;
import oneeyemaker.ztones.Ztones;

public class ZtoneGenericBlock
extends Block {
    private final ZtoneType type;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] textures;

    public ZtoneGenericBlock(ZtoneType type) {
        super(type.isGlassLike() ? Material.field_151592_s : Material.field_151576_e);
        this.type = type;
        this.func_149711_c(1.5f);
        if (this.type.isGlassLike()) {
            this.func_149752_b(15.0f);
            this.func_149672_a(Block.field_149778_k);
        } else {
            this.func_149752_b(30.0f);
        }
        this.func_149647_a(Ztones.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int index = 0; index < 16; ++index) {
            list.add(new ItemStack(item, 1, index));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        String name = this.type.toString();
        this.textures = new IIcon[16];
        for (int index = 0; index < 16; ++index) {
            this.textures[index] = iconRegister.func_94245_a(String.format("%s:sets/%s/%s_ (%d)", "Ztones", name, name, index));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (metadata < 0 || metadata >= 16) {
            metadata = 0;
        }
        return this.textures[metadata];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.type.isGlassLike() ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Block neighborBlock;
        if (this.type.isGlassLike() && this == (neighborBlock = world.func_147439_a(x, y, z))) {
            int metadata;
            int neighborMetadata = world.func_72805_g(x, y, z);
            return neighborMetadata != (metadata = world.func_72805_g(x - Facing.field_71586_b[side], y - Facing.field_71587_c[side], z - Facing.field_71585_d[side]));
        }
        return super.func_149646_a(world, x, y, z, side);
    }

    public boolean func_149686_d() {
        return this.field_149764_J != Material.field_151592_s;
    }

    public boolean func_149662_c() {
        return this.field_149764_J != Material.field_151592_s;
    }

    public String func_149739_a() {
        return String.format("%s.%s", "Ztones", this.type.toString());
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return ModConfiguration.isCreatureSpawnOnZtonesEnabled;
    }

    public String getRegistryName() {
        String string;
        switch (this.type) {
            case Glaxx: {
                string = "tile.glaxx";
                break;
            }
            case Tile: {
                string = "stoneTile";
                break;
            }
            default: {
                string = String.format("tile.%sBlock", new Object[]{this.type});
            }
        }
        return string;
    }
}

