/*
 * Decompiled with CFR 0.152.
 */
package oneeyemaker.ztones.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import oneeyemaker.ztones.Ztones;

public class FlatLampBlock
extends Block {
    private final boolean isTransparent;
    private final boolean isDarkened;

    public FlatLampBlock(boolean isTransparent, boolean isDarkened) {
        super(Material.field_151594_q);
        this.isTransparent = isTransparent;
        this.isDarkened = isDarkened;
        this.func_149711_c(0.0f);
        this.func_149752_b(12.0f);
        this.func_149715_a(1.0f);
        this.func_149647_a(Ztones.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        String suffix = this.isTransparent ? (this.isDarkened ? "b" : "t") : "f";
        this.field_149761_L = iconRegister.func_94245_a(String.format("%s:lamp%s", "Ztones", suffix));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Block neighborBlock;
        if (this.isTransparent && this == (neighborBlock = world.func_147439_a(x, y, z))) {
            return false;
        }
        return super.func_149646_a(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.isTransparent ? 1 : 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public String func_149739_a() {
        String name = this.isTransparent ? (this.isDarkened ? "Darkened" : "Transparent") : "";
        return String.format("%s.flat%sLamp", "Ztones", name);
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        return direction != ForgeDirection.UNKNOWN && world.isSideSolid(x - direction.offsetX, y - direction.offsetY, z - direction.offsetZ, direction);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!world.isSideSolid(x - direction.offsetX, y - direction.offsetY, z - direction.offsetZ, direction)) continue;
            return true;
        }
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float subX, float subY, float subZ, int metadata) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        if (direction != ForgeDirection.UNKNOWN && world.isSideSolid(x - direction.offsetX, y - direction.offsetY, z - direction.offsetZ, direction)) {
            return 6 - direction.ordinal();
        }
        for (ForgeDirection validDirection : ForgeDirection.VALID_DIRECTIONS) {
            if (!world.isSideSolid(x - validDirection.offsetX, y - validDirection.offsetY, z - validDirection.offsetZ, validDirection)) continue;
            return 6 - validDirection.ordinal();
        }
        return 1;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        int metadata = world.func_72805_g(x, y, z);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (metadata != 6 - direction.ordinal() || world.isSideSolid(x - direction.offsetX, y - direction.offsetY, z - direction.offsetZ, direction)) continue;
            this.func_149697_b(world, x, y, z, metadata, 0);
            world.func_147468_f(x, y, z);
            return;
        }
        if (!this.func_149742_c(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, metadata, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z) & 7;
        float offset = 0.0625f;
        switch (metadata) {
            case 1: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0625f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.func_149676_a(0.9375f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0625f);
                break;
            }
            case 4: {
                this.func_149676_a(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
                break;
            }
            case 6: {
                this.func_149676_a(0.0f, 0.9375f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void func_149683_g() {
        float offset = 0.0625f;
        this.func_149676_a(0.0f, 0.4375f, 0.0f, 1.0f, 0.5625f, 1.0f);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collider) {
    }
}

