/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.asm.transformer;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public abstract class BaseTransformer {
    protected final boolean mObf;
    protected boolean isValid = false;
    private final ClassReader reader;
    private final ClassWriter writer;

    public BaseTransformer(String transformedName, byte[] basicClass, boolean isObf) {
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        this.mObf = isObf;
        this.log("Transforming " + transformedName);
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        this.reader = aTempReader;
        this.writer = aTempWriter;
    }

    protected final void init() {
        this.reader.accept((ClassVisitor)new MethodAdaptor((ClassVisitor)this.writer), 0);
        if (this.runInjectorMultipleTimes()) {
            for (String methodName : this.getMethodNamesToStrip()) {
                this.injectMethod(methodName, this.writer);
            }
        } else {
            this.injectMethod("NONE", this.writer);
        }
        this.isValid = this.reader != null && this.writer != null;
        this.log("Valid? " + this.isValid + ".");
    }

    protected abstract boolean runInjectorMultipleTimes();

    public final boolean isValidTransformer() {
        return this.isValid;
    }

    public final ClassReader getReader() {
        return this.reader;
    }

    public final ClassWriter getWriter() {
        return this.writer;
    }

    public abstract boolean injectMethod(String var1, ClassWriter var2);

    public abstract String[] getMethodNamesToStrip();

    public abstract String[] getMethodDescriptorsToStrip();

    public abstract String getTransformerName();

    protected void log(String s) {
        FMLRelaunchLog.log((String)("[Witchery++ ASM] " + this.getTransformerName()), (Level)Level.INFO, (String)s, (Object[])new Object[0]);
    }

    public class MethodAdaptor
    extends ClassVisitor {
        public MethodAdaptor(ClassVisitor cv) {
            super(327680, cv);
            this.cv = cv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            boolean found = false;
            String[] aNames = BaseTransformer.this.getMethodNamesToStrip();
            String[] aDesc = BaseTransformer.this.getMethodDescriptorsToStrip();
            boolean checkDesc = aDesc != null && aDesc.length > 0;
            for (int i = 0; i < BaseTransformer.this.getMethodNamesToStrip().length; ++i) {
                if (checkDesc) {
                    if (!desc.equals(aDesc[i]) || !name.equals(aNames[i])) continue;
                    found = true;
                    break;
                }
                if (!name.equals(aNames[i])) continue;
                found = true;
                break;
            }
            MethodVisitor methodVisitor = !found ? super.visitMethod(access, name, desc, signature, exceptions) : null;
            if (found) {
                BaseTransformer.this.log("Found method " + name + ", removing. " + (checkDesc ? "Using matching method desc. '" + checkDesc + "'" : "Did not compare method desc."));
            }
            return methodVisitor;
        }
    }
}

