/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.ASMUtils;
import net.glease.tc4tweak.asm.TC4Transformer;
import net.glease.tc4tweak.asm.TransformerFactory;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class ChunkCoordinatesVisitor
extends ClassVisitor {
    private String className;

    private ChunkCoordinatesVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public static TransformerFactory createFactory() {
        return new TransformerFactory(ChunkCoordinatesVisitor::new){

            @Override
            public boolean isInactive() {
                if (super.isInactive()) {
                    return true;
                }
                if (ASMUtils.isHodgepodgeFixActive("speedups", "speedupChunkCoordinatesHashCode", true)) {
                    TC4Transformer.log.warn("Disabling TC4Tweaks's stolen ChunkCoordinates hashCode fix to prevent conflict with hodgepodge.");
                    return true;
                }
                return false;
            }
        };
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, this.className, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("hashCode".equals(name)) {
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.className, "posX", "I");
            mv.visitLdcInsn((Object)8976890);
            mv.visitInsn(104);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.className, "posY", "I");
            mv.visitLdcInsn((Object)981131);
            mv.visitInsn(104);
            mv.visitInsn(96);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.className, "posZ", "I");
            mv.visitInsn(96);
            mv.visitInsn(172);
            mv.visitMaxs(3, 1);
            mv.visitEnd();
            return null;
        }
        return mv;
    }
}

