/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.api;

import java.util.ServiceLoader;
import net.glease.tc4tweak.api.BrowserPagingAPI;
import net.glease.tc4tweak.api.DummyBrowserPagingAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TC4TweaksAPI {
    public static final String VERSION = "1.5.32";
    private static final Logger log = LogManager.getLogger((String)"TC4TweaksAPI");
    private static BrowserPagingAPI browserPagingAPI;

    public static BrowserPagingAPI getBrowserPagingAPI() {
        if (browserPagingAPI == null) {
            BrowserPagingAPI api = TC4TweaksAPI.getService(BrowserPagingAPI.class);
            if (api == null) {
                log.warn("Browser Paging API not available! Using dummy Browser Paging API.");
                browserPagingAPI = new DummyBrowserPagingAPI();
            } else {
                browserPagingAPI = api;
            }
        }
        return browserPagingAPI;
    }

    private static <T> T getService(Class<T> serviceClass) {
        ServiceLoader<T> loader = ServiceLoader.load(serviceClass);
        T first = null;
        for (T t : loader) {
            if (first == null) {
                first = t;
            }
            if (!t.getClass().getName().startsWith("net.gase.tc4tweak")) continue;
            return t;
        }
        return first;
    }
}

