/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.utils.pos;

import io.socol.opticubes.utils.pos.ChunkPos;
import java.util.Objects;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.tileentity.TileEntity;

public class BlockPos {
    private static final int PACKED_X_LENGTH = 26;
    private static final int PACKED_Z_LENGTH = 26;
    private static final int PACKED_Y_LENGTH = 12;
    private static final long PACKED_X_MASK = 0x3FFFFFFL;
    private static final long PACKED_Y_MASK = 4095L;
    private static final long PACKED_Z_MASK = 0x3FFFFFFL;
    private static final int Z_OFFSET = 12;
    private static final int X_OFFSET = 38;
    public final int x;
    public final int y;
    public final int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static int unpackX(long packedPos) {
        return (int)(packedPos << 0 >> 38);
    }

    public static int unpackY(long packedPos) {
        return (int)(packedPos << 52 >> 52);
    }

    public static int unpackZ(long packedPos) {
        return (int)(packedPos << 26 >> 38);
    }

    public static BlockPos fromPacked(long packedPos) {
        return new BlockPos(BlockPos.unpackX(packedPos), BlockPos.unpackY(packedPos), BlockPos.unpackZ(packedPos));
    }

    public long packToLong() {
        return BlockPos.packToLong(this.x, this.y, this.z);
    }

    public static long packToLong(int x, int y, int z) {
        long i = 0L;
        i |= ((long)x & 0x3FFFFFFL) << 38;
        return (i |= ((long)y & 0xFFFL) << 0) | ((long)z & 0x3FFFFFFL) << 12;
    }

    public static BlockPos ofTile(TileEntity tile) {
        return new BlockPos(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public ChunkPos getChunkPos() {
        return new ChunkPos(this.x >> 4, this.z >> 4);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPos blockPos = (BlockPos)o;
        return this.x == blockPos.x && this.y == blockPos.y && this.z == blockPos.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public boolean isInFrustum() {
        return ClippingHelperImpl.func_78558_a().func_78553_b((double)this.x - RenderManager.field_78725_b, (double)this.y - RenderManager.field_78726_c, (double)this.z - RenderManager.field_78723_d, (double)(this.x + 1) - RenderManager.field_78725_b, (double)(this.y + 1) - RenderManager.field_78726_c, (double)(this.z + 1) - RenderManager.field_78723_d);
    }
}

