/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.utils;

import io.socol.opticubes.utils.pos.BlockPos;
import java.util.Objects;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.Nullable;

public class Region {
    public static final Region BLOCK = new Region(0, 0, 0, 1, 1, 1);
    private static final int MIN_WORLD_COORD = -30000000;
    private static final int MAX_WORLD_COORD = 29999999;
    private static final int MIN_WORLD_HEIGHT = 0;
    private static final int MAX_WORLD_HEIGHT = 255;
    public final int x0;
    public final int y0;
    public final int z0;
    public final int x1;
    public final int y1;
    public final int z1;

    public Region(int x0, int y0, int z0, int x1, int y1, int z1) {
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
    }

    public Region(BlockPos pos) {
        this(pos.x, pos.y, pos.z, pos.x + 1, pos.y + 1, pos.z + 1);
    }

    public Region(BlockPos pos1, BlockPos pos2) {
        this.x0 = Math.min(pos1.x, pos2.x);
        this.y0 = Math.min(pos1.y, pos2.y);
        this.z0 = Math.min(pos1.z, pos2.z);
        this.x1 = Math.max(pos1.x, pos2.x) + 1;
        this.y1 = Math.max(pos1.y, pos2.y) + 1;
        this.z1 = Math.max(pos1.z, pos2.z) + 1;
    }

    public static Region createProper(int x0, int y0, int z0, int x1, int y1, int z1) {
        return new Region(Math.min(x0, x1), Math.min(y0, y1), Math.min(z0, z1), Math.max(x0, x1), Math.max(y0, y1), Math.max(z0, z1));
    }

    @Nullable
    public static Region tryRecreate(@Nullable Region region) {
        return region == null ? null : Region.tryCreate(region.x0, region.y0, region.z0, region.x1, region.y1, region.z1);
    }

    @Nullable
    public static Region tryCreate(int x0, int y0, int z0, int x1, int y1, int z1) {
        return x0 < x1 && y0 < y1 && z0 < z1 ? new Region(x0, y0, z0, x1, y1, z1) : null;
    }

    public boolean contains(int x, int y, int z) {
        return this.x0 <= x && this.y0 <= y && this.z0 <= z && x < this.x1 && y < this.y1 && z < this.z1;
    }

    public boolean contains(BlockPos pos) {
        return this.contains(pos.x, pos.y, pos.z);
    }

    public Region move(int x, int y, int z) {
        return new Region(this.x0 + x, this.y0 + y, this.z0 + z, this.x1 + x, this.y1 + y, this.z1 + z);
    }

    public Region move(BlockPos pos) {
        return this.move(pos.x, pos.y, pos.z);
    }

    @Nullable
    public Region clampByChunk(int cx, int cz) {
        return Region.tryCreate(Math.max(this.x0, cx << 4), this.y0, Math.max(this.z0, cz << 4), Math.min(this.x1, cx + 1 << 4), this.y1, Math.min(this.z1, cz + 1 << 4));
    }

    public Region clampByWorld() {
        return new Region(MathHelper.func_76125_a((int)this.x0, (int)-30000000, (int)29999999), MathHelper.func_76125_a((int)this.y0, (int)0, (int)255), MathHelper.func_76125_a((int)this.z0, (int)-30000000, (int)29999999), MathHelper.func_76125_a((int)this.x1, (int)-30000000, (int)29999999), MathHelper.func_76125_a((int)this.y1, (int)0, (int)255), MathHelper.func_76125_a((int)this.z1, (int)-30000000, (int)29999999));
    }

    public String toString() {
        return "Region{x0=" + this.x0 + ", y0=" + this.y0 + ", z0=" + this.z0 + ", x1=" + this.x1 + ", y1=" + this.y1 + ", z1=" + this.z1 + '}';
    }

    public double centerX() {
        return (double)(this.x1 + this.x0) / 2.0;
    }

    public double centerY() {
        return (double)(this.y1 + this.y0) / 2.0;
    }

    public double centerZ() {
        return (double)(this.z1 + this.z0) / 2.0;
    }

    public int sizeX() {
        return this.x1 - this.x0;
    }

    public int sizeY() {
        return this.y1 - this.y0;
    }

    public int sizeZ() {
        return this.z1 - this.z0;
    }

    public double getDiagonalLength() {
        return Math.sqrt(this.sizeX() * this.sizeX() + this.sizeY() * this.sizeY() + this.sizeZ() * this.sizeZ());
    }

    public Vec3 getCenter() {
        return Vec3.func_72443_a((double)this.centerX(), (double)this.centerY(), (double)this.centerZ());
    }

    public boolean intersects(double x, double y, double z, double radius) {
        double dz;
        double dy;
        double dx = Math.max((double)this.x0, Math.min(x, (double)this.x1)) - x;
        return Math.sqrt(dx * dx + (dy = Math.max((double)this.y0, Math.min(y, (double)this.y1)) - y) * dy + (dz = Math.max((double)this.z0, Math.min(z, (double)this.z1)) - z) * dz) <= radius;
    }

    public double getDistanceTo(double x, double y, double z) {
        double dx = Math.max((double)this.x0, Math.min(x, (double)this.x1)) - x;
        double dy = Math.max((double)this.y0, Math.min(y, (double)this.y1)) - y;
        double dz = Math.max((double)this.z0, Math.min(z, (double)this.z1)) - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public Region inflate(int factor) {
        return new Region(this.x0 - factor, this.y0 - factor, this.z0 - factor, this.x1 + factor, this.y1 + factor, this.z1 + factor);
    }

    public boolean isInFrustum() {
        return ClippingHelperImpl.func_78558_a().func_78553_b((double)this.x0 - RenderManager.field_78725_b, (double)this.y0 - RenderManager.field_78726_c, (double)this.z0 - RenderManager.field_78723_d, (double)this.x1 - RenderManager.field_78725_b, (double)this.y1 - RenderManager.field_78726_c, (double)this.z1 - RenderManager.field_78723_d);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.x0 == region.x0 && this.y0 == region.y0 && this.z0 == region.z0 && this.x1 == region.x1 && this.y1 == region.y1 && this.z1 == region.z1;
    }

    public int hashCode() {
        return Objects.hash(this.x0, this.y0, this.z0, this.x1, this.y1, this.z1);
    }

    public boolean equals(BlockPos pos) {
        return this.x0 == pos.x && this.y0 == pos.y && this.z0 == pos.z && this.x1 == pos.x + 1 && this.y1 == pos.y + 1 && this.z1 == pos.z + 1;
    }

    public Region asRelative(BlockPos opiCubePos) {
        return this.move(-opiCubePos.x, -opiCubePos.y, -opiCubePos.z);
    }
}

