/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.utils;

public class ColorUtils {
    public static int interpolateColor(int a, int b, float percent) {
        if (percent <= 0.0f) {
            return a;
        }
        if (percent >= 1.0f) {
            return b;
        }
        int ra = a >> 16 & 0xFF;
        int ga = a >> 8 & 0xFF;
        int ba = a & 0xFF;
        int aa = a >> 24;
        int rb = b >> 16 & 0xFF;
        int gb = b >> 8 & 0xFF;
        int bb = b & 0xFF;
        int ab = b >> 24;
        float p1 = 1.0f - percent;
        int rc = (int)(p1 * (float)ra + percent * (float)rb);
        int gc = (int)(p1 * (float)ga + percent * (float)gb);
        int bc = (int)(p1 * (float)ba + percent * (float)bb);
        int ac = (int)(p1 * (float)aa + percent * (float)ab);
        return (ac << 24) + (rc << 16) + (gc << 8) + bc;
    }

    public static int withAlpha(int color, double alpha) {
        return color & 0xFFFFFF | (int)(255.0 * alpha) << 24;
    }
}

