/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.service.opti;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import io.socol.opticubes.service.opti.OptiCube;
import io.socol.opticubes.service.opti.OptiRegionMap;
import io.socol.opticubes.service.opti.OptiServiceRenderer;
import io.socol.opticubes.tiles.TileEntityOptiCube;
import io.socol.opticubes.utils.pos.BlockPos;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.Nullable;

public class OptiService {
    private final Map<BlockPos, OptiCube> optiCubes = new HashMap<BlockPos, OptiCube>();
    private final OptiRegionMap regionMap = new OptiRegionMap();

    public OptiService() {
        FMLCommonHandler.instance().bus().register((Object)new ForgeListener());
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
    }

    public void addOptiCube(TileEntityOptiCube tile) {
        BlockPos optiCubePos = BlockPos.ofTile(tile);
        OptiCube prevOptiCube = this.removeOptiCubeInternal(optiCubePos);
        OptiCube optiCube = new OptiCube(optiCubePos, tile.getAffectedRegion().move(optiCubePos), tile.getRadius());
        optiCube.checkEnabled();
        this.optiCubes.put(optiCubePos, optiCube);
        this.regionMap.add(optiCube);
        this.onOptiCubeUpdate(prevOptiCube, optiCube);
    }

    public void removeOptiCube(TileEntityOptiCube tile) {
        OptiCube prevOptiCube = this.removeOptiCubeInternal(BlockPos.ofTile(tile));
        this.onOptiCubeUpdate(prevOptiCube, null);
    }

    private OptiCube removeOptiCubeInternal(BlockPos optiCubePos) {
        OptiCube optiCube = this.optiCubes.remove(optiCubePos);
        if (optiCube != null) {
            this.regionMap.remove(optiCube);
        }
        return optiCube;
    }

    private void onOptiCubeUpdate(@Nullable OptiCube prevOptiCube, @Nullable OptiCube newOptiCube) {
        if (prevOptiCube == null && newOptiCube == null) {
            return;
        }
        if (newOptiCube != null) {
            if (prevOptiCube != null) {
                newOptiCube.setColor(prevOptiCube.getColor());
            } else {
                newOptiCube.assignColor();
            }
        }
        boolean prevEnabled = prevOptiCube != null && prevOptiCube.isEnabled();
        boolean newEnabled = newOptiCube != null && newOptiCube.isEnabled();
        Set<Object> prevAffectedChunks = prevOptiCube == null ? Collections.emptySet() : prevOptiCube.getAffectedMicroChunks();
        Set<Object> newAffectedChunks = newOptiCube == null ? Collections.emptySet() : newOptiCube.getAffectedMicroChunks();
        HashSet<BlockPos> blocksToUpdate = new HashSet<BlockPos>();
        if (prevEnabled) {
            for (BlockPos blockPos : prevAffectedChunks) {
                if (newAffectedChunks.contains(blockPos)) continue;
                blocksToUpdate.add(blockPos);
            }
        }
        if (newEnabled || prevEnabled) {
            for (BlockPos blockPos : newAffectedChunks) {
                if (!prevAffectedChunks.contains(blockPos)) {
                    if (!newEnabled) continue;
                    blocksToUpdate.add(blockPos);
                    continue;
                }
                if (newEnabled == prevEnabled) continue;
                blocksToUpdate.add(blockPos);
            }
        }
        for (BlockPos blockPos : blocksToUpdate) {
            Minecraft.func_71410_x().field_71438_f.func_72725_b(blockPos.x, blockPos.y, blockPos.z, blockPos.x, blockPos.y, blockPos.z);
        }
    }

    public boolean skipTileRender(TileEntity tile) {
        if (tile instanceof TileEntityOptiCube) {
            return false;
        }
        return this.regionMap.contains(BlockPos.ofTile(tile));
    }

    public boolean skipBlockRender(Block block, BlockPos pos) {
        return (!block.func_149730_j() || !block.func_149662_c()) && this.regionMap.contains(pos);
    }

    public Map<BlockPos, OptiCube> getOptiCubes() {
        return this.optiCubes;
    }

    public OptiCube getOptiCube(BlockPos blockPos) {
        return this.optiCubes.get(blockPos);
    }

    public class EventListener {
        @SubscribeEvent
        public void onRender(RenderWorldLastEvent event) {
            OptiServiceRenderer.render(OptiService.this, event.partialTicks);
        }
    }

    public class ForgeListener {
        @SubscribeEvent
        public void onTick(TickEvent.ClientTickEvent event) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || event.phase != TickEvent.Phase.END) {
                return;
            }
            double cameraX = player.field_70165_t;
            double cameraY = player.field_70163_u + (double)player.func_70047_e();
            double cameraZ = player.field_70161_v;
            HashSet<BlockPos> blocksToUpdate = new HashSet<BlockPos>();
            for (OptiCube optiCube : OptiService.this.optiCubes.values()) {
                if (!optiCube.checkEnabled(player.func_130014_f_(), cameraX, cameraY, cameraZ)) continue;
                blocksToUpdate.addAll(optiCube.getAffectedMicroChunks());
            }
            for (BlockPos pos : blocksToUpdate) {
                Minecraft.func_71410_x().field_71438_f.func_72725_b(pos.x, pos.y, pos.z, pos.x, pos.y, pos.z);
            }
        }
    }
}

