/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.service.opti;

import io.socol.opticubes.service.opti.OptiCube;
import io.socol.opticubes.utils.Region;
import io.socol.opticubes.utils.pos.BlockPos;
import io.socol.opticubes.utils.pos.ChunkPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptiRegionMap {
    private final Map<ChunkPos, OptiChunk> chunks = new HashMap<ChunkPos, OptiChunk>();

    public void add(OptiCube optiCube) {
        optiCube.setAffectedChunks(this.splitByChunks(optiCube));
    }

    public void remove(OptiCube optiCube) {
        for (ChunkPos chunkPos : optiCube.getAffectedChunks()) {
            OptiChunk chunk = this.chunks.get(chunkPos);
            if (chunk == null) continue;
            chunk.regions.remove(optiCube.getPos());
            if (!chunk.regions.isEmpty()) continue;
            this.chunks.remove(chunkPos);
        }
    }

    private List<ChunkPos> splitByChunks(OptiCube optiCube) {
        ArrayList<ChunkPos> affectedChunks = new ArrayList<ChunkPos>();
        Region region = optiCube.getRegion();
        int cx1 = region.x1 >> 4;
        int cz1 = region.z1 >> 4;
        for (int cx = region.x0 >> 4; cx <= cx1; ++cx) {
            for (int cz = region.z0 >> 4; cz <= cz1; ++cz) {
                Region clamped = region.clampByChunk(cx, cz);
                if (clamped == null) continue;
                ChunkPos chunkPos = new ChunkPos(cx, cz);
                affectedChunks.add(chunkPos);
                this.addChunkRegion(chunkPos, new OptiRegion(optiCube, clamped));
            }
        }
        return affectedChunks;
    }

    private void addChunkRegion(ChunkPos chunkPos, OptiRegion region) {
        OptiChunk chunk = this.chunks.get(chunkPos);
        if (chunk == null) {
            chunk = new OptiChunk();
            this.chunks.put(chunkPos, chunk);
        }
        chunk.regions.put(region.optiCube.getPos(), region);
    }

    public boolean contains(BlockPos pos) {
        OptiChunk chunk = this.chunks.get(pos.getChunkPos());
        if (chunk == null) {
            return false;
        }
        for (OptiRegion region : chunk.regions.values()) {
            if (!region.optiCube.isEnabled() || !region.boundary.contains(pos)) continue;
            return true;
        }
        return false;
    }

    private static class OptiRegion {
        private final OptiCube optiCube;
        private final Region boundary;

        public OptiRegion(OptiCube optiCube, Region boundary) {
            this.optiCube = optiCube;
            this.boundary = boundary;
        }
    }

    private static class OptiChunk {
        private final Map<BlockPos, OptiRegion> regions = new HashMap<BlockPos, OptiRegion>();

        private OptiChunk() {
        }
    }
}

