/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.service.opti;

import io.socol.opticubes.service.editing.ClientOptiCubeEditingService;
import io.socol.opticubes.service.editing.OptiCubeRegionType;
import io.socol.opticubes.utils.Region;
import io.socol.opticubes.utils.pos.BlockPos;
import io.socol.opticubes.utils.pos.ChunkPos;
import java.awt.Color;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.world.World;

public class OptiCube {
    private static int lastColorHue;
    public static final int MIN_RADIUS = -1;
    public static final int MAX_RADIUS = 64;
    private final BlockPos pos;
    private final Region region;
    private final int radius;
    private boolean enabled = false;
    private double distance;
    private List<ChunkPos> affectedChunks = Collections.emptyList();
    private Set<BlockPos> affectedMicroChunks = Collections.emptySet();
    private final boolean hasExternalRegion;
    private int color = -1;

    public OptiCube(BlockPos pos, Region region, int radius) {
        this.pos = pos;
        this.region = region;
        this.radius = radius;
        this.hasExternalRegion = !region.equals(pos);
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public double getDistance() {
        return this.distance;
    }

    public void assignColor() {
        this.color = Color.HSBtoRGB((float)lastColorHue / 100.0f, 0.8f, 1.0f);
        lastColorHue += 11;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Region getRegion() {
        return this.region;
    }

    public boolean hasExternalRegion() {
        return this.hasExternalRegion;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setAffectedChunks(List<ChunkPos> affectedChunks) {
        this.affectedChunks = affectedChunks;
        this.affectedMicroChunks = new HashSet<BlockPos>();
        if (!affectedChunks.isEmpty()) {
            int cy1 = this.region.y1 >> 4;
            for (int cy = this.region.y0 >> 4; cy <= cy1; ++cy) {
                int blockY = (cy << 4) + 8;
                for (ChunkPos chunkPos : affectedChunks) {
                    this.affectedMicroChunks.add(new BlockPos(chunkPos.centerX(), blockY, chunkPos.centerZ()));
                }
            }
        }
    }

    public List<ChunkPos> getAffectedChunks() {
        return this.affectedChunks;
    }

    public Set<BlockPos> getAffectedMicroChunks() {
        return this.affectedMicroChunks;
    }

    public boolean checkEnabled() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        return this.checkEnabled(player.func_130014_f_(), player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
    }

    public boolean checkEnabled(World world, double cameraX, double cameraY, double cameraZ) {
        boolean isEditingRegion = ClientOptiCubeEditingService.getInstance().isEditingRegion(world, this.pos, OptiCubeRegionType.AFFECTED_REGION);
        boolean newEnabled = false;
        if (!isEditingRegion) {
            this.distance = this.region.getDistanceTo(cameraX, cameraY, cameraZ);
            newEnabled = this.distance > (double)this.radius;
        } else {
            this.distance = 0.0;
        }
        boolean updated = this.enabled != newEnabled;
        this.enabled = newEnabled;
        return updated;
    }
}

