/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.service.editing;

import io.socol.opticubes.service.editing.OptiCubeRegionType;
import io.socol.opticubes.tiles.TileEntityOptiCube;
import io.socol.opticubes.utils.ChatComponentExt;
import io.socol.opticubes.utils.Region;
import io.socol.opticubes.utils.pos.BlockPos;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class OptiCubeRegionEditingSession {
    private static final int MAX_REGION_SIZE = 48;
    private static final long MAX_DURATION = 6000L;
    private final BlockPos optiCubePos;
    private final OptiCubeRegionType type;
    private final long startTime;

    public OptiCubeRegionEditingSession(BlockPos opiCubePos, OptiCubeRegionType type, long startTime) {
        this.optiCubePos = opiCubePos;
        this.type = type;
        this.startTime = startTime;
    }

    public BlockPos getOptiCubePos() {
        return this.optiCubePos;
    }

    public OptiCubeRegionType getType() {
        return this.type;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void applyRegion(EntityPlayerMP player, World world, @Nullable Region region) {
        if ((region = Region.tryRecreate(region)) == null || !this.isValid(world)) {
            return;
        }
        if (!this.validateRegion((EntityPlayer)player, region = region.clampByWorld(), true)) {
            return;
        }
        TileEntity tile = world.func_147438_o(this.optiCubePos.x, this.optiCubePos.y, this.optiCubePos.z);
        if (tile instanceof TileEntityOptiCube && this.type == OptiCubeRegionType.AFFECTED_REGION) {
            ((TileEntityOptiCube)tile).setAffectedRegion(region.asRelative(this.optiCubePos));
        }
    }

    public boolean isValid(World world) {
        return world.func_82737_E() - this.startTime < 6000L;
    }

    public boolean validateRegion(EntityPlayer player, Region region, boolean sendFeedback) {
        if (region.sizeX() > 48 || region.sizeZ() > 48) {
            if (sendFeedback) {
                player.func_145747_a((IChatComponent)ChatComponentExt.withColor(new ChatComponentTranslation("chat.opticubes.region_too_big", new Object[]{region.sizeX(), region.sizeY(), region.sizeZ(), 48, 256, 48}), EnumChatFormatting.RED));
            }
            return false;
        }
        Region cubeCheckRegion = region.inflate(1).clampByWorld();
        if (!cubeCheckRegion.contains(this.optiCubePos)) {
            if (sendFeedback) {
                player.func_145747_a((IChatComponent)ChatComponentExt.withColor(new ChatComponentTranslation("chat.opticubes.owner_cube_far_away", new Object[0]), EnumChatFormatting.RED));
            }
            return false;
        }
        return true;
    }
}

