/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.service.editing;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.socol.opticubes.network.serverbound.SetOptiCubeRadiusMessage;
import io.socol.opticubes.registry.OptiNetwork;
import io.socol.opticubes.utils.pos.BlockPos;
import net.minecraft.util.MathHelper;

public class OptiCubeRadiusEditingSession {
    private static final int SYNC_INTERVAL = 10;
    private final BlockPos optiCubePos;
    private int radius;
    private final int startTime;
    private int lastSyncRadius;
    private int lastSyncTime;

    public OptiCubeRadiusEditingSession(BlockPos optiCubePos, int radius, int startTime) {
        this.optiCubePos = optiCubePos;
        this.radius = radius;
        this.startTime = startTime;
        this.lastSyncRadius = radius;
        this.lastSyncTime = startTime;
    }

    public BlockPos getOptiCubePos() {
        return this.optiCubePos;
    }

    public int getRadius() {
        return this.radius;
    }

    public void modifyRadius(int delta) {
        this.radius = MathHelper.func_76125_a((int)(this.radius + delta), (int)-1, (int)64);
    }

    public void commit() {
        if (this.radius != this.lastSyncRadius) {
            this.lastSyncRadius = this.radius;
            OptiNetwork.NETWORK.sendToServer((IMessage)new SetOptiCubeRadiusMessage(this.optiCubePos, this.radius));
        }
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void update(int currentTime) {
        if (currentTime - this.lastSyncTime > 10) {
            this.commit();
            this.lastSyncTime = currentTime;
        }
    }
}

