/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.service.editing;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.socol.opticubes.network.clientbound.ResetOptiCubeEditingMessage;
import io.socol.opticubes.network.clientbound.StartOptiCubeRegionEditingMessage;
import io.socol.opticubes.registry.OptiNetwork;
import io.socol.opticubes.service.editing.OptiCubeRegionEditingSession;
import io.socol.opticubes.service.editing.OptiCubeRegionType;
import io.socol.opticubes.tiles.TileEntityOptiCube;
import io.socol.opticubes.utils.Region;
import io.socol.opticubes.utils.pos.BlockPos;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.Nullable;

public class OptiCubeEditingService {
    private final Map<UUID, OptiCubeRegionEditingSession> regionEditingSessions = new HashMap<UUID, OptiCubeRegionEditingSession>();

    public OptiCubeEditingService() {
        FMLCommonHandler.instance().bus().register((Object)new ForgeListener());
    }

    public void startRegionEditingSession(EntityPlayerMP player, BlockPos opiCubePos, OptiCubeRegionType type) {
        this.regionEditingSessions.put(player.func_110124_au(), new OptiCubeRegionEditingSession(opiCubePos, type, player.func_71121_q().func_82737_E()));
        OptiNetwork.NETWORK.sendTo((IMessage)new StartOptiCubeRegionEditingMessage(opiCubePos, type), player);
    }

    public void stopRegionEditingSession(EntityPlayerMP player, @Nullable Region region) {
        OptiCubeRegionEditingSession session = this.regionEditingSessions.remove(player.func_110124_au());
        if (session != null) {
            session.applyRegion(player, player.func_130014_f_(), region);
        }
    }

    public void setOptiCubeRadius(EntityPlayerMP player, BlockPos optiCubePos, int radius) {
        radius = MathHelper.func_76125_a((int)radius, (int)-1, (int)64);
        TileEntity tile = player.func_130014_f_().func_147438_o(optiCubePos.x, optiCubePos.y, optiCubePos.z);
        if (tile instanceof TileEntityOptiCube) {
            ((TileEntityOptiCube)tile).setRadius(radius);
        }
    }

    protected void resetPlayer(EntityPlayer player) {
        this.regionEditingSessions.remove(player.func_110124_au());
    }

    protected void resetAllPlayers() {
        this.regionEditingSessions.clear();
    }

    public class ForgeListener {
        @SubscribeEvent
        public void onPlayerChangeWorld(PlayerEvent.PlayerChangedDimensionEvent event) {
            OptiCubeEditingService.this.resetPlayer(event.player);
            OptiNetwork.NETWORK.sendTo((IMessage)new ResetOptiCubeEditingMessage(), (EntityPlayerMP)event.player);
        }

        @SubscribeEvent
        public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
            OptiCubeEditingService.this.resetPlayer(event.player);
        }
    }
}

