/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.service.editing;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.socol.opticubes.OptiCubes;
import io.socol.opticubes.fx.RegionRenderer;
import io.socol.opticubes.fx.TextPanelRenderer;
import io.socol.opticubes.items.ItemOptiWrench;
import io.socol.opticubes.network.serverbound.StopOptiCubeRegionEditingMessage;
import io.socol.opticubes.proxy.ClientProxy;
import io.socol.opticubes.registry.OptiBlocks;
import io.socol.opticubes.registry.OptiNetwork;
import io.socol.opticubes.service.editing.OptiCubeEditingService;
import io.socol.opticubes.service.editing.OptiCubeRadiusEditingSession;
import io.socol.opticubes.service.editing.OptiCubeRegionEditingSession;
import io.socol.opticubes.service.editing.OptiCubeRegionType;
import io.socol.opticubes.service.opti.OptiCube;
import io.socol.opticubes.utils.Region;
import io.socol.opticubes.utils.pos.BlockPos;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.Nullable;

public class ClientOptiCubeEditingService
extends OptiCubeEditingService {
    private OptiCubeRegionEditingSession currentRegionEditingSession = null;
    private BlockPos firstRegionPoint;
    private OptiCubeRadiusEditingSession currentRadiusEditingSession = null;
    private BlockPos radiusEditingOptiCube = null;

    public ClientOptiCubeEditingService() {
        FMLCommonHandler.instance().bus().register((Object)new ForgeListener());
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
    }

    public OptiCubeRegionEditingSession getCurrentRegionEditingSession() {
        return this.currentRegionEditingSession;
    }

    public void startNewRegionEditingSession(BlockPos optiCubePos, OptiCubeRegionType type, World world) {
        this.currentRegionEditingSession = new OptiCubeRegionEditingSession(optiCubePos, type, world.func_82737_E());
        this.firstRegionPoint = null;
    }

    public void stopRegionEditingSession(@Nullable Region region) {
        this.currentRegionEditingSession = null;
        this.firstRegionPoint = null;
        OptiNetwork.NETWORK.sendToServer((IMessage)new StopOptiCubeRegionEditingMessage(region));
    }

    public boolean isEditingRegion(World world, BlockPos optiCubePos, OptiCubeRegionType regionType) {
        return this.currentRegionEditingSession != null && this.currentRegionEditingSession.getType() == regionType && this.currentRegionEditingSession.getOptiCubePos().equals(optiCubePos) && this.currentRegionEditingSession.isValid(world);
    }

    public boolean isEditingRegion() {
        return this.currentRegionEditingSession != null;
    }

    public BlockPos getFirstRegionPoint() {
        return this.firstRegionPoint;
    }

    public void addRegionPoint(BlockPos pos) {
        if (this.firstRegionPoint == null) {
            this.firstRegionPoint = pos;
            return;
        }
        Region region = new Region(this.firstRegionPoint, pos);
        if (this.currentRegionEditingSession.validateRegion(ClientProxy.player(), region, true)) {
            this.stopRegionEditingSession(region);
        }
    }

    public static ClientOptiCubeEditingService getInstance() {
        return (ClientOptiCubeEditingService)OptiCubes.getEditingService();
    }

    private void stopRadiusEditingSession() {
        if (this.currentRadiusEditingSession != null) {
            this.currentRadiusEditingSession.commit();
            this.currentRadiusEditingSession = null;
        }
    }

    public OptiCubeRadiusEditingSession getCurrentRadiusEditingSession() {
        return this.currentRadiusEditingSession;
    }

    private OptiCube checkRadiusEditingSession(EntityClientPlayerMP player) {
        boolean isBlockSelected;
        ItemStack held = player.func_70694_bm();
        if (!ItemOptiWrench.isOptiWrench(held)) {
            return null;
        }
        World world = player.func_130014_f_();
        MovingObjectPosition hitResult = Minecraft.func_71410_x().field_71476_x;
        boolean bl = isBlockSelected = hitResult != null && hitResult.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK;
        if (isBlockSelected && world.func_147439_a(hitResult.field_72311_b, hitResult.field_72312_c, hitResult.field_72309_d) == OptiBlocks.OPTICUBE) {
            BlockPos blockPos = new BlockPos(hitResult.field_72311_b, hitResult.field_72312_c, hitResult.field_72309_d);
            return OptiCubes.getOptiService().getOptiCube(blockPos);
        }
        return null;
    }

    public boolean onWheelScroll(int i) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        OptiCube optiCube = this.checkRadiusEditingSession(player);
        if (optiCube == null) {
            return false;
        }
        if (this.currentRadiusEditingSession != null && !this.currentRadiusEditingSession.getOptiCubePos().equals(optiCube.getPos())) {
            this.stopRadiusEditingSession();
        }
        if (this.currentRadiusEditingSession == null) {
            this.currentRadiusEditingSession = new OptiCubeRadiusEditingSession(optiCube.getPos(), optiCube.getRadius(), player.field_70173_aa);
        }
        this.currentRadiusEditingSession.modifyRadius(Integer.compare(i, 0));
        return true;
    }

    public void reset() {
        this.currentRegionEditingSession = null;
        this.currentRadiusEditingSession = null;
        this.firstRegionPoint = null;
    }

    public BlockPos getRadiusEditingOptiCube() {
        return this.radiusEditingOptiCube;
    }

    public class EventListener {
        @SubscribeEvent
        public void onRender(RenderWorldLastEvent event) {
            boolean isBlockSelected;
            ClientOptiCubeEditingService.this.radiusEditingOptiCube = null;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            ItemStack held = player.func_70694_bm();
            if (!ItemOptiWrench.isOptiWrench(held)) {
                return;
            }
            MovingObjectPosition hitResult = Minecraft.func_71410_x().field_71476_x;
            boolean bl = isBlockSelected = hitResult != null && hitResult.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK;
            if (ClientOptiCubeEditingService.this.currentRegionEditingSession != null) {
                OptiCube optiCube = OptiCubes.getOptiService().getOptiCube(ClientOptiCubeEditingService.this.currentRegionEditingSession.getOptiCubePos());
                if (optiCube != null) {
                    if (optiCube.hasExternalRegion()) {
                        RegionRenderer.addRegion(new Region(optiCube.getPos()), -14885510).inflate(0.00390625).ignoreDepth();
                    }
                    float time = (float)player.field_70173_aa + event.partialTicks;
                    float animation = MathHelper.func_76126_a((float)((float)Math.toRadians(time * 20.0f)));
                    RegionRenderer.addRegion(optiCube.getRegion(), -14885510).inflate(0.0625f + animation * 1.0f / 32.0f).ignoreDepth().withSides();
                }
                if (ClientOptiCubeEditingService.this.firstRegionPoint != null) {
                    if (isBlockSelected) {
                        BlockPos secondRegionPoint = new BlockPos(hitResult.field_72311_b, hitResult.field_72312_c, hitResult.field_72309_d);
                        RegionRenderer.addRegion(new Region(ClientOptiCubeEditingService.this.firstRegionPoint), -28360).inflate(0.03125).ignoreDepth();
                        RegionRenderer.addRegion(new Region(secondRegionPoint), -13266689).inflate(0.03125);
                        Region selectedRegion = new Region(ClientOptiCubeEditingService.this.firstRegionPoint, secondRegionPoint);
                        boolean regionValid = ClientOptiCubeEditingService.this.currentRegionEditingSession.validateRegion((EntityPlayer)player, selectedRegion, false);
                        RegionRenderer.addRegion(selectedRegion, regionValid ? -1 : -1758384).inflate(0.00390625).ignoreDepth().withSides();
                    } else {
                        RegionRenderer.addRegion(new Region(ClientOptiCubeEditingService.this.firstRegionPoint), -13266689).inflate(0.03125).ignoreDepth();
                    }
                }
            }
            if (isBlockSelected && player.func_130014_f_().func_147439_a(hitResult.field_72311_b, hitResult.field_72312_c, hitResult.field_72309_d) == OptiBlocks.OPTICUBE) {
                BlockPos blockPos = new BlockPos(hitResult.field_72311_b, hitResult.field_72312_c, hitResult.field_72309_d);
                OptiCube optiCube = OptiCubes.getOptiService().getOptiCube(blockPos);
                if (optiCube != null) {
                    ClientOptiCubeEditingService.this.radiusEditingOptiCube = optiCube.getPos();
                    int radius = optiCube.getRadius();
                    int time = player.field_70173_aa;
                    if (ClientOptiCubeEditingService.this.currentRadiusEditingSession != null && ClientOptiCubeEditingService.this.currentRadiusEditingSession.getOptiCubePos().equals(blockPos)) {
                        radius = ClientOptiCubeEditingService.this.currentRadiusEditingSession.getRadius();
                        time -= ClientOptiCubeEditingService.this.currentRadiusEditingSession.getStartTime();
                    }
                    TextPanelRenderer.renderText(new BlockPos(hitResult.field_72311_b, hitResult.field_72312_c, hitResult.field_72309_d), radius == -1 ? "x" : Integer.toString(radius), hitResult.field_72310_e, ClientOptiCubeEditingService.this.currentRadiusEditingSession != null, time, event.partialTicks);
                }
            }
        }
    }

    public class ForgeListener {
        @SubscribeEvent
        public void onTick(TickEvent.ClientTickEvent event) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || event.phase != TickEvent.Phase.END) {
                return;
            }
            if (ClientOptiCubeEditingService.this.currentRadiusEditingSession != null) {
                OptiCube optiCube = ClientOptiCubeEditingService.this.checkRadiusEditingSession(player);
                if (optiCube == null) {
                    ClientOptiCubeEditingService.this.stopRadiusEditingSession();
                } else {
                    ClientOptiCubeEditingService.this.currentRadiusEditingSession.update(player.field_70173_aa);
                }
            }
        }

        @SubscribeEvent
        public void onPlayerLeave(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
            ClientOptiCubeEditingService.this.reset();
            ClientOptiCubeEditingService.this.resetAllPlayers();
        }
    }
}

