/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.network.clientbound;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import io.socol.opticubes.proxy.ClientProxy;
import io.socol.opticubes.service.editing.ClientOptiCubeEditingService;
import io.socol.opticubes.service.editing.OptiCubeRegionType;
import io.socol.opticubes.utils.ProtoUtils;
import io.socol.opticubes.utils.pos.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;

public class StartOptiCubeRegionEditingMessage
implements IMessage {
    private BlockPos optiCubePos;
    private OptiCubeRegionType regionType;

    public StartOptiCubeRegionEditingMessage(BlockPos optiCubePos, OptiCubeRegionType regionType) {
        this.optiCubePos = optiCubePos;
        this.regionType = regionType;
    }

    @ApiStatus.Internal
    public StartOptiCubeRegionEditingMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        this.optiCubePos = ProtoUtils.readBlockPos(buf);
        this.regionType = OptiCubeRegionType.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        ProtoUtils.writeBlockPos(buf, this.optiCubePos);
        buf.writeInt(this.regionType.ordinal());
    }

    public static class Handler
    implements IMessageHandler<StartOptiCubeRegionEditingMessage, IMessage> {
        public IMessage onMessage(StartOptiCubeRegionEditingMessage message, MessageContext ctx) {
            World world = ClientProxy.world();
            if (world != null) {
                ClientOptiCubeEditingService.getInstance().startNewRegionEditingSession(message.optiCubePos, message.regionType, world);
            }
            return null;
        }
    }
}

