/*
 * Decompiled with CFR 0.152.
 */
package io.socol.opticubes.fx;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import io.socol.opticubes.utils.Region;
import io.socol.opticubes.utils.TessellatorUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class RegionRenderer {
    private static final ResourceLocation BOX_TEXTURE = new ResourceLocation("opticubes", "textures/entity/box.png");
    private static final ResourceLocation BOX_SIDE_TEXTURE = new ResourceLocation("opticubes", "textures/entity/box_side.png");
    private static final List<FXRegion> regions = new ArrayList<FXRegion>();

    public static FXRegion addRegion(Region region, int color) {
        FXRegion fxRegion = new FXRegion(region, color);
        regions.add(fxRegion);
        return fxRegion;
    }

    public static void drawAll() {
        if (regions.isEmpty()) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        ArrayList<FXRegion> ignoreDepthRegions = new ArrayList<FXRegion>();
        ArrayList<FXRegion> regionsWithSides = new ArrayList<FXRegion>();
        for (FXRegion region : regions) {
            if (!region.ignoreDepth) continue;
            ignoreDepthRegions.add(region);
            if (!region.withSides) continue;
            regionsWithSides.add(region);
        }
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BOX_TEXTURE);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        if (!ignoreDepthRegions.isEmpty()) {
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)true);
            if (!regionsWithSides.isEmpty()) {
                GL11.glEnable((int)2884);
                GL11.glEnable((int)3042);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BOX_SIDE_TEXTURE);
                tessellator.func_78382_b();
                tessellator.func_78380_c(240);
                for (FXRegion region : regionsWithSides) {
                    TessellatorUtils.setColor(region.color);
                    RegionRenderer.drawSides(tessellator, region.box, region.inflate, -TileEntityRendererDispatcher.field_147554_b, -TileEntityRendererDispatcher.field_147555_c, -TileEntityRendererDispatcher.field_147552_d);
                }
                tessellator.func_78381_a();
                GL11.glDisable((int)3042);
                GL11.glDisable((int)2884);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BOX_TEXTURE);
            }
            tessellator.func_78382_b();
            tessellator.func_78380_c(240);
            for (FXRegion region : ignoreDepthRegions) {
                TessellatorUtils.setColor(region.color);
                RegionRenderer.drawFrame(tessellator, region.box, region.inflate, -TileEntityRendererDispatcher.field_147554_b, -TileEntityRendererDispatcher.field_147555_c, -TileEntityRendererDispatcher.field_147552_d, false);
            }
            tessellator.func_78381_a();
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BOX_TEXTURE);
        tessellator.func_78382_b();
        tessellator.func_78380_c(240);
        for (FXRegion region : regions) {
            TessellatorUtils.setColor(region.color);
            RegionRenderer.drawFrame(tessellator, region.box, region.inflate, -TileEntityRendererDispatcher.field_147554_b, -TileEntityRendererDispatcher.field_147555_c, -TileEntityRendererDispatcher.field_147552_d, true);
        }
        tessellator.func_78381_a();
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        GL11.glEnable((int)3042);
        regions.clear();
    }

    private static void drawSides(Tessellator tessellator, Region box, double inflate, double dx, double dy, double dz) {
        double sx = box.sizeX();
        double sy = box.sizeY();
        double sz = box.sizeZ();
        tessellator.func_78373_b((double)box.x0 + dx, (double)box.y0 + dy, (double)box.z0 + dz);
        tessellator.func_78374_a(0.0, sy, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(sx, sy, 0.0, sx, 0.0);
        tessellator.func_78374_a(sx, 0.0, 0.0, sx, sy);
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, sy);
        tessellator.func_78374_a(sx, sy, sz, -sx, 0.0);
        tessellator.func_78374_a(0.0, sy, sz, 0.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, sz, 0.0, sy);
        tessellator.func_78374_a(sx, 0.0, sz, -sx, sy);
        tessellator.func_78374_a(0.0, sy, sz, sz, 0.0);
        tessellator.func_78374_a(0.0, sy, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, sy);
        tessellator.func_78374_a(0.0, 0.0, sz, sz, sy);
        tessellator.func_78374_a(sx, sy, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(sx, sy, sz, -sz, 0.0);
        tessellator.func_78374_a(sx, 0.0, sz, -sz, sy);
        tessellator.func_78374_a(sx, 0.0, 0.0, 0.0, sy);
        tessellator.func_78374_a(sx, sy, 0.0, sx, 0.0);
        tessellator.func_78374_a(0.0, sy, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(0.0, sy, sz, 0.0, sz);
        tessellator.func_78374_a(sx, sy, sz, sx, sz);
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(sx, 0.0, 0.0, -sx, 0.0);
        tessellator.func_78374_a(sx, 0.0, sz, -sx, sz);
        tessellator.func_78374_a(0.0, 0.0, sz, 0.0, sz);
    }

    private static void drawFrame(Tessellator tessellator, Region box, double inflate, double dx, double dy, double dz, boolean solid) {
        double sx = box.sizeX();
        double sy = box.sizeY();
        double sz = box.sizeZ();
        tessellator.func_78373_b((double)box.x0 + dx, (double)box.y0 + dy, (double)box.z0 + dz);
        RegionRenderer.drawSide(tessellator, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, sy, 0.0, sx, sz, inflate, solid);
        tessellator.func_78373_b((double)box.x0 + dx, (double)box.y0 + dy, (double)box.z0 + dz);
        RegionRenderer.drawSide(tessellator, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, sx, 0.0, 0.0, sz, sy, inflate, solid);
        tessellator.func_78373_b((double)box.x0 + dx, (double)box.y0 + dy, (double)box.z0 + dz);
        RegionRenderer.drawSide(tessellator, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, sz, sx, sy, inflate, solid);
    }

    private static void drawSide(Tessellator tessellator, double dx1, double dy1, double dz1, double dx2, double dy2, double dz2, double dx3, double dy3, double dz3, double w, double h, double inflate, boolean solid) {
        double ix = (dx1 + dx2) * inflate;
        double iy = (dy1 + dy2) * inflate;
        double iz = (dz1 + dz2) * inflate;
        tessellator.func_78372_c((float)(-ix), (float)(-iy), (float)(-iz));
        float delta = (float)(inflate / (dx3 + dy3 + dz3));
        double iw = w + 2.0 * inflate;
        double ih = h + 2.0 * inflate;
        double x1 = dx1 * iw;
        double y1 = dy1 * iw;
        double z1 = dz1 * iw;
        double x3 = dx2 * ih;
        double y3 = dy2 * ih;
        double z3 = dz2 * ih;
        double x2 = x1 + x3;
        double y2 = y1 + y3;
        double z2 = z1 + z3;
        double u = 0.0625;
        dx1 *= u;
        dy1 *= u;
        dz1 *= u;
        dx2 *= u;
        dy2 *= u;
        dz2 *= u;
        if (solid) {
            w = u;
            h = u;
        }
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                tessellator.func_78372_c((float)(-dx3) * delta, (float)(-dy3) * delta, (float)(-dz3) * delta);
            } else {
                float d = 1.0f + 2.0f * delta;
                tessellator.func_78372_c((float)dx3 * d, (float)dy3 * d, (float)dz3 * d);
            }
            double u0 = 0.0;
            tessellator.func_78374_a(0.0, 0.0, 0.0, u0, 0.0);
            tessellator.func_78374_a(x1, y1, z1, u0 + w, 0.0);
            tessellator.func_78374_a(x1 + dx2, y1 + dy2, z1 + dz2, u0 + w, u);
            tessellator.func_78374_a(dx2, dy2, dz2, u0, u);
            tessellator.func_78374_a(x1, y1, z1, w, u0);
            tessellator.func_78374_a(x2, y2, z2, w, u0 + h);
            tessellator.func_78374_a(x2 - dx1, y2 - dy1, z2 - dz1, w - u, u0 + h);
            tessellator.func_78374_a(x1 - dx1, y1 - dy1, z1 - dz1, w - u, u0);
            tessellator.func_78374_a(x2, y2, z2, -u0 + w, h);
            tessellator.func_78374_a(x3, y3, z3, -u0, h);
            tessellator.func_78374_a(x3 - dx2, y3 - dy2, z3 - dz2, -u0, h - u);
            tessellator.func_78374_a(x2 - dx2, y2 - dy2, z2 - dz2, -u0 + w, h - u);
            tessellator.func_78374_a(x3, y3, z3, 0.0, h - u0);
            tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, -u0);
            tessellator.func_78374_a(dx1, dy1, dz1, u, -u0);
            tessellator.func_78374_a(x3 + dx1, y3 + dy1, z3 + dz1, u, h - u0);
        }
    }

    public static class EventListener {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onRender(RenderWorldLastEvent event) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            RegionRenderer.drawAll();
        }
    }

    public static class FXRegion {
        private final Region box;
        private final int color;
        private double inflate;
        private boolean ignoreDepth;
        private boolean withSides;

        public FXRegion(Region box, int color) {
            this.box = box;
            this.color = color;
        }

        public FXRegion inflate(double inflate) {
            this.inflate = inflate;
            return this;
        }

        public FXRegion ignoreDepth() {
            this.ignoreDepth = true;
            return this;
        }

        public FXRegion withSides() {
            this.withSides = true;
            return this;
        }
    }
}

