/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe.chain;

import codechicken.nei.ItemStackAmount;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class RecipeChainMath {
    public final Map<Recipe.RecipeId, Long> outputRecipes = new HashMap<Recipe.RecipeId, Long>();
    public final List<BookmarkItem> initialItems = new ArrayList<BookmarkItem>();
    public final List<BookmarkItem> recipeIngredients = new ArrayList<BookmarkItem>();
    public final List<BookmarkItem> recipeResults = new ArrayList<BookmarkItem>();
    public final Map<BookmarkItem, BookmarkItem> preferredItems = new HashMap<BookmarkItem, BookmarkItem>();
    public final Map<BookmarkItem, Long> requiredAmount = new HashMap<BookmarkItem, Long>();

    /*
     * WARNING - void declaration
     */
    private RecipeChainMath(List<BookmarkItem> recipeItems, Set<Recipe.RecipeId> collapsedRecipes) {
        HashMap<Recipe.RecipeId, Integer> recipeState = new HashMap<Recipe.RecipeId, Integer>();
        HashMap<Recipe.RecipeId, Long> multipliers = new HashMap<Recipe.RecipeId, Long>();
        for (BookmarkItem bookmarkItem : recipeItems) {
            if (bookmarkItem.recipeId == null) continue;
            recipeState.put(bookmarkItem.recipeId, recipeState.getOrDefault(bookmarkItem.recipeId, 0) | (bookmarkItem.isIngredient ? 1 : 2));
        }
        for (BookmarkItem bookmarkItem : recipeItems) {
            if (recipeState.getOrDefault(bookmarkItem.recipeId, 0) != 3) {
                this.initialItems.add(bookmarkItem.copy());
                continue;
            }
            if (bookmarkItem.isIngredient) {
                this.recipeIngredients.add(bookmarkItem.copyWithAmount(0L));
                continue;
            }
            this.recipeResults.add(bookmarkItem.copyWithAmount(0L));
            multipliers.put(bookmarkItem.recipeId, Math.max(multipliers.getOrDefault(bookmarkItem.recipeId, 0L), bookmarkItem.getMultiplier()));
        }
        for (Map.Entry entry : multipliers.entrySet()) {
            if ((Long)entry.getValue() <= 1L && !collapsedRecipes.contains(entry.getKey())) continue;
            this.collectPreferredItems((Recipe.RecipeId)entry.getKey(), this.preferredItems, new HashSet<Recipe.RecipeId>());
            this.outputRecipes.put((Recipe.RecipeId)entry.getKey(), (Long)entry.getValue());
        }
        while (true) {
            void var6_13;
            Map maxReference = Collections.emptyMap();
            Object var6_12 = null;
            long maxMultiplier = 0L;
            int maxDepth = 0;
            for (Map.Entry entry : multipliers.entrySet()) {
                HashMap<BookmarkItem, BookmarkItem> references;
                int depth;
                Recipe.RecipeId recipeId = (Recipe.RecipeId)entry.getKey();
                if (this.outputRecipes.containsKey(recipeId) || !this.preferredItems.values().stream().noneMatch(resItem -> resItem.recipeId.equals(recipeId)) || maxDepth >= (depth = this.collectPreferredItems(recipeId, references = new HashMap<BookmarkItem, BookmarkItem>(this.preferredItems), new HashSet<Recipe.RecipeId>())) && (maxDepth != depth || (Long)entry.getValue() <= maxMultiplier)) continue;
                maxMultiplier = (Long)entry.getValue();
                maxReference = references;
                Recipe.RecipeId recipeId2 = recipeId;
                maxDepth = depth;
            }
            if (maxReference.isEmpty()) break;
            this.preferredItems.putAll(maxReference);
            this.outputRecipes.put((Recipe.RecipeId)var6_13, (Long)multipliers.get(var6_13));
        }
        for (Map.Entry entry : multipliers.entrySet()) {
            if (this.outputRecipes.containsKey(entry.getKey()) || !this.preferredItems.values().stream().noneMatch(resItem -> resItem.recipeId.equals(entry.getKey()))) continue;
            this.outputRecipes.put((Recipe.RecipeId)entry.getKey(), (Long)entry.getValue());
        }
        for (Map.Entry entry : this.outputRecipes.entrySet()) {
            if ((Long)entry.getValue() != 0L || !this.preferredItems.values().stream().noneMatch(prefItem -> prefItem.recipeId.equals(entry.getKey()))) continue;
            entry.setValue(1L);
        }
    }

    private int collectPreferredItems(Recipe.RecipeId recipeId, Map<BookmarkItem, BookmarkItem> preferredItems, Set<Recipe.RecipeId> visited) {
        int maxDepth = 0;
        visited.add(recipeId);
        for (BookmarkItem ingrItem : this.recipeIngredients) {
            if (ingrItem.factor <= 0L || !recipeId.equals(ingrItem.recipeId) || preferredItems.containsKey(ingrItem)) continue;
            BookmarkItem prefItem = null;
            for (BookmarkItem item : this.recipeResults) {
                if (item.factor <= (prefItem == null ? 0L : prefItem.factor) || !item.containsItems(ingrItem) || visited.contains(item.recipeId)) continue;
                prefItem = item;
            }
            if (prefItem == null) continue;
            preferredItems.put(ingrItem, prefItem);
            maxDepth = Math.max(maxDepth, this.collectPreferredItems(prefItem.recipeId, preferredItems, visited) + 1);
        }
        visited.remove(recipeId);
        return maxDepth;
    }

    public static RecipeChainMath of(List<BookmarkItem> chainItems, Set<Recipe.RecipeId> collapsedRecipes) {
        return new RecipeChainMath(chainItems, collapsedRecipes);
    }

    public static RecipeChainMath of(Recipe recipe, long multiplier) {
        ArrayList<BookmarkItem> chainItems = new ArrayList<BookmarkItem>();
        Recipe.RecipeId recipeId = recipe.getRecipeId();
        ItemStack result = recipe.getResult();
        chainItems.add(BookmarkItem.of(-1, result, StackInfo.getAmount(result), recipeId, false));
        for (Recipe.RecipeIngredient ingr : recipe.getIngredients()) {
            chainItems.add(BookmarkItem.of(-1, ingr.getItemStack(), ingr.getAmount(), recipeId, true, BookmarkItem.generatePermutations(ingr.getItemStack(), recipe)));
        }
        for (BookmarkItem item : chainItems) {
            item.amount *= multiplier;
        }
        return new RecipeChainMath(chainItems, Collections.emptySet());
    }

    public ItemStackAmount getMissedItems() {
        long amount;
        ItemStackAmount missedItems = new ItemStackAmount();
        for (BookmarkItem item : this.recipeResults) {
            amount = item.amount - this.requiredAmount.getOrDefault(item, 0L);
            if (amount <= 0L) continue;
            missedItems.add(item.getItemStack(amount));
        }
        for (BookmarkItem item : this.recipeIngredients) {
            amount = this.requiredAmount.containsKey(this.preferredItems.get(item)) ? 0L : this.requiredAmount.getOrDefault(item, item.amount);
            if (amount <= 0L) continue;
            missedItems.add(item.getItemStack(amount));
        }
        for (BookmarkItem item : this.initialItems) {
            if (this.requiredAmount.getOrDefault(item, -1L) != 0L) continue;
            missedItems.add(item.getItemStack());
        }
        return missedItems;
    }

    private void resetCalculation() {
        for (BookmarkItem item : this.recipeIngredients) {
            item.amount = 0L;
        }
        for (BookmarkItem item : this.recipeResults) {
            item.amount = 0L;
        }
        this.preferredItems.clear();
        this.requiredAmount.clear();
        for (Recipe.RecipeId recipeId : this.outputRecipes.keySet()) {
            this.collectPreferredItems(recipeId, this.preferredItems, new HashSet<Recipe.RecipeId>());
        }
    }

    public RecipeChainMath refresh() {
        long prefAmount;
        this.resetCalculation();
        for (BookmarkItem prefItem : this.recipeResults) {
            if (prefItem.factor <= 0L || !this.outputRecipes.containsKey(prefItem.recipeId)) continue;
            prefAmount = prefItem.factor * this.outputRecipes.get(prefItem.recipeId);
            this.preferredItems.put(prefItem, prefItem);
            this.calculateSuitableRecipe(prefItem, this.prepareAmount(prefItem, prefAmount), new ArrayList<Recipe.RecipeId>());
            this.preferredItems.remove(prefItem);
        }
        for (BookmarkItem prefItem : this.recipeResults) {
            if (prefItem.factor <= 0L || !this.outputRecipes.containsKey(prefItem.recipeId) || !this.requiredAmount.containsKey(prefItem)) continue;
            prefAmount = prefItem.factor * this.outputRecipes.get(prefItem.recipeId);
            this.requiredAmount.put(prefItem, this.requiredAmount.get(prefItem) - prefAmount);
        }
        return this;
    }

    private void prepareIngredients(Recipe.RecipeId recipeId, long stepShift, List<Recipe.RecipeId> visited) {
        for (BookmarkItem item : this.recipeIngredients) {
            if (item.factor <= 0L || !recipeId.equals(item.recipeId)) continue;
            this.calculateSuitableRecipe(item, this.prepareAmount(item, item.factor * stepShift), visited);
        }
    }

    private void calculateSuitableRecipe(BookmarkItem ingrItem, long ingrAmount, List<Recipe.RecipeId> visited) {
        BookmarkItem prefItem = this.preferredItems.get(ingrItem);
        if (prefItem == null) {
            this.requiredAmount.put(ingrItem, this.requiredAmount.getOrDefault(ingrItem, 0L) + ingrAmount);
        } else if (visited.contains(prefItem.recipeId)) {
            this.requiredAmount.put(prefItem, this.requiredAmount.getOrDefault(prefItem, 0L) + ingrAmount);
        } else {
            this.requiredAmount.put(prefItem, this.requiredAmount.getOrDefault(prefItem, 0L) + ingrAmount);
            long shift = (long)Math.ceil((double)(this.requiredAmount.get(prefItem) - prefItem.amount) / (double)prefItem.factor);
            if (shift > 0L) {
                this.addShift(prefItem.recipeId, shift);
                visited.add(prefItem.recipeId);
                this.prepareIngredients(prefItem.recipeId, shift, visited);
                visited.remove(prefItem.recipeId);
            }
        }
    }

    private long prepareAmount(BookmarkItem ingrItem, long ingrAmount) {
        if (ingrAmount == 0L) {
            return 0L;
        }
        for (BookmarkItem item : this.initialItems) {
            long initAmount;
            if (!item.containsItems(ingrItem) || (initAmount = Math.min(ingrAmount, item.amount - this.requiredAmount.getOrDefault(item, 0L))) <= 0L) continue;
            this.requiredAmount.put(item, this.requiredAmount.getOrDefault(item, 0L) + initAmount);
            if ((ingrAmount -= initAmount) != 0L) continue;
            break;
        }
        return ingrAmount;
    }

    private void addShift(Recipe.RecipeId recipeId, long shift) {
        for (BookmarkItem item : this.recipeIngredients) {
            if (!recipeId.equals(item.recipeId)) continue;
            item.amount += item.factor * shift;
        }
        for (BookmarkItem item : this.recipeResults) {
            if (!recipeId.equals(item.recipeId)) continue;
            item.amount += item.factor * shift;
        }
    }
}

