/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.bookmark;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.BookmarkPanel;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemStackAmount;
import codechicken.nei.ItemsGrid;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.bookmark.BookmarkGridGenerator;
import codechicken.nei.bookmark.BookmarkGroup;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.bookmark.BookmarksGridSlot;
import codechicken.nei.bookmark.GroupingItem;
import codechicken.nei.bookmark.SortableGroup;
import codechicken.nei.bookmark.SortableItem;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.chain.RecipeChainMath;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class BookmarkGrid
extends ItemsGrid<BookmarksGridSlot, BookmarkMouseContext> {
    protected static final Color DRAG_COLOR = new Color(0x66555555, true);
    public static final Color GROUP_CHAIN_COLOR = new Color(1715853941, true);
    public static final Color GROUP_NONE_COLOR = new Color(-10066330, true);
    public static final Color RECIPE_COLOR = new Color(-1717554272, true);
    public static final Color PLACEHOLDER_COLOR = new Color(0x66222222, true);
    public static final int DEFAULT_GROUP_ID = 0;
    protected static final int GROUP_PANEL_WIDTH = 7;
    protected static final float SCALE_SPEED = 0.1f;
    protected List<BookmarkItem> bookmarkItems = new ArrayList<BookmarkItem>();
    protected final WeakHashMap<BookmarkItem, Float> animation = new WeakHashMap();
    protected final Map<Integer, BookmarkGroup> groups = new HashMap<Integer, BookmarkGroup>();
    protected final BookmarkGridGenerator gridGenerator;
    private boolean isDirty = false;

    public BookmarkGrid() {
        this.groups.put(0, new BookmarkGroup(BookmarkPanel.BookmarkViewMode.DEFAULT));
        this.gridGenerator = new BookmarkGridGenerator(this);
    }

    public BookmarkPanel.BookmarkViewMode getViewMode(int groupId) {
        return this.groups.get((Object)Integer.valueOf((int)groupId)).viewMode;
    }

    public void setViewMode(int groupId, BookmarkPanel.BookmarkViewMode mode) {
        if (this.groups.get((Object)Integer.valueOf((int)groupId)).viewMode != mode) {
            this.groups.get((Object)Integer.valueOf((int)groupId)).viewMode = mode;
            this.onItemsChanged();
        }
    }

    public void toggleViewMode(int groupId) {
        this.groups.get(groupId).toggleViewMode();
        this.onItemsChanged();
    }

    public void toggleCollapsedState(int groupId) {
        this.groups.get(groupId).toggleCollapsedState();
        this.onItemsChanged();
    }

    public void toggleCollapsedRecipe(int groupId, Recipe.RecipeId recipeId) {
        BookmarkGroup group = this.getGroup(groupId);
        Recipe.RecipeId collapsedRecipeId = group.crafting.recipeRelations.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(recipeId)).map(entry -> (Recipe.RecipeId)entry.getKey()).findAny().orElse(recipeId);
        group.toggleCollapsedRecipe(collapsedRecipeId);
        if (group.crafting.recipeInMiddle.contains(collapsedRecipeId)) {
            if (group.collapsedRecipes.contains(collapsedRecipeId)) {
                for (BookmarkItem item : this.bookmarkItems) {
                    if (item.groupId != groupId || !collapsedRecipeId.equals(item.recipeId) || item.amount != item.factor) continue;
                    item.amount = 0L;
                }
            } else {
                for (BookmarkItem item : this.bookmarkItems) {
                    if (item.groupId != groupId || !collapsedRecipeId.equals(item.recipeId) || item.amount != 0L) continue;
                    item.amount = item.factor;
                }
            }
        }
        this.onItemsChanged();
    }

    public boolean isCraftingMode(int groupId) {
        return this.groups.get((Object)Integer.valueOf((int)groupId)).crafting != null;
    }

    public void setCraftingMode(int groupId, boolean on) {
        this.groups.get(groupId).setCraftingMode(on);
        this.onItemsChanged();
    }

    public void toggleCraftingMode(int groupId) {
        this.groups.get(groupId).toggleCraftingMode();
        this.onItemsChanged();
    }

    public BookmarkGroup getGroup(int groupId) {
        return this.groups.get(groupId);
    }

    public int addGroup(BookmarkGroup group) {
        int groupId = this.bookmarkItems.stream().mapToInt(item -> item.groupId).max().orElse(0) + 1;
        this.groups.put(groupId, group);
        return groupId;
    }

    @Override
    public int getNumPages() {
        if (this.gridGenerator.gridMask == null) {
            this.getMask();
        }
        return this.gridGenerator.pageCount;
    }

    @Override
    public int size() {
        return this.bookmarkItems.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bookmarkItems.isEmpty();
    }

    @Override
    public List<BookmarksGridSlot> getMask() {
        if (this.isDirty) {
            this.isDirty = false;
            this.bookmarkItems = new ArrayList<BookmarkItem>(new LinkedHashSet<BookmarkItem>(this.bookmarkItems));
            this.sortIngredients();
            this.realItems.clear();
            for (BookmarkItem item : this.bookmarkItems) {
                this.realItems.add(item.itemStack);
            }
        }
        if (this.gridGenerator.gridMask != null) {
            return this.gridGenerator.gridMask;
        }
        this.gridGenerator.generate();
        this.page = Math.max(0, Math.min(this.page, this.gridGenerator.pageCount - 1));
        if (ItemPanels.bookmarkPanel.sortableItem != null) {
            ItemPanels.bookmarkPanel.sortableItem.update();
        }
        return this.gridGenerator.gridMask;
    }

    @Override
    protected BookmarkMouseContext getMouseContext(int mousex, int mousey) {
        if (this.contains(mousex, mousey) && !LayoutManager.bookmarkPanel.inEditingState()) {
            return this.generateMouseContext(mousex, mousey);
        }
        return null;
    }

    private BookmarkMouseContext generateMouseContext(int mousex, int mousey) {
        BookmarksGridSlot hovered = (BookmarksGridSlot)this.getSlotMouseOver(mousex, mousey);
        if (hovered != null) {
            return new BookmarkMouseContext(hovered.slotIndex, hovered.slotIndex / this.columns, hovered.slotIndex % this.columns, hovered.getGroupId(), this.gridGenerator.itemToRecipe.getOrDefault(hovered.itemIndex, hovered.getRecipeId()));
        }
        int rowIndex = this.getHoveredRowIndex(false);
        if (rowIndex != -1) {
            int groupId = this.getRowGroupId(rowIndex);
            int rowItemIndex = this.getRowItemIndex(rowIndex, false);
            if (rowItemIndex != Integer.MIN_VALUE) {
                int columnIndex = this.getColumnIndex(mousex);
                BookmarkGroup group = this.getGroup(groupId);
                Recipe.RecipeId recipeId = null;
                if (!group.collapsed) {
                    recipeId = this.gridGenerator.itemToRecipe.getOrDefault(rowItemIndex, this.getCalculatedItem((int)rowItemIndex).recipeId);
                }
                return new BookmarkMouseContext(-1, rowIndex, columnIndex < 0 || columnIndex > this.columns ? -1 : columnIndex, groupId, recipeId);
            }
        }
        return null;
    }

    public int getRowGroupId(int rowIndex) {
        if (this.gridGenerator.gridMask == null) {
            this.getMask();
        }
        return this.gridGenerator.getRowGroupId(rowIndex);
    }

    public int getRowItemIndex(int rowIndex, boolean firstItemIndex) {
        if (this.gridGenerator.gridMask == null) {
            this.getMask();
        }
        int absoluteSlotIndex = (this.page * this.rows + rowIndex) * this.columns + (firstItemIndex ? 0 : this.columns - 1);
        for (int index = 0; index < this.columns; ++index) {
            if (!this.gridGenerator.slotToItem.containsKey(absoluteSlotIndex + index * (firstItemIndex ? 1 : -1))) continue;
            return this.gridGenerator.slotToItem.get(absoluteSlotIndex + index * (firstItemIndex ? 1 : -1));
        }
        return Integer.MIN_VALUE;
    }

    public int getHoveredRowIndex(boolean groupPanel) {
        Point mouse = GuiDraw.getMousePosition();
        int leftBorder = this.marginLeft + this.paddingLeft;
        int r = this.getRowIndex(mouse.y);
        if (this.isEmpty()) {
            return -1;
        }
        if (!new Rectangle4i(leftBorder - (groupPanel ? 7 : 0), this.marginTop, this.columns * SLOT_SIZE, (this.getLastRowIndex() + 1) * SLOT_SIZE).contains(mouse.x, mouse.y)) {
            return -1;
        }
        if (groupPanel && mouse.x >= leftBorder - 7 && mouse.x < leftBorder) {
            return r;
        }
        if (!groupPanel && !this.isInvalidSlot(this.columns * r + (mouse.x - leftBorder) / SLOT_SIZE)) {
            return r;
        }
        return -1;
    }

    @Override
    public void setGridSize(int mleft, int mtop, int w, int h) {
        super.setGridSize(mleft + 7, mtop, w - 7, h);
    }

    private void sortIngredients() {
        for (int itemIndex = 0; itemIndex < this.bookmarkItems.size(); ++itemIndex) {
            BookmarkItem item = this.bookmarkItems.get(itemIndex);
            if (item.groupId == 0) continue;
            List items = this.bookmarkItems.stream().filter(itm -> itm.groupId == item.groupId).collect(Collectors.toList());
            this.bookmarkItems.removeAll(items);
            this.bookmarkItems.addAll(itemIndex, items);
            itemIndex += items.size() - 1;
        }
        for (Map.Entry<Integer, BookmarkGroup> entry : this.groups.entrySet()) {
            HashMap<Recipe.RecipeId, Integer> recipeState = new HashMap<Recipe.RecipeId, Integer>();
            BookmarkGroup group = entry.getValue();
            int groupId = entry.getKey();
            if (group.viewMode == BookmarkPanel.BookmarkViewMode.TODO_LIST || group.crafting != null) {
                this.sortItemsInsideGroup(groupId);
            }
            for (BookmarkItem item : this.bookmarkItems) {
                if (item.groupId != groupId || item.recipeId == null) continue;
                recipeState.put(item.recipeId, recipeState.getOrDefault(item.recipeId, 0) | (item.isIngredient ? 1 : 2));
            }
            for (BookmarkItem item : this.bookmarkItems) {
                if (item.groupId != groupId || !item.isIngredient || item.recipeId != null && recipeState.getOrDefault(item.recipeId, 1) != 1) continue;
                recipeState.remove(item.recipeId);
                item.isIngredient = false;
                item.recipeId = null;
            }
            group.collapsedRecipes.removeIf(recipeId -> !recipeState.containsKey(recipeId));
            if (group.crafting == null) continue;
            group.crafting.refresh(this.createChainItems(groupId), group.collapsedRecipes);
        }
    }

    public void sortItemsInsideGroup(int groupId) {
        int size = this.bookmarkItems.size();
        int itemIndex = 0;
        while (itemIndex < size) {
            BookmarkItem item = this.bookmarkItems.get(itemIndex);
            if (item.groupId == groupId && item.recipeId != null) {
                HashMap<Integer, Integer> sortingRank = new HashMap<Integer, Integer>();
                ArrayList<BookmarkItem> sortedItems = new ArrayList<BookmarkItem>();
                ArrayList<Integer> items = new ArrayList<Integer>();
                for (int index = itemIndex; index < size; ++index) {
                    if (!item.equalsRecipe(this.bookmarkItems.get(index))) continue;
                    sortingRank.put(index, this.bookmarkItems.get((int)index).isIngredient ? 1 : -1);
                    items.add(index);
                }
                items.sort((a, b) -> (Integer)sortingRank.get(a) - (Integer)sortingRank.get(b));
                Iterator iterator = items.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    sortedItems.add(this.bookmarkItems.get(index));
                }
                this.bookmarkItems.removeAll(sortedItems);
                this.bookmarkItems.addAll(itemIndex, sortedItems);
                itemIndex += sortedItems.size();
                continue;
            }
            ++itemIndex;
        }
    }

    @Override
    public void draw(int mousex, int mousey) {
        if (this.getPerPage() == 0) {
            return;
        }
        if (this.gridGenerator.gridMask == null) {
            this.getMask();
        }
        if (!this.isEmpty() && this.gridGenerator.maxAbsoluteSlotIndex > 0) {
            int rowIndex;
            int focusedRowIndex;
            GroupingItem groupingItem = ItemPanels.bookmarkPanel.groupingItem;
            int sortableGroupId = ItemPanels.bookmarkPanel.sortableGroup != null ? ItemPanels.bookmarkPanel.sortableGroup.groupId : -3;
            int rowShift = this.page * this.rows;
            Map<Integer, Integer> groups = this.gridGenerator.rowToGroupId;
            if (groupingItem != null && groupingItem.hasEndRow()) {
                groups = groupingItem.prepareGroups(groups);
            } else if (sortableGroupId != -3) {
                for (int rowIndex2 = 0; rowIndex2 < this.rows; ++rowIndex2) {
                    if (groups.getOrDefault(rowShift + rowIndex2, 0) != sortableGroupId) continue;
                    NEIClientUtils.drawRect(this.marginLeft + this.paddingLeft - 7, this.marginTop + rowIndex2 * SLOT_SIZE, 7.0, SLOT_SIZE, DRAG_COLOR);
                }
            } else if (!ItemPanels.bookmarkPanel.inEditingState() && (focusedRowIndex = this.getHoveredRowIndex(true)) != -1) {
                NEIClientUtils.drawRect(this.marginLeft + this.paddingLeft - 7, this.marginTop + focusedRowIndex * SLOT_SIZE, 7.0, SLOT_SIZE, HIGHLIGHT_COLOR);
            }
            int previousPageGroupId = groups.getOrDefault(rowShift - 1, 0);
            int nextPageGroupId = groups.getOrDefault(rowShift + this.rows, 0);
            int previousGroupId = 0;
            int groupStartIndex = -2;
            if (previousPageGroupId == groups.get(rowShift)) {
                previousGroupId = previousPageGroupId;
                groupStartIndex = -1;
            }
            for (rowIndex = 0; rowIndex < this.rows && groups.containsKey(rowShift + rowIndex); ++rowIndex) {
                int groupId = groups.get(rowShift + rowIndex);
                if (groupStartIndex != -2 && previousGroupId != groupId) {
                    if (previousGroupId != 0 && previousGroupId != sortableGroupId) {
                        this.drawGroup(previousGroupId, groupStartIndex, rowIndex - 1);
                    } else {
                        this.drawShadowGroup(groupStartIndex, rowIndex - 1);
                    }
                    groupStartIndex = -2;
                }
                if (groupStartIndex == -2) {
                    groupStartIndex = rowIndex;
                }
                previousGroupId = groupId;
            }
            if (groupStartIndex != -2) {
                int n = rowIndex = nextPageGroupId != 0 && nextPageGroupId == groups.get(rowShift + this.rows - 1) ? this.rows : this.getLastRowIndex();
                if (previousGroupId != 0 && previousGroupId != sortableGroupId) {
                    this.drawGroup(previousGroupId, groupStartIndex, rowIndex);
                } else {
                    this.drawShadowGroup(groupStartIndex, rowIndex);
                }
            }
        }
        super.draw(mousex, mousey);
    }

    public void drawGroup(int groupId, int rowIndexStart, int rowIndexEnd) {
        int halfWidth = 3;
        int heightPadding = SLOT_SIZE / 4;
        int leftPosition = this.marginLeft + this.paddingLeft - 3 - 1;
        Color color = groupId > 0 && this.groups.get((Object)Integer.valueOf((int)groupId)).crafting != null ? GROUP_CHAIN_COLOR : GROUP_NONE_COLOR;
        int height = (Math.min(rowIndexEnd, this.rows - 1) - Math.max(0, rowIndexStart) + 1) * SLOT_SIZE;
        int top = this.marginTop + Math.max(0, rowIndexStart) * SLOT_SIZE;
        if (rowIndexStart >= 0) {
            NEIClientUtils.drawRect(leftPosition, this.marginTop + rowIndexStart * SLOT_SIZE + heightPadding, 3.0, 1.0, color);
            top += heightPadding + 1;
            height -= heightPadding + 1;
        }
        if (rowIndexEnd < this.rows) {
            NEIClientUtils.drawRect(leftPosition, this.marginTop + (rowIndexEnd + 1) * SLOT_SIZE - heightPadding, 3.0, 1.0, color);
            height -= heightPadding;
        }
        NEIClientUtils.drawRect(leftPosition, top, 1.0, height, color);
    }

    private void drawShadowGroup(int rowIndexStart, int rowIndexEnd) {
        int top = this.marginTop + Math.max(0, rowIndexStart) * SLOT_SIZE;
        int height = (Math.min(rowIndexEnd, this.rows - 1) - Math.max(0, rowIndexStart) + 1) * SLOT_SIZE;
        NEIClientUtils.drawRect(this.marginLeft + this.paddingLeft - 3 - 1, top + 2, 1.0, height - 4, PLACEHOLDER_COLOR);
    }

    @Override
    public void onItemsChanged() {
        this.isDirty = true;
        this.onGridChanged();
    }

    @Override
    public void onGridChanged() {
        this.gridGenerator.gridMask = null;
        super.onGridChanged();
    }

    public Map<Integer, BookmarkItem> createChainItems(int groupId) {
        HashMap<Integer, BookmarkItem> chainItems = new HashMap<Integer, BookmarkItem>();
        for (int itemIndex = 0; itemIndex < this.bookmarkItems.size(); ++itemIndex) {
            BookmarkItem item = this.bookmarkItems.get(itemIndex);
            if (item.groupId != groupId) continue;
            chainItems.put(itemIndex, item.copy());
        }
        return chainItems;
    }

    public RecipeChainMath createRecipeChainMath(int groupId) {
        return this.createRecipeChainMath(groupId, null);
    }

    public RecipeChainMath createRecipeChainMath(int groupId, Recipe.RecipeId recipeId) {
        BookmarkGroup group = this.getGroup(groupId);
        ArrayList<BookmarkItem> chainItems = new ArrayList<BookmarkItem>();
        Set<Recipe.RecipeId> collapsedRecipes = group.crafting != null && recipeId == null ? group.collapsedRecipes : Collections.emptySet();
        Set<Recipe.RecipeId> recipeRelations = null;
        if (group.collapsed) {
            recipeId = null;
        }
        if (group.crafting != null && recipeId != null) {
            for (Map.Entry<Recipe.RecipeId, Set<Recipe.RecipeId>> entry : group.crafting.recipeRelations.entrySet()) {
                if (!entry.getValue().contains(recipeId)) continue;
                recipeId = entry.getKey();
                break;
            }
        }
        if (group.crafting != null && group.crafting.recipeRelations.containsKey(recipeId)) {
            recipeRelations = group.crafting.recipeRelations.get(recipeId);
        } else if (recipeId != null) {
            recipeRelations = new HashSet<Recipe.RecipeId>(Arrays.asList(recipeId));
        }
        for (int itemIndex = 0; itemIndex < this.bookmarkItems.size(); ++itemIndex) {
            BookmarkItem item = this.bookmarkItems.get(itemIndex);
            if (item.groupId != groupId || recipeRelations != null && !recipeRelations.contains(item.recipeId)) continue;
            long amount = item.amount;
            if (recipeId != null && group.crafting != null && group.crafting.calculatedItems.containsKey(itemIndex) && recipeId.equals(item.recipeId)) {
                amount = group.crafting.calculatedItems.get(itemIndex).getCalculatedAmount();
            }
            chainItems.add(item.copyWithAmount(amount));
        }
        if (group.crafting == null) {
            for (BookmarkItem item : chainItems) {
                item.recipeId = null;
            }
        }
        return RecipeChainMath.of(chainItems, collapsedRecipes);
    }

    public void createGroup(GroupingItem groupingItem) {
        Map<Integer, List<BookmarkItem>> rowItems = this.collectItemsToRows();
        HashMap<Integer, Integer> newGroups = new HashMap<Integer, Integer>();
        boolean change = false;
        for (Map.Entry<Integer, Integer> entry : groupingItem.prepareGroups(this.gridGenerator.rowToGroupId).entrySet()) {
            if (this.gridGenerator.rowToGroupId.get(entry.getKey()) == entry.getValue()) continue;
            int groupId = entry.getValue();
            if (groupId == Integer.MIN_VALUE) {
                groupId = newGroups.computeIfAbsent(groupId, grId -> this.addGroup(new BookmarkGroup(this.getViewMode(0))));
            } else if (groupId < 0) {
                groupId = newGroups.computeIfAbsent(groupId, grId -> this.addGroup(new BookmarkGroup(this.getViewMode(Math.abs(grId)))));
            }
            for (BookmarkItem item : rowItems.getOrDefault(entry.getKey(), Collections.emptyList())) {
                item.groupId = groupId;
            }
            change = true;
        }
        if (change) {
            this.bookmarkItems = rowItems.values().stream().flatMap(items -> items.stream()).collect(Collectors.toList());
            HashSet<Integer> usedGroupIds = new HashSet<Integer>();
            for (BookmarkItem item : this.bookmarkItems) {
                usedGroupIds.add(item.groupId);
            }
            this.groups.keySet().removeIf(k -> k != 0 && !usedGroupIds.contains(k));
            this.onItemsChanged();
        }
    }

    private Map<Integer, List<BookmarkItem>> collectItemsToRows() {
        HashMap<Integer, List<BookmarkItem>> results = new HashMap<Integer, List<BookmarkItem>>();
        int totalRows = (int)Math.ceil((float)this.gridGenerator.maxAbsoluteSlotIndex / (float)this.columns);
        ArrayList<BookmarkItem> allItems = new ArrayList<BookmarkItem>(this.bookmarkItems);
        for (int rowIndex = 0; rowIndex < totalRows; ++rowIndex) {
            int itemIndex = Integer.MIN_VALUE;
            for (int index = 0; index < this.columns; ++index) {
                if (!this.gridGenerator.slotToItem.containsKey(rowIndex * this.columns + index)) continue;
                itemIndex = this.gridGenerator.slotToItem.get(rowIndex * this.columns + index);
                break;
            }
            if (itemIndex == Integer.MIN_VALUE) continue;
            BookmarkItem item = this.getCalculatedItem(itemIndex);
            BookmarkGroup group = this.getGroup(item.groupId);
            ArrayList<BookmarkItem> items = new ArrayList<BookmarkItem>();
            if (group.collapsed || group.crafting != null && group.viewMode == BookmarkPanel.BookmarkViewMode.DEFAULT) {
                for (BookmarkItem bookmarkItem : allItems) {
                    if (bookmarkItem.groupId != item.groupId) continue;
                    items.add(bookmarkItem);
                }
            } else if (item.recipeId != null && group.crafting != null && group.crafting.itemToRecipe.containsKey(itemIndex)) {
                Set<Recipe.RecipeId> recipeRelations = group.crafting.recipeRelations.getOrDefault(item.recipeId, Collections.singleton(item.recipeId));
                for (BookmarkItem itm3 : allItems) {
                    if (itm3.groupId != item.groupId || !recipeRelations.contains(itm3.recipeId)) continue;
                    items.add(itm3);
                }
            } else {
                for (int index = 0; index < this.columns; ++index) {
                    BookmarkItem bookmarkItem;
                    if (!this.gridGenerator.slotToItem.containsKey(rowIndex * this.columns + index) || !allItems.contains(bookmarkItem = this.bookmarkItems.get(this.gridGenerator.slotToItem.get(rowIndex * this.columns + index)))) continue;
                    items.add(bookmarkItem);
                }
            }
            results.put(rowIndex, items);
            allItems.removeAll(items);
        }
        results.put(totalRows, allItems);
        return results;
    }

    public void removeGroup(int groupId) {
        this.bookmarkItems.removeIf(item -> item.groupId == groupId);
        if (groupId != 0) {
            this.groups.remove(groupId);
        }
        this.onItemsChanged();
    }

    public void moveGroup(SortableGroup sortableGroup, int overRowIndex) {
        int itemIndex;
        int absoluteRowIndex = this.page * this.rows + overRowIndex;
        int absoluteSlotIndex = absoluteRowIndex * this.columns;
        int overGroupId = this.getRowGroupId(overRowIndex);
        if (sortableGroup.groupId == overGroupId) {
            return;
        }
        boolean mouseDown = false;
        for (int rowId = 0; rowId < absoluteRowIndex && !mouseDown; ++rowId) {
            if (this.gridGenerator.rowToGroupId.get(rowId) != sortableGroup.groupId) continue;
            mouseDown = true;
        }
        if (mouseDown) {
            ++absoluteRowIndex;
            absoluteSlotIndex += this.columns;
        }
        if (mouseDown && absoluteSlotIndex >= this.gridGenerator.maxAbsoluteSlotIndex) {
            itemIndex = this.gridGenerator.slotToItem.getOrDefault(this.gridGenerator.maxAbsoluteSlotIndex - 1, Integer.MIN_VALUE);
            if (itemIndex == Integer.MIN_VALUE || this.getCalculatedItem((int)itemIndex).groupId == sortableGroup.groupId) {
                return;
            }
            this.moveItems(null, sortableGroup.getBookmarkItems());
        } else if (this.gridGenerator.rowToGroupId.containsKey(absoluteRowIndex)) {
            overGroupId = this.gridGenerator.rowToGroupId.get(absoluteRowIndex);
            if (overGroupId != 0 && overGroupId == this.gridGenerator.rowToGroupId.getOrDefault(absoluteRowIndex - 1, 0)) {
                return;
            }
            itemIndex = this.gridGenerator.slotToItem.getOrDefault(absoluteSlotIndex, Integer.MIN_VALUE);
            BookmarkItem bookmarkItem = this.getCalculatedItem(itemIndex);
            if (bookmarkItem == null) {
                return;
            }
            if (bookmarkItem.groupId != 0) {
                for (int i = 0; i < this.bookmarkItems.size(); ++i) {
                    if (this.bookmarkItems.get((int)i).groupId != bookmarkItem.groupId) continue;
                    bookmarkItem = this.bookmarkItems.get(i);
                    break;
                }
            }
            this.moveItems(bookmarkItem, sortableGroup.getBookmarkItems());
        }
    }

    public int indexOf(int groupId, ItemStack stackA, Recipe.RecipeId recipeId, boolean ingredient) {
        for (int itemIndex = 0; itemIndex < this.bookmarkItems.size(); ++itemIndex) {
            BookmarkItem item = this.bookmarkItems.get(itemIndex);
            if (item.groupId != groupId || item.isIngredient != ingredient || recipeId != item.recipeId && (recipeId == null || !recipeId.equals(item.recipeId)) || !StackInfo.equalItemAndNBT(stackA, item.itemStack, true)) continue;
            return itemIndex;
        }
        return -1;
    }

    public BookmarkItem getCalculatedItem(int itemIndex) {
        if (this.gridGenerator.caclulatedItems.containsKey(itemIndex)) {
            return this.gridGenerator.caclulatedItems.get(itemIndex).getItem();
        }
        return null;
    }

    public BookmarkItem getBookmarkItem(int itemIndex) {
        if (itemIndex < 0 || itemIndex >= this.bookmarkItems.size()) {
            return null;
        }
        return this.bookmarkItems.get(itemIndex);
    }

    public int getAbsoluteSlotIndex(int itemIndex) {
        return this.gridGenerator.itemToSlot.getOrDefault(itemIndex, -1);
    }

    public List<Integer> getSortedItems() {
        return new ArrayList<Integer>(this.gridGenerator.slotToItem.values());
    }

    public void addItem(BookmarkItem item, boolean animate) {
        this.bookmarkItems.add(item);
        if (animate && NEIClientConfig.getGridRenderingCacheMode() == 0 && NEIClientConfig.areBookmarksAnimated()) {
            this.animation.put(item, Float.valueOf(0.0f));
        }
        this.onItemsChanged();
    }

    public void addRecipe(Recipe recipe, int groupId) {
        Recipe.RecipeId recipeId = recipe.getRecipeId();
        List<ItemStack> results = recipe.getResults().stream().map(res -> res.getItemStack()).collect(Collectors.toList());
        List<ItemStack> ingredients = recipe.getIngredients().stream().map(ingr -> ingr.getItemStack()).collect(Collectors.toList());
        for (ItemStack stack : ItemStackAmount.of(results).values()) {
            this.addItem(BookmarkItem.of(groupId, stack, StackInfo.getAmount(stack), recipeId, false), true);
        }
        for (ItemStack stack : ItemStackAmount.of(ingredients).values()) {
            this.addItem(BookmarkItem.of(groupId, stack, StackInfo.getAmount(stack), recipeId, true, BookmarkItem.generatePermutations(stack, recipe)), true);
        }
    }

    public void removeRecipe(int itemIndex, boolean removeFullRecipe) {
        BookmarkItem item = this.getCalculatedItem(itemIndex);
        if (item == null) {
            return;
        }
        if (!removeFullRecipe && item.recipeId != null && !item.isIngredient) {
            removeFullRecipe = this.bookmarkItems.stream().noneMatch(m -> !m.isIngredient && !m.equals(item) && item.equalsRecipe((BookmarkItem)m));
        }
        if (item.recipeId != null && removeFullRecipe) {
            this.removeRecipe(item.recipeId, item.groupId);
        } else {
            this.bookmarkItems.remove(itemIndex);
            this.onItemsChanged();
        }
    }

    public boolean removeRecipe(Recipe.RecipeId recipeId, int groupId) {
        if (this.bookmarkItems.removeIf(item -> item.equalsRecipe(recipeId, groupId))) {
            this.onItemsChanged();
            return true;
        }
        return false;
    }

    public boolean existsRecipe(Recipe.RecipeId recipeId, int groupId) {
        return this.bookmarkItems.stream().anyMatch(item -> item.equalsRecipe(recipeId, groupId));
    }

    public Recipe.RecipeId getRecipeId(int itemIndex) {
        BookmarkItem bookmarkItem = this.getCalculatedItem(itemIndex);
        return bookmarkItem != null ? bookmarkItem.recipeId : null;
    }

    public void moveItem(SortableItem sortableItem, int overRowIndex, int overGroupId, boolean moveAfter) {
        BookmarkGroup overGroup = this.getGroup(overGroupId);
        int absoluteSlotIndex = (this.page * this.rows + overRowIndex) * this.columns;
        if (sortableItem.isCollapsedRecipe && sortableItem.bookmarkItem.groupId != overGroupId || overGroup.collapsed || overGroup.viewMode == BookmarkPanel.BookmarkViewMode.DEFAULT) {
            return;
        }
        if (sortableItem.bookmarkItem.groupId != overGroupId) {
            for (BookmarkItem item : this.bookmarkItems) {
                if (!sortableItem.containsItem(item)) continue;
                item.groupId = overGroupId;
            }
            sortableItem.bookmarkItem.groupId = overGroupId;
            this.onItemsChanged();
        }
        if (moveAfter) {
            absoluteSlotIndex += this.columns;
        }
        if (moveAfter && absoluteSlotIndex >= this.gridGenerator.maxAbsoluteSlotIndex) {
            int itemIndex = this.gridGenerator.slotToItem.getOrDefault(this.gridGenerator.maxAbsoluteSlotIndex - 1, Integer.MIN_VALUE);
            if (itemIndex == Integer.MIN_VALUE || sortableItem.items.contains(itemIndex)) {
                return;
            }
            this.moveItems(null, sortableItem.getBookmarkItems());
        } else if (this.gridGenerator.slotToItem.containsKey(absoluteSlotIndex)) {
            Recipe.RecipeId recipeId;
            int itemIndex = this.gridGenerator.slotToItem.get(absoluteSlotIndex);
            ArrayList<Integer> sortedIndexes = new ArrayList<Integer>(this.gridGenerator.slotToItem.values());
            BookmarkItem bookmarkItem = this.getCalculatedItem(itemIndex);
            BookmarkGroup group = this.getGroup(bookmarkItem.groupId);
            int sortIndex = sortedIndexes.indexOf(itemIndex);
            if (sortIndex == -1 || sortableItem.items.contains(itemIndex) || sortIndex > 0 && sortableItem.items.contains(sortedIndexes.get(sortIndex - 1))) {
                return;
            }
            if (group.crafting != null && sortIndex > 0 && (recipeId = group.crafting.itemToRecipe.getOrDefault(itemIndex, bookmarkItem.recipeId)) != null) {
                if (recipeId.equals(this.gridGenerator.itemToRecipe.get(sortedIndexes.get(sortIndex - 1)))) {
                    return;
                }
                for (int i = 0; i < this.bookmarkItems.size(); ++i) {
                    if (this.bookmarkItems.get((int)i).groupId != bookmarkItem.groupId || !recipeId.equals(this.bookmarkItems.get((int)i).recipeId)) continue;
                    bookmarkItem = this.bookmarkItems.get(i);
                    break;
                }
            }
            this.moveItems(bookmarkItem, sortableItem.getBookmarkItems());
        }
    }

    public void moveItem(SortableItem sortableItem, int itemIndex) {
        ArrayList<Integer> sortedIndexes = new ArrayList<Integer>(this.gridGenerator.slotToItem.values());
        int sortIndex = sortedIndexes.indexOf(itemIndex);
        boolean moveAfter = sortIndex > sortedIndexes.indexOf(sortableItem.getItemIndex());
        BookmarkGroup group = this.getGroup(sortableItem.bookmarkItem.groupId);
        BookmarkItem bookmarkItem = this.getCalculatedItem(itemIndex);
        if (bookmarkItem == null || sortIndex == -1 || sortableItem.items.contains(itemIndex) || group.collapsed) {
            return;
        }
        if (moveAfter) {
            sortIndex = this.findNextBookmarkItem(itemIndex);
            if (sortIndex == -1) {
                return;
            }
            bookmarkItem = sortIndex < sortedIndexes.size() ? this.getCalculatedItem((Integer)sortedIndexes.get(sortIndex)) : null;
        }
        if (bookmarkItem != null && (group.crafting != null && group.viewMode == BookmarkPanel.BookmarkViewMode.DEFAULT || group.viewMode == BookmarkPanel.BookmarkViewMode.TODO_LIST)) {
            while (sortIndex > 0 && bookmarkItem.equalsRecipe(this.getCalculatedItem((Integer)sortedIndexes.get(sortIndex - 1)))) {
                --sortIndex;
            }
            bookmarkItem = this.getCalculatedItem((Integer)sortedIndexes.get(sortIndex));
        }
        this.moveItems(bookmarkItem, sortableItem.getBookmarkItems());
    }

    private int findNextBookmarkItem(int itemIndex) {
        int nextSortIndex;
        ArrayList<Integer> sortedIndexes = new ArrayList<Integer>(this.gridGenerator.slotToItem.values());
        int sortIndex = sortedIndexes.indexOf(itemIndex);
        BookmarkItem target = this.getCalculatedItem(itemIndex);
        BookmarkGroup group = this.getGroup(target.groupId);
        if (group.viewMode == BookmarkPanel.BookmarkViewMode.TODO_LIST) {
            int rowId = this.gridGenerator.itemToSlot.get(itemIndex) / this.columns;
            for (nextSortIndex = sortIndex + 1; nextSortIndex < sortedIndexes.size() && this.gridGenerator.itemToSlot.get(sortedIndexes.get(nextSortIndex)) / this.columns == rowId; ++nextSortIndex) {
            }
        }
        if (nextSortIndex < sortedIndexes.size()) {
            Recipe.RecipeId recipeId;
            int nextItemIndex = (Integer)sortedIndexes.get(nextSortIndex);
            if (group.viewMode == BookmarkPanel.BookmarkViewMode.TODO_LIST && target.equalsRecipe(this.getCalculatedItem(nextItemIndex))) {
                return -1;
            }
            if (group.crafting != null && (recipeId = group.crafting.itemToRecipe.get(itemIndex)) != null && recipeId.equals(this.gridGenerator.itemToRecipe.get(nextItemIndex))) {
                return -1;
            }
            return nextSortIndex;
        }
        return Integer.MAX_VALUE;
    }

    private void moveItems(BookmarkItem bookmarkItem, List<BookmarkItem> items) {
        this.bookmarkItems.removeAll(items);
        int index = bookmarkItem == null ? this.bookmarkItems.size() : this.bookmarkItems.indexOf(bookmarkItem);
        this.bookmarkItems.addAll(index, items);
        this.onItemsChanged();
    }

    public void shiftGroupAmount(int targetGroupId, long shift) {
        BookmarkGroup group = this.getGroup(targetGroupId);
        if (group.crafting == null) {
            long customFactor;
            ArrayList<BookmarkItem> items = new ArrayList<BookmarkItem>();
            HashSet<Long> sizes = new HashSet<Long>();
            for (BookmarkItem item : this.bookmarkItems) {
                if (item.groupId != targetGroupId || item.amount <= 0L) continue;
                sizes.add(Math.max(item.getStackSize(), item.factor / (long)item.fluidCellAmount));
                items.add(item);
            }
            long gcd = sizes.stream().reduce(0L, (a, b) -> this.gcd((long)a, (long)b));
            long multiplier = Integer.MAX_VALUE;
            for (BookmarkItem item : items) {
                customFactor = (long)Math.ceil((double)item.amount / (double)gcd);
                long customMultiplier = (long)(customFactor > 0L ? Math.ceil((double)item.amount / (double)customFactor) : 0.0);
                multiplier = Math.min(this.shiftMultiplier(customMultiplier, shift, 1), multiplier);
            }
            for (BookmarkItem item : items) {
                customFactor = (long)Math.ceil((double)item.amount / (double)gcd);
                item.amount = customFactor * multiplier;
            }
        } else {
            HashMap<Recipe.RecipeId, Long> recipeMultipliers = new HashMap<Recipe.RecipeId, Long>();
            Set<Recipe.RecipeId> outputRecipes = group.crafting.outputRecipes;
            ArrayList<BookmarkItem> items = new ArrayList<BookmarkItem>();
            for (BookmarkItem item : this.bookmarkItems) {
                if (item.factor <= 0L || !outputRecipes.stream().anyMatch(recipeId -> item.equalsRecipe((Recipe.RecipeId)recipeId, targetGroupId))) continue;
                long multiplier = recipeMultipliers.getOrDefault(item.recipeId, (Long)Integer.MAX_VALUE);
                boolean isOutputRecipe = group.crafting != null && !group.crafting.recipeInMiddle.contains(item.recipeId);
                recipeMultipliers.put(item.recipeId, Math.min(this.shiftMultiplier(Math.max(isOutputRecipe ? 1L : 0L, item.getMultiplier()), shift, isOutputRecipe ? 1 : 0), multiplier));
                items.add(item);
            }
            for (BookmarkItem item : items) {
                item.amount = item.factor * recipeMultipliers.getOrDefault(item.recipeId, 0L);
            }
        }
        this.onItemsChanged();
    }

    public void shiftItemAmount(int targetItemIndex, long shift) {
        BookmarkItem targetItem = this.getCalculatedItem(targetItemIndex);
        BookmarkGroup group = this.getGroup(targetItem.groupId);
        if (group.collapsed) {
            this.shiftGroupAmount(targetItem.groupId, shift);
        } else if (targetItem.recipeId != null) {
            Recipe.RecipeId recipeId = this.gridGenerator.itemToRecipe.getOrDefault(targetItemIndex, targetItem.recipeId);
            boolean isOutputRecipe = group.crafting != null && !group.crafting.recipeInMiddle.contains(recipeId);
            long multiplier = Integer.MAX_VALUE;
            for (BookmarkItem item : this.bookmarkItems) {
                if (!item.equalsRecipe(recipeId, targetItem.groupId) || item.factor <= 0L) continue;
                multiplier = Math.min(this.shiftMultiplier(Math.max(isOutputRecipe ? 1L : 0L, item.getMultiplier()), shift, isOutputRecipe ? 1 : 0), multiplier);
            }
            for (BookmarkItem item : this.bookmarkItems) {
                if (!item.equalsRecipe(recipeId, targetItem.groupId) || item.factor <= 0L) continue;
                item.amount = item.factor * multiplier;
            }
        } else {
            for (BookmarkItem item : this.bookmarkItems) {
                if (!targetItem.equals(item)) continue;
                item.amount = item.factor * this.shiftMultiplier(item.getMultiplier(), shift, 0);
                break;
            }
        }
        this.onItemsChanged();
    }

    private long shiftMultiplier(long multiplier, long shift, int minMultiplier) {
        long currentMultiplier = (multiplier + shift) / shift * shift;
        return Math.min(Integer.MAX_VALUE, currentMultiplier <= 0L && multiplier > 1L ? 1L : Math.max((long)minMultiplier, currentMultiplier));
    }

    private long gcd(long a, long b) {
        return b == 0L ? a : this.gcd(b, a % b);
    }

    @Override
    protected void beforeDrawItems(int mousex, int mousey, BookmarkMouseContext mouseContext) {
        if (LayoutManager.bookmarkPanel.inEditingState()) {
            SortableGroup sortableGroup = LayoutManager.bookmarkPanel.sortableGroup;
            SortableItem sortableItem = LayoutManager.bookmarkPanel.sortableItem;
            ArrayList<BookmarksGridSlot> borders = new ArrayList<BookmarksGridSlot>();
            for (BookmarksGridSlot slot : this.getMask()) {
                Rectangle4i rect = this.getSlotRect(slot.slotIndex);
                if (sortableGroup != null && slot.getGroupId() == sortableGroup.groupId) {
                    NEIClientUtils.drawRect(rect.x, rect.y, rect.w, rect.h, DRAG_COLOR);
                    continue;
                }
                if (sortableItem != null && sortableItem.items.contains(slot.itemIndex)) {
                    NEIClientUtils.drawRect(rect.x, rect.y, rect.w, rect.h, DRAG_COLOR);
                    borders.add(slot);
                    continue;
                }
                borders.add(slot);
            }
            for (BookmarksGridSlot slot : borders) {
                slot.drawBorder(this.getSlotRect(slot.slotIndex));
            }
        } else {
            super.beforeDrawItems(mousex, mousey, mouseContext);
        }
    }

    @Override
    protected void afterDrawItems(int mousex, int mousey, BookmarkMouseContext mouseContext) {
        if (LayoutManager.bookmarkPanel.inEditingState()) {
            SortableGroup sortableGroup = LayoutManager.bookmarkPanel.sortableGroup;
            SortableItem sortableItem = LayoutManager.bookmarkPanel.sortableItem;
            for (BookmarksGridSlot slot : this.getMask()) {
                if (sortableGroup != null && slot.getGroupId() == sortableGroup.groupId || sortableItem != null && sortableItem.items.contains(slot.itemIndex)) continue;
                slot.afterDraw(this.getSlotRect(slot.slotIndex), mouseContext);
            }
        } else {
            super.afterDrawItems(mousex, mousey, mouseContext);
        }
    }

    @Override
    protected void drawItems() {
        SortableGroup sortableGroup = LayoutManager.bookmarkPanel.sortableGroup;
        SortableItem sortableItem = LayoutManager.bookmarkPanel.sortableItem;
        for (BookmarksGridSlot slot : this.getMask()) {
            if (sortableGroup != null && slot.getGroupId() == sortableGroup.groupId || sortableItem != null && sortableItem.items.contains(slot.itemIndex)) continue;
            BookmarkItem item = slot.getBookmarkItem();
            if (this.animation.containsKey(item) && this.animation.get(item).floatValue() < 1.0f) {
                float currentScale = this.animation.get(item).floatValue() + 0.1f;
                if (currentScale >= 1.0f) {
                    this.animation.remove(item);
                } else {
                    this.animation.put(item, Float.valueOf(currentScale));
                }
                this.drawPoppingItem(slot, this.getSlotRect(slot.slotIndex), currentScale);
                continue;
            }
            slot.drawItem(this.getSlotRect(slot.slotIndex));
        }
    }

    protected void drawPoppingItem(BookmarksGridSlot slot, Rectangle4i rect, float currentScale) {
        float inverseScaleFactor = 1.0f / currentScale;
        float shiftX = ((float)rect.x + ((float)rect.w - (float)rect.w * currentScale) / 2.0f) * inverseScaleFactor;
        float shiftY = ((float)rect.y + ((float)rect.h - (float)rect.h * currentScale) / 2.0f) * inverseScaleFactor;
        GL11.glScalef((float)currentScale, (float)currentScale, (float)1.0f);
        GL11.glTranslated((double)shiftX, (double)shiftY, (double)0.0);
        slot.drawItem(new Rectangle4i(0, 0, rect.w, rect.h));
        GL11.glTranslated((double)(-1.0f * shiftX), (double)(-1.0f * shiftY), (double)0.0);
        GL11.glScalef((float)inverseScaleFactor, (float)inverseScaleFactor, (float)1.0f);
    }

    public static class BookmarkMouseContext
    extends ItemsGrid.MouseContext {
        public final int groupId;
        public final Recipe.RecipeId recipeId;
        public final boolean controlKey = NEIClientUtils.controlKey();
        public final boolean shiftKey = NEIClientUtils.shiftKey();

        public BookmarkMouseContext(int slotIndex, int rowIndex, int columnIndex) {
            super(slotIndex, rowIndex, columnIndex);
            this.groupId = -1;
            this.recipeId = null;
        }

        public BookmarkMouseContext(int slotIndex, int rowIndex, int columnIndex, int groupId, Recipe.RecipeId recipeId) {
            super(slotIndex, rowIndex, columnIndex);
            this.groupId = groupId;
            this.recipeId = recipeId;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.groupId, this.rowIndex, this.slotIndex, this.recipeId, this.controlKey, this.shiftKey);
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj) && obj instanceof BookmarkMouseContext) {
                BookmarkMouseContext hover = (BookmarkMouseContext)obj;
                return this.groupId == hover.groupId && this.controlKey == hover.controlKey && this.shiftKey == hover.shiftKey && (this.recipeId == hover.recipeId || this.recipeId != null && this.recipeId.equals(hover.recipeId));
            }
            return false;
        }
    }
}

