/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.BookmarkContainerInfo;
import codechicken.nei.FavoriteRecipes;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.SearchField;
import codechicken.nei.bookmark.BookmarkGrid;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.bookmark.BookmarksGridSlot;
import codechicken.nei.recipe.AutoCraftingManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerRef;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.chain.RecipeChainMath;
import codechicken.nei.util.NEIMouseUtils;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Mouse;

public abstract class ShortcutInputHandler {
    public static boolean handleKeyEvent(ItemStack stackover) {
        if (!NEIClientConfig.isLoaded()) {
            return false;
        }
        if (NEIClientConfig.isKeyHashDown("gui.overlay") && stackover == null && LayoutManager.overlayRenderer != null) {
            LayoutManager.overlayRenderer = null;
            return true;
        }
        if (stackover == null) {
            int groupId = ItemPanels.bookmarkPanel.getHoveredGroupId(true);
            if (groupId != -1) {
                if (NEIClientConfig.isKeyHashDown("gui.remove_recipe")) {
                    ItemPanels.bookmarkPanel.removeGroup(groupId);
                    return true;
                }
                if (NEIClientConfig.isKeyHashDown("gui.bookmark_pull_items")) {
                    return ItemPanels.bookmarkPanel.pullBookmarkItems(groupId, NEIClientUtils.shiftKey());
                }
                if (NEIClientConfig.autocraftingEnabled() && ((BookmarkGrid)ItemPanels.bookmarkPanel.getGrid()).isCraftingMode(groupId) && NEIClientConfig.isKeyHashDown("gui.craft")) {
                    AutoCraftingManager.runProcessing(((BookmarkGrid)ItemPanels.bookmarkPanel.getGrid()).createRecipeChainMath(groupId));
                    return true;
                }
            }
            return false;
        }
        stackover = stackover.func_77946_l();
        if (NEIClientConfig.isKeyHashDown("gui.overlay")) {
            return ShortcutInputHandler.openOverlayRecipe(stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.copy_name")) {
            return ShortcutInputHandler.copyItemStackName(stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.copy_oredict")) {
            return ShortcutInputHandler.copyItemStackOreDictionary(stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.recipe")) {
            return GuiCraftingRecipe.openRecipeGui("item", stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.usage")) {
            return GuiUsageRecipe.openRecipeGui("item", stackover);
        }
        if (NEIClientConfig.isKeyHashDown("gui.bookmark")) {
            return ShortcutInputHandler.saveRecipeInBookmark(stackover, NEIClientUtils.shiftKey(), NEIClientUtils.controlKey());
        }
        if (NEIClientConfig.isKeyHashDown("gui.bookmark_pull_items")) {
            return ShortcutInputHandler.pullRecipeItems(stackover, NEIClientUtils.shiftKey());
        }
        if (NEIClientConfig.autocraftingEnabled() && NEIClientConfig.isKeyHashDown("gui.craft")) {
            return ShortcutInputHandler.runAutoCrafting(stackover);
        }
        return false;
    }

    public static boolean handleMouseClick(ItemStack stackover) {
        if (!NEIClientConfig.isLoaded()) {
            return false;
        }
        if (stackover != null) {
            int button = Mouse.getEventButton();
            if (button == 0) {
                return GuiCraftingRecipe.openRecipeGui("item", stackover);
            }
            if (button == 1) {
                return GuiUsageRecipe.openRecipeGui("item", stackover);
            }
        }
        return false;
    }

    private static boolean copyItemStackName(ItemStack stackover) {
        GuiScreen.func_146275_d((String)SearchField.getEscapedSearchText(stackover));
        return true;
    }

    private static boolean copyItemStackOreDictionary(ItemStack stackover) {
        StringBuilder builder = new StringBuilder();
        for (int id : OreDictionary.getOreIDs((ItemStack)stackover)) {
            String oreDictionaryName = OreDictionary.getOreName((int)id);
            if ("Unknown".equals(oreDictionaryName)) continue;
            builder.append(oreDictionaryName).append(",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        GuiScreen.func_146275_d((String)builder.toString());
        return true;
    }

    private static boolean runAutoCrafting(ItemStack stackover) {
        Recipe.RecipeId recipeId = GuiCraftingRecipe.getRecipeId((GuiScreen)NEIClientUtils.getGuiContainer(), stackover);
        if (recipeId != null) {
            Point mouseover = GuiDraw.getMousePosition();
            BookmarksGridSlot slot = ItemPanels.bookmarkPanel.getSlotMouseOver(mouseover.x, mouseover.y);
            RecipeChainMath math = null;
            if (slot == null) {
                Recipe recipe = Recipe.of(recipeId);
                if (recipe != null) {
                    math = RecipeChainMath.of(recipe, 1L);
                }
            } else if (slot.getRecipeId() != null && !slot.isIngredient()) {
                if (slot.getGroup().crafting == null) {
                    Recipe recipe = Recipe.of(slot.getRecipeId());
                    if (recipe != null) {
                        math = RecipeChainMath.of(recipe, slot != null ? slot.getMultiplier() : 1L);
                    }
                } else {
                    math = ((BookmarkGrid)ItemPanels.bookmarkPanel.getGrid()).createRecipeChainMath(slot.getGroupId(), slot.getRecipeId());
                }
            }
            if (math != null) {
                AutoCraftingManager.runProcessing(math);
                return true;
            }
        }
        return false;
    }

    private static boolean openOverlayRecipe(ItemStack stackover) {
        RecipeHandlerRef handlerRef;
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        Recipe.RecipeId recipeId = GuiCraftingRecipe.getRecipeId((GuiScreen)gui, stackover);
        if (recipeId != null && (handlerRef = RecipeHandlerRef.of(recipeId)) != null) {
            if (NEIClientUtils.shiftKey() && handlerRef.canFillCraftingGrid(gui)) {
                int multiplier = 0;
                if (NEIClientUtils.controlKey()) {
                    Point mouseover = GuiDraw.getMousePosition();
                    BookmarksGridSlot slot = ItemPanels.bookmarkPanel.getSlotMouseOver(mouseover.x, mouseover.y);
                    multiplier = slot != null ? (int)Math.min(64L, slot.getMultiplier()) : 1;
                }
                handlerRef.fillCraftingGrid(gui, multiplier);
            } else if (!NEIClientUtils.shiftKey() && handlerRef.canUseOverlayRenderer(gui)) {
                handlerRef.useOverlayRenderer(gui);
            }
        }
        return false;
    }

    private static boolean saveRecipeInBookmark(ItemStack stackover, boolean saveIngredients, boolean saveStackSize) {
        Point mousePos = GuiDraw.getMousePosition();
        if (!ItemPanels.bookmarkPanel.removeSlot(mousePos.x, mousePos.y, saveIngredients)) {
            Recipe recipe = ShortcutInputHandler.getFocusedRecipe(stackover, mousePos.x, mousePos.y, saveIngredients);
            if (recipe != null && saveIngredients) {
                if (!ItemPanels.bookmarkPanel.removeRecipe(recipe.getRecipeId(), 0)) {
                    Recipe singleRecipe = Recipe.of(Arrays.asList(recipe.getResult(stackover)), recipe.getHandlerName(), recipe.getIngredients());
                    singleRecipe.setCustomRecipeId(recipe.getRecipeId());
                    ItemPanels.bookmarkPanel.addRecipe(singleRecipe, 0);
                }
            } else {
                Recipe.RecipeId recipeId = recipe != null ? recipe.getRecipeId() : null;
                boolean existsRecipe = recipeId != null && ItemPanels.bookmarkPanel.existsRecipe(recipeId, 0) || NEIClientConfig.getBooleanSetting("inventory.bookmarks.bookmarkItemsWithRecipe");
                if (!ItemPanels.bookmarkPanel.removeItem(stackover, existsRecipe ? recipeId : null, 0)) {
                    boolean bl = saveStackSize = saveStackSize || saveIngredients || ItemPanels.bookmarkPanel.existsRecipe(recipeId, 0);
                    if (!saveStackSize) {
                        stackover = StackInfo.withAmount(stackover, 0L);
                    } else if (ItemPanels.itemPanel.contains(mousePos.x, mousePos.y) || ItemPanels.itemPanel.historyPanel.contains(mousePos.x, mousePos.y)) {
                        stackover = ItemQuantityField.prepareStackWithQuantity(stackover, 0L);
                    }
                    ItemPanels.bookmarkPanel.addItem(stackover, existsRecipe ? recipeId : null, 0);
                }
            }
        }
        return true;
    }

    private static Recipe getFocusedRecipe(ItemStack stackover, int mousex, int mousey, boolean useFavorites) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        Recipe recipe = null;
        if (useFavorites && (ItemPanels.itemPanel.contains(mousex, mousey) || ItemPanels.itemPanel.historyPanel.contains(mousex, mousey))) {
            recipe = Recipe.of(FavoriteRecipes.getFavorite(stackover));
            if (recipe != null) {
                recipe.getIngredients().stream().forEach(ingr -> {
                    List<ItemStack> permutations = ingr.getPermutations();
                    for (int index = 0; index < permutations.size(); ++index) {
                        if (FavoriteRecipes.getFavorite(permutations.get(index)) == null) continue;
                        ingr.setActiveIndex(index);
                        break;
                    }
                });
            }
        } else if (gui instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)gui;
            recipe = guiRecipe.getFocusedRecipe();
        }
        return recipe;
    }

    private static boolean pullRecipeItems(ItemStack stackover, boolean shift) {
        Point mousePos = GuiDraw.getMousePosition();
        stackover = ItemPanels.bookmarkPanel.contains(mousePos.x, mousePos.y) ? ItemPanels.bookmarkPanel.getStackMouseOverWithQuantity(mousePos.x, mousePos.y) : (ItemPanels.itemPanel.contains(mousePos.x, mousePos.y) ? ItemPanels.itemPanel.getStackMouseOverWithQuantity(mousePos.x, mousePos.y) : (ItemPanels.itemPanel.historyPanel.contains(mousePos.x, mousePos.y) ? ItemPanels.itemPanel.historyPanel.getStackMouseOverWithQuantity(mousePos.x, mousePos.y) : ItemQuantityField.prepareStackWithQuantity(stackover, 0L)));
        RecipeChainMath math = RecipeChainMath.of(Arrays.asList(BookmarkItem.of(-3, stackover)), Collections.emptySet());
        return ItemPanels.bookmarkPanel.pullBookmarkItems(math, shift);
    }

    public static Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, ItemStack stack) {
        RecipeHandlerRef handlerRef;
        int groupId = ItemPanels.bookmarkPanel.getHoveredGroupId(true);
        HashMap<String, String> hotkeys = new HashMap<String, String>();
        if (groupId != -1) {
            hotkeys.put(NEIClientConfig.getKeyName("gui.remove_recipe"), NEIClientUtils.translate("bookmark.group.remove_recipe", new Object[0]));
            if (BookmarkContainerInfo.getBookmarkContainerHandler(gui) != null) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark_pull_items"), NEIClientUtils.translate("bookmark.group.pull_items", new Object[0]));
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark_pull_items", 0x4000000), NEIClientUtils.translate("bookmark.group.pull_items_shift", new Object[0]));
            }
            if (NEIClientConfig.autocraftingEnabled() && ((BookmarkGrid)ItemPanels.bookmarkPanel.getGrid()).isCraftingMode(groupId)) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.craft"), NEIClientUtils.translate("bookmark.group.craft", new Object[0]));
            }
        }
        if (stack == null) {
            return hotkeys;
        }
        BookmarksGridSlot slot = ItemPanels.bookmarkPanel.getSlotMouseOver(mousex, mousey);
        Recipe.RecipeId recipeId = ShortcutInputHandler.getHotkeyRecipeId(gui, mousex, mousey, stack, slot);
        if (slot != null) {
            hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark"), NEIClientUtils.translate(slot.isIngredient() ? "bookmark.remove_item" : "bookmark.remove_recipe", new Object[0]));
            if (slot.isIngredient()) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x4000000), NEIClientUtils.translate("bookmark.remove_recipe", new Object[0]));
            }
            if (BookmarkContainerInfo.getBookmarkContainerHandler(gui) != null) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark_pull_items"), NEIClientUtils.translate("bookmark.group.pull_items", new Object[0]));
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark_pull_items", 0x4000000), NEIClientUtils.translate("bookmark.group.pull_items_shift", new Object[0]));
            }
        } else {
            hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark"), NEIClientUtils.translate("bookmark.add_item", new Object[0]));
            if (StackInfo.getAmount(stack) > 0) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x2000000), NEIClientUtils.translate("bookmark.add_item_with_count", new Object[0]));
            }
            if (recipeId != null) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.bookmark", 0x4000000), NEIClientUtils.translate("bookmark.add_item_with_recipe", new Object[0]));
            }
        }
        hotkeys.put(NEIClientConfig.getKeyName("gui.recipe"), NEIClientUtils.translate("itempanel.open_crafting", new Object[0]));
        hotkeys.put(NEIClientConfig.getKeyName("gui.usage"), NEIClientUtils.translate("itempanel.open_usage", new Object[0]));
        hotkeys.put(NEIClientConfig.getKeyName("gui.copy_name"), NEIClientUtils.translate("itempanel.copy_name", new Object[0]));
        hotkeys.put(NEIClientConfig.getKeyName("gui.copy_oredict"), NEIClientUtils.translate("itempanel.copy_oredict", new Object[0]));
        if (!(gui instanceof GuiRecipe) && NEIClientConfig.canCheatItem(stack)) {
            hotkeys.put(NEIClientUtils.getKeyName(0x4000000, 0), NEIClientUtils.translate("itempanel.open_crafting", new Object[0]));
            hotkeys.put(NEIClientUtils.getKeyName(0x4000000, 1), NEIClientUtils.translate("itempanel.open_usage", new Object[0]));
        } else {
            hotkeys.put(NEIMouseUtils.getKeyName(0), NEIClientUtils.translate("itempanel.open_crafting", new Object[0]));
            hotkeys.put(NEIMouseUtils.getKeyName(1), NEIClientUtils.translate("itempanel.open_usage", new Object[0]));
        }
        if (recipeId != null && (handlerRef = RecipeHandlerRef.of(recipeId)) != null) {
            if (handlerRef.canUseOverlayRenderer(gui)) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.overlay"), NEIClientUtils.translate("itempanel.overlay_recipe", new Object[0]));
            }
            if (handlerRef.canFillCraftingGrid(gui)) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.overlay", 0x4000000), NEIClientUtils.translate("itempanel.fill_crafting_grid", new Object[0]));
                if (handlerRef.allowedTransferAlghoritm(gui)) {
                    hotkeys.put(NEIClientConfig.getKeyName("gui.overlay", 0x6000000), NEIClientUtils.translate("itempanel.fill_crafting_grid_quantity", new Object[0]));
                }
            }
            if (NEIClientConfig.autocraftingEnabled()) {
                hotkeys.put(NEIClientConfig.getKeyName("gui.craft"), NEIClientUtils.translate("itempanel.craft", new Object[0]));
            }
        }
        return hotkeys;
    }

    private static Recipe.RecipeId getHotkeyRecipeId(GuiContainer gui, int mousex, int mousey, ItemStack stack, BookmarksGridSlot slot) {
        GuiRecipe guiRecipe;
        Recipe focusedRecipe;
        if (slot != null) {
            return slot.getRecipeId();
        }
        if (ItemPanels.itemPanel.contains(mousex, mousey) || ItemPanels.itemPanel.historyPanel.contains(mousex, mousey)) {
            return FavoriteRecipes.getFavorite(stack);
        }
        if (gui instanceof GuiRecipe && (focusedRecipe = (guiRecipe = (GuiRecipe)gui).getFocusedRecipe()) != null) {
            return focusedRecipe.getRecipeId();
        }
        return null;
    }
}

