/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.nei;

import appeng.util.Platform;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.github.vfyjxf.nee.config.ItemCombination;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketArcaneRecipe;
import com.github.vfyjxf.nee.network.packet.PacketExtremeRecipe;
import com.github.vfyjxf.nee.network.packet.PacketNEIPatternRecipe;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import com.github.vfyjxf.nee.processor.RecipeProcessor;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.ItemUtils;
import com.glodblock.github.nei.FluidPatternTerminalRecipeTransferHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NEECraftingHandler
implements IOverlayHandler {
    public static final String INPUT_KEY = "#";
    public static final String OUTPUT_KEY = "Outputs";
    public static Map<String, PositionedStack> ingredients = new HashMap<String, PositionedStack>();
    public static final NEECraftingHandler INSTANCE = new NEECraftingHandler();
    private static Class<?> knowledgeInscriberClz;
    private static Class<?> itemAspectClz;
    private static Class<?> guiExtremeAutoCrafterClz;

    public static boolean isCraftingTableRecipe(IRecipeHandler recipe) {
        if (recipe instanceof TemplateRecipeHandler) {
            TemplateRecipeHandler templateRecipeHandler = (TemplateRecipeHandler)recipe;
            String overlayIdentifier = templateRecipeHandler.getOverlayIdentifier();
            return "crafting".equals(overlayIdentifier) || "crafting2x2".equals(overlayIdentifier);
        }
        return false;
    }

    @Optional.Method(modid="ae2fc")
    private void fluidCraftOverlayRecipe(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        FluidPatternTerminalRecipeTransferHandler.INSTANCE.overlayRecipe(firstGui, recipe, recipeIndex, shift);
    }

    public void overlayRecipe(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        if (GuiUtils.isPatternTerm((GuiScreen)firstGui)) {
            NEENetworkHandler.getInstance().sendToServer((IMessage)this.packRecipe(recipe, recipeIndex));
            if (Loader.isModLoaded((String)"ae2fc")) {
                this.fluidCraftOverlayRecipe(firstGui, recipe, recipeIndex, shift);
            }
        } else {
            this.knowledgeInscriberHandler(firstGui, recipe, recipeIndex);
            this.extremeAutoCrafterHandler(firstGui, recipe, recipeIndex);
        }
    }

    private PacketNEIPatternRecipe packRecipe(IRecipeHandler recipe, int recipeIndex) {
        if (NEECraftingHandler.isCraftingTableRecipe(recipe)) {
            return this.packCraftingTableRecipe(recipe, recipeIndex);
        }
        return this.packProcessRecipe(recipe, recipeIndex);
    }

    private PacketNEIPatternRecipe packProcessRecipe(IRecipeHandler recipe, int recipeIndex) {
        String identifier;
        NBTTagCompound recipeInputs = new NBTTagCompound();
        NBTTagCompound recipeOutputs = new NBTTagCompound();
        String string = identifier = recipe instanceof TemplateRecipeHandler ? recipe.getOverlayIdentifier() : "null";
        if (identifier == null) {
            identifier = "null";
        }
        int inputIndex = 0;
        int outputIndex = 0;
        for (IRecipeProcessor processor : RecipeProcessor.recipeProcessors) {
            ItemStack currentStack;
            if (!processor.getAllOverlayIdentifier().contains(identifier)) continue;
            List<PositionedStack> inputs = processor.getRecipeInput(recipe, recipeIndex, identifier);
            List<PositionedStack> outputs = processor.getRecipeOutput(recipe, recipeIndex, identifier);
            String recipeProcessorId = processor.getRecipeProcessorId();
            ArrayList<PositionedStack> mergedInputs = new ArrayList<PositionedStack>();
            if (inputs.isEmpty() || outputs.isEmpty()) continue;
            ingredients.clear();
            for (PositionedStack positionedStack : inputs) {
                currentStack = positionedStack.items[0];
                boolean find = false;
                ItemCombination currentValue = ItemCombination.valueOf(NEEConfig.itemCombinationMode);
                if (currentValue != ItemCombination.DISABLED && processor.mergeStacks(recipe, recipeIndex, identifier)) {
                    boolean isWhitelist;
                    boolean bl = isWhitelist = currentValue == ItemCombination.WHITELIST && Arrays.asList(NEEConfig.itemCombinationWhitelist).contains(identifier);
                    if (currentValue == ItemCombination.ENABLED || isWhitelist) {
                        for (PositionedStack storedStack : mergedInputs) {
                            ItemStack firstStack = storedStack.items[0];
                            boolean areItemStackEqual = firstStack.func_77969_a(currentStack) && ItemStack.func_77970_a((ItemStack)firstStack, (ItemStack)currentStack);
                            if (!areItemStackEqual || firstStack.field_77994_a + currentStack.field_77994_a > firstStack.func_77976_d()) continue;
                            find = true;
                            storedStack.items[0].field_77994_a = firstStack.field_77994_a + currentStack.field_77994_a;
                        }
                    }
                }
                if (find) continue;
                mergedInputs.add(positionedStack.copy());
            }
            for (PositionedStack positionedStack : mergedInputs) {
                currentStack = positionedStack.items[0];
                ItemStack preferModItem = ItemUtils.getPreferModItem(positionedStack.items);
                if (preferModItem != null) {
                    currentStack = preferModItem;
                    currentStack.field_77994_a = positionedStack.items[0].field_77994_a;
                }
                for (ItemStack stack : positionedStack.items) {
                    if (!Platform.isRecipePrioritized((ItemStack)stack) && !ItemUtils.isPreferItems(stack, recipeProcessorId, identifier)) continue;
                    currentStack = stack.func_77946_l();
                    currentStack.field_77994_a = positionedStack.items[0].field_77994_a;
                    break;
                }
                if (ItemUtils.isInBlackList(currentStack, recipeProcessorId, identifier)) continue;
                if (currentStack.func_77960_j() == Short.MAX_VALUE) {
                    currentStack.func_77964_b(0);
                }
                if (currentStack.field_77994_a < 1) {
                    currentStack.field_77994_a = 1;
                }
                recipeInputs.func_74782_a(INPUT_KEY + inputIndex, (NBTBase)ItemUtils.writeItemStackToNBT(currentStack, new NBTTagCompound()));
                ingredients.put(INPUT_KEY + inputIndex, positionedStack);
                ++inputIndex;
            }
            for (PositionedStack positionedStack : outputs) {
                if (outputIndex >= 4 || positionedStack == null || positionedStack.item == null) continue;
                ItemStack outputStack = positionedStack.item.func_77946_l();
                if (outputStack.func_77960_j() == Short.MAX_VALUE) {
                    outputStack.func_77964_b(0);
                }
                if (outputStack.field_77994_a < 1) {
                    outputStack.field_77994_a = 1;
                }
                recipeOutputs.func_74782_a(OUTPUT_KEY + outputIndex, (NBTBase)ItemUtils.writeItemStackToNBT(outputStack, new NBTTagCompound()));
                ++outputIndex;
            }
        }
        return new PacketNEIPatternRecipe(recipeInputs, recipeOutputs);
    }

    private PacketNEIPatternRecipe packCraftingTableRecipe(IRecipeHandler recipe, int recipeIndex) {
        NBTTagCompound recipeInputs = new NBTTagCompound();
        List ingredients = recipe.getIngredientStacks(recipeIndex);
        NEECraftingHandler.ingredients.clear();
        for (PositionedStack positionedStack : ingredients) {
            int col = (positionedStack.relx - 25) / 18;
            int row = (positionedStack.rely - 6) / 18;
            int slotIndex = col + row * 3;
            if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
            ItemStack[] currentStackList = positionedStack.items;
            ItemStack stack = positionedStack.items[0];
            ItemStack preferModItem = ItemUtils.getPreferModItem(positionedStack.items);
            if (preferModItem != null) {
                stack = preferModItem;
            }
            for (ItemStack currentStack : currentStackList) {
                if (!Platform.isRecipePrioritized((ItemStack)currentStack) && !ItemUtils.isPreferItems(currentStack)) continue;
                stack = currentStack.func_77946_l();
            }
            ItemUtils.transformGTTool(stack);
            if (stack.func_77960_j() == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
            recipeInputs.func_74782_a(INPUT_KEY + slotIndex, (NBTBase)ItemUtils.writeItemStackToNBT(stack, new NBTTagCompound()));
            NEECraftingHandler.ingredients.put(INPUT_KEY + slotIndex, positionedStack);
        }
        return new PacketNEIPatternRecipe(recipeInputs, null);
    }

    private void knowledgeInscriberHandler(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex) {
        if (knowledgeInscriberClz != null && knowledgeInscriberClz.isInstance(firstGui)) {
            NEENetworkHandler.getInstance().sendToServer((IMessage)this.packetArcaneRecipe(recipe, recipeIndex));
        }
    }

    private PacketArcaneRecipe packetArcaneRecipe(IRecipeHandler recipe, int recipeIndex) {
        NBTTagCompound recipeInputs = new NBTTagCompound();
        List ingredients = recipe.getIngredientStacks(recipeIndex);
        if (itemAspectClz != null) {
            ingredients.removeIf(positionedStack -> itemAspectClz.isInstance(positionedStack.item.func_77973_b()));
        }
        for (PositionedStack positionedStack2 : ingredients) {
            if (positionedStack2.items == null || positionedStack2.items.length <= 0) continue;
            int slotIndex = this.getSlotIndex(positionedStack2.relx * 100 + positionedStack2.rely);
            ItemStack[] currentStackList = positionedStack2.items;
            ItemStack stack = positionedStack2.item;
            for (ItemStack currentStack : currentStackList) {
                if (!Platform.isRecipePrioritized((ItemStack)currentStack)) continue;
                stack = currentStack.func_77946_l();
            }
            recipeInputs.func_74782_a(INPUT_KEY + slotIndex, (NBTBase)ItemUtils.writeItemStackToNBT(stack, new NBTTagCompound()));
        }
        return new PacketArcaneRecipe(recipeInputs);
    }

    private void extremeAutoCrafterHandler(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex) {
        if (guiExtremeAutoCrafterClz != null && guiExtremeAutoCrafterClz.isInstance(firstGui)) {
            NEENetworkHandler.getInstance().sendToServer((IMessage)this.packetExtremeRecipe(recipe, recipeIndex));
        }
    }

    private PacketExtremeRecipe packetExtremeRecipe(IRecipeHandler recipe, int recipeIndex) {
        NBTTagCompound recipeInputs = new NBTTagCompound();
        List ingredients = recipe.getIngredientStacks(recipeIndex);
        for (PositionedStack positionedStack : ingredients) {
            int col = (positionedStack.relx - 3) / 18;
            int row = (positionedStack.rely - 3) / 18;
            if (positionedStack.rely == 129) {
                col = (positionedStack.relx - 2) / 18;
            }
            int slotIndex = col + row * 9;
            ItemStack currentStack = positionedStack.items[0];
            ItemStack preferModItem = ItemUtils.getPreferModItem(positionedStack.items);
            if (preferModItem != null) {
                currentStack = preferModItem;
            }
            for (ItemStack stack : positionedStack.items) {
                if (!ItemUtils.isPreferItems(stack)) continue;
                currentStack = stack.func_77946_l();
            }
            recipeInputs.func_74782_a(INPUT_KEY + slotIndex, (NBTBase)ItemUtils.writeItemStackToNBT(currentStack, new NBTTagCompound()));
        }
        return new PacketExtremeRecipe(recipeInputs);
    }

    private int getSlotIndex(int xy) {
        switch (xy) {
            case 7533: {
                return 1;
            }
            case 10333: {
                return 2;
            }
            case 4960: {
                return 3;
            }
            case 7660: {
                return 4;
            }
            case 10360: {
                return 5;
            }
            case 4987: {
                return 6;
            }
            case 7687: {
                return 7;
            }
            case 10387: {
                return 8;
            }
        }
        return 0;
    }

    static {
        try {
            knowledgeInscriberClz = Class.forName("thaumicenergistics.client.gui.GuiKnowledgeInscriber");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            itemAspectClz = Class.forName("com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            guiExtremeAutoCrafterClz = Class.forName("wanion.avaritiaddons.block.extremeautocrafter.GuiExtremeAutoCrafter");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

