/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mkb.keybinding;

import committee.nova.mkb.api.IKeyBinding;
import committee.nova.mkb.keybinding.KeyModifier;
import committee.nova.mkb.util.IntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.settings.KeyBinding;

public class KeyBindingMap {
    private static final EnumMap<KeyModifier, IntHashMap<Collection<KeyBinding>>> map = new EnumMap(KeyModifier.class);

    @Nullable
    public KeyBinding lookupActive(int keyCode) {
        KeyBinding binding;
        KeyModifier activeModifier = KeyModifier.getActiveModifier();
        if (!activeModifier.matches(keyCode) && (binding = this.getBinding(keyCode, activeModifier)) != null) {
            return binding;
        }
        return this.getBinding(keyCode, KeyModifier.NONE);
    }

    public Set<KeyBinding> lookupActives(int keyCode) {
        Set<KeyBinding> bindings;
        KeyModifier activeModifier = KeyModifier.getActiveModifier();
        if (!activeModifier.matches(keyCode) && !(bindings = this.getBindings(keyCode, activeModifier)).isEmpty()) {
            return bindings;
        }
        return this.getBindings(keyCode, KeyModifier.NONE);
    }

    @Nullable
    private KeyBinding getBinding(int keyCode, KeyModifier keyModifier) {
        Collection<KeyBinding> bindings = map.get((Object)keyModifier).lookup(keyCode);
        if (bindings == null) {
            return null;
        }
        for (KeyBinding binding : bindings) {
            if (!((IKeyBinding)binding).isActiveAndMatches(keyCode)) continue;
            return binding;
        }
        return null;
    }

    public Set<KeyBinding> getBindings(int keyCode, KeyModifier keyModifier) {
        Collection<KeyBinding> bindings = map.get((Object)keyModifier).lookup(keyCode);
        HashSet<KeyBinding> matched = new HashSet<KeyBinding>();
        if (bindings == null) {
            return matched;
        }
        for (KeyBinding binding : bindings) {
            if (!((IKeyBinding)binding).isActiveAndMatches(keyCode)) continue;
            matched.add(binding);
        }
        return matched;
    }

    public List<KeyBinding> lookupAll(int keyCode) {
        ArrayList<KeyBinding> matchingBindings = new ArrayList<KeyBinding>();
        for (IntHashMap<Collection<KeyBinding>> bindingsMap : map.values()) {
            Collection<KeyBinding> bindings = bindingsMap.lookup(keyCode);
            if (bindings == null) continue;
            matchingBindings.addAll(bindings);
        }
        return matchingBindings;
    }

    public void addKey(int keyCode, KeyBinding keyBinding) {
        KeyModifier keyModifier = ((IKeyBinding)keyBinding).getKeyModifier();
        IntHashMap<Collection<KeyBinding>> bindingsMap = map.get((Object)keyModifier);
        Collection<KeyBinding> bindingsForKey = bindingsMap.lookup(keyCode);
        if (bindingsForKey == null) {
            bindingsForKey = new ArrayList<KeyBinding>();
            bindingsMap.addKey(keyCode, bindingsForKey);
        }
        bindingsForKey.add(keyBinding);
    }

    public void removeKey(KeyBinding keyBinding) {
        KeyModifier keyModifier = ((IKeyBinding)keyBinding).getKeyModifier();
        int keyCode = keyBinding.func_151463_i();
        IntHashMap<Collection<KeyBinding>> bindingsMap = map.get((Object)keyModifier);
        Collection<KeyBinding> bindingsForKey = bindingsMap.lookup(keyCode);
        if (bindingsForKey != null) {
            bindingsForKey.remove(keyBinding);
            if (bindingsForKey.isEmpty()) {
                bindingsMap.removeObject(keyCode);
            }
        }
    }

    public void clearMap() {
        for (IntHashMap<Collection<KeyBinding>> bindings : map.values()) {
            bindings.clearMap();
        }
    }

    static {
        for (KeyModifier modifier : KeyModifier.values()) {
            map.put(modifier, new IntHashMap());
        }
    }
}

