/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.keywizard.gui;

import committee.nova.keywizard.gui.GuiKeyWizard;
import committee.nova.keywizard.gui.GuiScrollingList;
import committee.nova.keywizard.util.KeybindUtils;
import committee.nova.mkb.api.IKeyBinding;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;

public class GuiBindingList
extends GuiScrollingList {
    private GuiKeyWizard parent;
    private KeyBinding[] bindings;
    private String searchText;
    private String selectedCategory;
    private KeyBinding selectedKeybind;
    private int selectedKeybindId;

    public GuiBindingList(GuiKeyWizard parent, int left, int bottom, int width, int height, int entryHeight) {
        super(parent.getClient(), width, height, bottom - height, bottom, left, entryHeight, parent.field_146294_l, parent.field_146295_m);
        this.parent = parent;
        this.bindings = Arrays.copyOf(KeybindUtils.ALL_BINDINGS, KeybindUtils.ALL_BINDINGS.length);
        this.searchText = this.parent.getSearchText();
        this.selectedCategory = this.parent.getSelectedCategory();
        this.selectKeybind(0);
    }

    @Override
    protected int getSize() {
        return this.bindings.length;
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
        this.selectKeybind(index);
    }

    @Override
    protected boolean isSelected(int index) {
        return this.selectedKeybindId == index;
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        FontRenderer fontRender = this.parent.getFontRenderer();
        KeyBinding currentBinding = this.bindings[slotIdx];
        fontRender.func_78261_a(I18n.func_135052_a((String)currentBinding.func_151464_g(), (Object[])new Object[0]), this.left + 3, slotTop, 0xFFFFFF);
        fontRender.func_78261_a("(" + I18n.func_135052_a((String)currentBinding.func_151466_e(), (Object[])new Object[0]) + ")", this.left + 3, slotTop + fontRender.field_78288_b + 2, 0x444444);
        int color = 0;
        IKeyBinding mixined = (IKeyBinding)currentBinding;
        color = currentBinding.func_151463_i() == 0 || KeybindUtils.getNumConficts(currentBinding) > 0 ? 0x993333 : (!mixined.isSetToDefaultValue() ? 0x339933 : 0x999999);
        fontRender.func_78261_a(mixined.getDisplayName(), this.left + 3, slotTop + fontRender.field_78288_b * 2 + 3, color);
    }

    protected void updateList() {
        if (!this.searchText.equals(this.parent.getSearchText()) || !this.selectedCategory.equals(this.parent.getSelectedCategory())) {
            this.searchText = this.parent.getSearchText();
            this.selectedCategory = this.parent.getSelectedCategory();
            KeyBinding[] bindingsNew = this.bindingsByCategory(this.selectedCategory);
            String[] words = this.searchText.split("\\s+");
            if (words.length != 0) {
                if (words[0].length() > 0 && words[0].charAt(0) == '@') {
                    bindingsNew = this.filterBindingsByKey(bindingsNew, words[0].substring(1));
                    words[0] = "";
                }
                bindingsNew = this.filterBindingsByName(bindingsNew, words);
            }
            this.bindings = bindingsNew;
            if (this.bindings.length != 0) {
                this.selectKeybind(0);
            }
        }
        Arrays.sort(this.bindings, this.parent.sortType);
    }

    private void selectKeybind(int id) {
        this.selectedKeybindId = id;
        this.selectedKeybind = this.bindings[id];
        this.parent.setSelectedKeybind(this.selectedKeybind);
    }

    private KeyBinding[] bindingsByCategory(String category) {
        KeyBinding[] bindings = Arrays.copyOf(KeybindUtils.ALL_BINDINGS, KeybindUtils.ALL_BINDINGS.length);
        switch (category) {
            case "categories.all": {
                return bindings;
            }
            case "categories.conflicts": {
                return (KeyBinding[])Arrays.stream(bindings).filter(binding -> KeybindUtils.getNumConficts(binding) >= 1 && binding.func_151463_i() != 0).toArray(KeyBinding[]::new);
            }
            case "categories.unbound": {
                return (KeyBinding[])Arrays.stream(bindings).filter(binding -> binding.func_151463_i() == 0).toArray(KeyBinding[]::new);
            }
        }
        return (KeyBinding[])Arrays.stream(bindings).filter(binding -> Objects.equals(binding.func_151466_e(), category)).toArray(KeyBinding[]::new);
    }

    private KeyBinding[] filterBindingsByName(KeyBinding[] bindings, String[] words) {
        KeyBinding[] filtered = new KeyBinding[]{};
        filtered = (KeyBinding[])Arrays.stream(bindings).filter(binding -> {
            boolean flag = true;
            for (String w : words) {
                flag = flag && I18n.func_135052_a((String)binding.func_151464_g(), (Object[])new Object[0]).toLowerCase().contains(w.toLowerCase());
            }
            return flag;
        }).toArray(KeyBinding[]::new);
        return filtered;
    }

    private KeyBinding[] filterBindingsByKey(KeyBinding[] bindings, String keyName) {
        KeyBinding[] filtered = new KeyBinding[]{};
        filtered = (KeyBinding[])Arrays.stream(bindings).filter(binding -> ((IKeyBinding)binding).getDisplayName().toLowerCase().contains(keyName.toLowerCase())).toArray(KeyBinding[]::new);
        return filtered;
    }

    public KeyBinding getSelectedKeybind() {
        return this.selectedKeybind;
    }
}

