/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.nei.adapter;

import codechicken.nei.recipe.IRecipeHandler;
import forestry.core.recipes.nei.PositionedFluidTank;
import forestry.core.recipes.nei.RecipeHandlerBase;
import forestry.factory.recipes.nei.NEIHandlerBottler;
import forestry.factory.recipes.nei.NEIHandlerCarpenter;
import forestry.factory.recipes.nei.NEIHandlerCentrifuge;
import forestry.factory.recipes.nei.NEIHandlerFabricator;
import forestry.factory.recipes.nei.NEIHandlerFermenter;
import forestry.factory.recipes.nei.NEIHandlerMoistener;
import forestry.factory.recipes.nei.NEIHandlerSqueezer;
import forestry.factory.recipes.nei.NEIHandlerStill;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.nei.adapter.IAdapter;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

@ParametersAreNonnullByDefault
public class Forestry
implements IAdapter {
    @Override
    public void handleRecipe(IRecipeHandler recipe, int index, List<Object[]> inputs, List<Object[]> outputs) {
        if (recipe instanceof RecipeHandlerBase) {
            RecipeHandlerBase base = (RecipeHandlerBase)recipe;
            this.bottler(base, index, inputs);
            this.carpenter(base, index, inputs);
            this.centrifuge(base, index, outputs);
            this.fabricator(base, index, inputs);
            this.fermenter(base, index, inputs, outputs);
            this.moistener(base, index, inputs, outputs);
            this.squeezer(base, index, inputs, outputs);
            this.still(base, index, inputs, outputs);
        }
    }

    private void bottler(RecipeHandlerBase recipe, int recipeIndex, List<Object[]> inputs) {
        List<List<FluidStack>> fluids;
        if (recipe instanceof NEIHandlerBottler && (fluids = this.getFluids(recipe, recipeIndex)).size() >= 1) {
            inputs.add(fluids.get(0).toArray());
        }
    }

    private void carpenter(RecipeHandlerBase recipe, int recipeIndex, List<Object[]> inputs) {
        List<List<FluidStack>> fluids;
        if (recipe instanceof NEIHandlerCarpenter && (fluids = this.getFluids(recipe, recipeIndex)).size() >= 1) {
            inputs.add(fluids.get(0).toArray());
        }
    }

    private void centrifuge(RecipeHandlerBase recipe, int recipeIndex, List<Object[]> outputs) {
        if (recipe instanceof NEIHandlerCentrifuge) {
            List otherStacks = recipe.getOtherStacks(recipeIndex);
            otherStacks.stream().map(positionedStack -> positionedStack.items).forEach(outputs::add);
        }
    }

    private void fabricator(RecipeHandlerBase recipe, int recipeIndex, List<Object[]> inputs) {
        List<List<FluidStack>> fluids;
        if (recipe instanceof NEIHandlerFabricator && (fluids = this.getFluids(recipe, recipeIndex)).size() >= 1) {
            inputs.add(fluids.get(0).toArray());
        }
    }

    private void fermenter(RecipeHandlerBase recipe, int recipeIndex, List<Object[]> inputs, List<Object[]> outputs) {
        if (recipe instanceof NEIHandlerFermenter) {
            List<PositionedFluidTank> tanks = this.getTanks(recipe, recipeIndex);
            tanks.forEach(tank -> {
                Object[] fluids = Arrays.stream(tank.tanks).map(FluidTank::getFluid).toArray();
                if (tank.position.x == 30) {
                    inputs.add(fluids);
                } else {
                    outputs.add(fluids);
                }
            });
        }
    }

    private void moistener(RecipeHandlerBase recipe, int recipeIndex, List<Object[]> inputs, List<Object[]> outputs) {
        if (recipe instanceof NEIHandlerMoistener) {
            List<List<FluidStack>> fluids = this.getFluids(recipe, recipeIndex);
            if (fluids.size() >= 1) {
                inputs.add(fluids.get(0).toArray());
            }
            List otherStacks = recipe.getOtherStacks(recipeIndex);
            otherStacks.forEach(positionedStack -> {
                ItemStack[] items = positionedStack.items;
                if (positionedStack.relx == 34) {
                    inputs.add(items);
                } else {
                    outputs.add(items);
                }
            });
        }
    }

    private void squeezer(RecipeHandlerBase recipe, int recipeIndex, List<Object[]> inputs, List<Object[]> outputs) {
        List<List<FluidStack>> fluids;
        if (recipe instanceof NEIHandlerSqueezer && (fluids = this.getFluids(recipe, recipeIndex)).size() >= 1) {
            outputs.add(fluids.get(0).toArray());
        }
    }

    private void still(RecipeHandlerBase recipe, int recipeIndex, List<Object[]> inputs, List<Object[]> outputs) {
        if (recipe instanceof NEIHandlerStill) {
            this.getTanks(recipe, recipeIndex).forEach(tank -> {
                Object[] fluids = Arrays.stream(tank.tanks).map(FluidTank::getFluid).toArray();
                if (tank.position.x == 30) {
                    inputs.add(fluids);
                } else {
                    outputs.add(fluids);
                }
            });
        }
    }

    private List<List<FluidStack>> getFluids(RecipeHandlerBase recipe, int recipeIndex) {
        return ((RecipeHandlerBase.CachedBaseRecipe)recipe.arecipes.get(recipeIndex)).getFluidTanks().stream().map(positionedFluidTank -> Arrays.stream(positionedFluidTank.tanks).map(FluidTank::getFluid).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private List<PositionedFluidTank> getTanks(RecipeHandlerBase recipe, int recipeIndex) {
        return ((RecipeHandlerBase.CachedBaseRecipe)recipe.arecipes.get(recipeIndex)).getFluidTanks();
    }
}

