/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.nei;

import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import com.gtnh.findit.FindItNetwork;
import com.gtnh.findit.service.itemfinder.FindItemRequest;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import me.towdium.jecalculation.JustEnoughCalculation;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.nei.Adapter;
import me.towdium.jecalculation.nei.JecaTooltipHandler;
import me.towdium.jecalculation.utils.Version;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class NEIPlugin {
    private static boolean catalystEnabled = false;
    private static final Version CATALYST_NEI_VERSION = new Version("2.1.0-GTNH");
    private static ItemStack currentItemStack;

    public static void init() {
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)new JecaTooltipHandler());
        String neiVersion = ((ModContainer)Loader.instance().getIndexedModList().get("NotEnoughItems")).getVersion();
        JustEnoughCalculation.logger.info("NEI version: " + neiVersion);
        Version version = new Version(neiVersion);
        if (version.isSuccess() && version.compareTo(CATALYST_NEI_VERSION) >= 0) {
            catalystEnabled = true;
            JustEnoughCalculation.logger.info("catalyst enabled");
        } else {
            JustEnoughCalculation.logger.info("catalyst disabled");
        }
    }

    public static boolean isCatalystEnabled() {
        return catalystEnabled;
    }

    public static ILabel getLabelUnderMouse() {
        if (currentItemStack == null) {
            return ILabel.EMPTY;
        }
        Object stack = Adapter.convertFluid(currentItemStack);
        return ILabel.Converter.from(stack);
    }

    public static void setLabelUnderMouse(ItemStack itemStack) {
        currentItemStack = itemStack;
    }

    public static boolean openRecipeGui(Object rep, boolean usage) {
        ItemStack itemStack;
        if (rep instanceof FluidStack && (itemStack = FluidStackToItemStack.getItemStack((FluidStack)rep)) != null) {
            rep = itemStack;
        }
        if (rep instanceof ItemStack || rep instanceof FluidStack) {
            String id;
            String string = id = rep instanceof ItemStack ? "item" : "liquid";
            if (!usage) {
                return GuiCraftingRecipe.openRecipeGui((String)id, (Object[])new Object[]{rep});
            }
            return GuiUsageRecipe.openRecipeGui((String)id, (Object[])new Object[]{rep});
        }
        if (rep != null) {
            JustEnoughCalculation.logger.warn("unknown label representation " + rep);
        }
        return false;
    }

    public static boolean findItem(Object rep) {
        ItemStack itemStack;
        if (rep instanceof FluidStack && (itemStack = FluidStackToItemStack.getItemStack((FluidStack)rep)) != null) {
            rep = itemStack;
        }
        if (rep instanceof ItemStack) {
            FindItNetwork.CHANNEL.sendToServer((IMessage)new FindItemRequest((ItemStack)rep));
        }
        return true;
    }

    private static class FluidStackToItemStack {
        private static Method getFluidDisplayStack = null;

        private FluidStackToItemStack() {
        }

        private static ItemStack getItemStack(FluidStack fluidStack) {
            Object itemStack;
            if (getFluidDisplayStack == null) {
                return null;
            }
            try {
                itemStack = getFluidDisplayStack.invoke(null, fluidStack, true);
            }
            catch (Exception e) {
                return null;
            }
            if (itemStack instanceof ItemStack) {
                return (ItemStack)itemStack;
            }
            return null;
        }

        static {
            try {
                Class gtUtility = ReflectionHelper.getClass((ClassLoader)FluidStackToItemStack.class.getClassLoader(), (String[])new String[]{"gregtech.api.util.GTUtility", "gregtech.api.util.GT_Utility"});
                getFluidDisplayStack = gtUtility.getMethod("getFluidDisplayStack", FluidStack.class, Boolean.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

