/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.nei;

import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.CostList;
import me.towdium.jecalculation.data.structure.MainCostListService;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.guis.GuiRecipe;
import me.towdium.jecalculation.nei.Adapter;
import me.towdium.jecalculation.nei.NEIPlugin;
import me.towdium.jecalculation.utils.wrappers.Trio;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

@SideOnly(value=Side.CLIENT)
public class JecaOverlayHandler
implements IOverlayHandler {
    public void overlayRecipe(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        if (firstGui instanceof JecaGui) {
            Class<?> context = recipe.getClass();
            JecaGui gui = (JecaGui)firstGui;
            if (gui.root instanceof GuiRecipe) {
                ((GuiRecipe)gui.root).transfer(JecaOverlayHandler.convertRecipe(recipe, recipeIndex, context), context);
            } else {
                GuiRecipe guiRecipe = new GuiRecipe();
                JecaGui.displayGui(true, true, guiRecipe);
                guiRecipe.transfer(JecaOverlayHandler.convertRecipe(recipe, recipeIndex, context), context);
            }
        }
    }

    private static EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>> convertRecipe(IRecipeHandler recipe, int recipeIndex, Class<?> context) {
        EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>> merged = new EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>>(Recipe.IO.class);
        ArrayList<Object[]> recipeInputs = new ArrayList<Object[]>();
        ArrayList<Object[]> recipeOutputs = new ArrayList<Object[]>();
        Adapter.handleRecipe(recipe, recipeIndex, recipeInputs, recipeOutputs);
        recipeInputs.forEach(i -> JecaOverlayHandler.merge(merged, Arrays.asList(i), context, Recipe.IO.INPUT));
        recipeOutputs.forEach(o -> JecaOverlayHandler.merge(merged, Arrays.asList(o), context, Recipe.IO.OUTPUT));
        JecaOverlayHandler.getCatalyst(recipe).ifPresent(catalyst -> {
            List<ItemStack> catalysts = Collections.singletonList(catalyst);
            JecaOverlayHandler.merge(merged, catalysts, context, Recipe.IO.CATALYST);
        });
        return merged;
    }

    private static void merge(EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>> dst, List<?> objs, Class<?> context, Recipe.IO type) {
        List<ILabel> list = objs.stream().map(ILabel.Converter::from).collect(Collectors.toList());
        if (list.isEmpty()) {
            return;
        }
        ILabel rep = ((ILabel)list.get(0)).copy();
        if (type == Recipe.IO.INPUT && list.size() != 1) {
            rep = ILabel.CONVERTER.first(list, context);
        }
        ILabel fin = rep;
        dst.computeIfAbsent(type, i -> new ArrayList()).stream().filter(p -> {
            CostList cl = (CostList)MainCostListService.INSTANCE.newNegatedCostList(list);
            if (((CostList)p.three).equals(cl)) {
                ILabel.MERGER.merge((ILabel)p.one, fin).ifPresent(i -> {
                    p.one = i;
                    Object cfr_ignored_0 = p.one;
                });
                p.two = MainCostListService.INSTANCE.strictMergeCostList(p.two, cl);
                return true;
            }
            return false;
        }).findAny().orElseGet(() -> {
            Trio ret = new Trio(fin, MainCostListService.INSTANCE.newNegatedCostList(list), MainCostListService.INSTANCE.newNegatedCostList(list));
            ((List)dst.get((Object)type)).add(ret);
            return ret;
        });
    }

    private static Optional<ItemStack> getCatalyst(@Nonnull IRecipeHandler handler) {
        String handlerID;
        if (!NEIPlugin.isCatalystEnabled()) {
            return Optional.empty();
        }
        String handlerName = handler.toString().split("@")[0];
        HandlerInfo info = GuiRecipeTab.getHandlerInfo((String)handlerName, (String)(handlerID = handler instanceof TemplateRecipeHandler ? ((TemplateRecipeHandler)handler).getOverlayIdentifier() : null));
        if (info == null) {
            return Optional.empty();
        }
        ItemStack itemStack = info.getItemStack();
        return Optional.ofNullable(itemStack);
    }
}

