/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WLabel;
import me.towdium.jecalculation.polyfill.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class WLabelGroup
extends WContainer {
    ArrayList<WLabel> labels = new ArrayList();
    IWidget.ListenerValue<? super WLabelGroup, Integer> lsnrUpdate;
    IWidget.ListenerValue<? super WLabelGroup, Integer> lsnrLeftClick;
    IWidget.ListenerValue<? super WLabelGroup, Integer> lsnrRightClick;

    public WLabelGroup(int xPos, int yPos, int column, int row, boolean accept) {
        this(xPos, yPos, column, row, 18, 18, accept);
    }

    public WLabelGroup(int xPos, int yPos, int column, int row, int xSize, int ySize, boolean accept) {
        int j = 0;
        while (j < row) {
            int r = j++;
            IntStream.range(0, column).forEach(c -> {
                WLabel l = new WLabel(xPos + c * xSize, yPos + r * ySize, xSize, ySize, accept).setLsnrUpdate((? super WLabel i, ILabel v) -> {
                    if (this.lsnrUpdate != null) {
                        this.lsnrUpdate.invoke(this, r * column + c);
                    }
                }).setLsnrLeftClick((? super WLabel i) -> {
                    if (this.lsnrLeftClick != null) {
                        this.lsnrLeftClick.invoke(this, r * column + c);
                    }
                }).setLsnrRightClick((? super WLabel i) -> {
                    if (this.lsnrRightClick != null) {
                        this.lsnrRightClick.invoke(this, r * column + c);
                    }
                });
                this.labels.add(l);
                this.add(l);
            });
        }
    }

    public WLabel get(int index) {
        return this.labels.get(index);
    }

    public List<ILabel> getLabels() {
        return this.labels.stream().map(WLabel::getLabel).collect(Collectors.toList());
    }

    public void setLabel(ILabel label, int index) {
        this.labels.get(index).setLabel(label);
    }

    public void setLabel(List<ILabel> labels, int start) {
        for (WLabel label : this.labels) {
            label.setLabel(start < labels.size() ? labels.get(start++) : ILabel.EMPTY);
        }
    }

    public WLabelGroup setLsnrUpdate(IWidget.ListenerValue<? super WLabelGroup, Integer> listener) {
        this.lsnrUpdate = listener;
        return this;
    }

    public WLabelGroup setLsnrLeftClick(IWidget.ListenerValue<? super WLabelGroup, Integer> listener) {
        this.lsnrLeftClick = listener;
        return this;
    }

    public WLabelGroup setLsnrRightClick(IWidget.ListenerValue<? super WLabelGroup, Integer> listener) {
        this.lsnrRightClick = listener;
        return this;
    }

    public WLabelGroup setLsnrScroll(IWidget.ListenerValue<? super WLabel, Integer> hdlr) {
        this.labels.forEach(i -> i.setLsnrScroll(hdlr));
        return this;
    }

    public WLabelGroup setFmtAmount(Function<ILabel, String> f) {
        this.labels.forEach(i -> i.setFmtAmount(f));
        return this;
    }

    public WLabelGroup setFmtTooltip(BiConsumer<ILabel, List<String>> f) {
        this.labels.forEach(i -> i.setFmtTooltip(f));
        return this;
    }
}

