/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WTooltip;
import me.towdium.jecalculation.polyfill.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.utils.ClientUtils;
import org.lwjgl.input.Keyboard;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public abstract class WButton
extends WTooltip {
    protected int xPos;
    protected int yPos;
    protected int xSize;
    protected int ySize;
    protected IWidget.ListenerAction<? super WButton> listener;
    protected boolean disabled;
    protected int[] keys;

    public WButton(int xPos, int yPos, int xSize, int ySize, @Nullable String name) {
        super(name);
        this.xPos = xPos;
        this.yPos = yPos;
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public WButton setListener(IWidget.ListenerAction<? super WButton> r) {
        this.listener = r;
        return this;
    }

    @Override
    public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
        super.onDraw(gui, xMouse, yMouse);
        boolean hovered = this.hovered(xMouse, yMouse);
        Resource res = this.disabled ? Resource.WGT_BUTTON_D : (hovered ? Resource.WGT_BUTTON_F : Resource.WGT_BUTTON_N);
        gui.drawResourceContinuous(res, this.xPos, this.yPos, this.xSize, this.ySize, 5, 5, 5, 5);
        return hovered;
    }

    @Override
    public boolean onMouseClicked(JecaGui gui, int xMouse, int yMouse, int button) {
        if (this.mouseIn(xMouse, yMouse) && !this.disabled && button == 0 && this.listener != null) {
            this.trigger();
            return true;
        }
        return false;
    }

    protected boolean hovered(int xMouse, int yMouse) {
        if (this.mouseIn(xMouse, yMouse)) {
            return true;
        }
        if (this.keys != null) {
            for (int i : this.keys) {
                if (!Keyboard.isKeyDown((int)i)) continue;
                return true;
            }
        }
        return false;
    }

    private void trigger() {
        this.listener.invoke(this);
        ClientUtils.playClickSound(1.0f);
    }

    @Override
    public boolean onKeyPressed(JecaGui gui, char ch, int code) {
        if (this.keys != null) {
            for (int i : this.keys) {
                if (i != code) continue;
                this.trigger();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseIn(int xMouse, int yMouse) {
        return JecaGui.mouseIn(this.xPos, this.yPos, this.xSize - 2, this.ySize - 2, xMouse, yMouse);
    }

    public WButton setDisabled(boolean b) {
        this.disabled = b;
        return this;
    }

    @Override
    protected List<String> getSuffix() {
        return this.disabled ? Arrays.asList("disabled", "enabled", "") : Arrays.asList("enabled", "");
    }

    public WButton setKeyBind(int ... keys) {
        this.keys = keys;
        return this;
    }
}

