/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.structure.RecordMath;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.Gui;
import me.towdium.jecalculation.gui.widgets.WButtonIcon;
import me.towdium.jecalculation.gui.widgets.WButtonText;
import me.towdium.jecalculation.gui.widgets.WHelp;
import me.towdium.jecalculation.gui.widgets.WLcd;
import me.towdium.jecalculation.gui.widgets.WLine;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.polyfill.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.utils.Utilities;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GuiMath
extends Gui {
    WLcd lcd = new WLcd(7);
    LinkedList<BigDecimal> numbers;
    BigDecimal last;
    int dot;
    boolean sign;
    RecordMath.Operator operator;
    RecordMath.State state;

    public GuiMath() {
        this.add(new WHelp("math"));
        this.add(new WPanel(), this.lcd);
        this.add(new WButtonText(7, 67, 28, 20, "7", null, true).setListener(i -> this.append(7)).setKeyBind(8, 71));
        this.add(new WButtonText(39, 67, 28, 20, "8", null, true).setListener(i -> this.append(8)).setKeyBind(9, 72));
        this.add(new WButtonText(71, 67, 28, 20, "9", null, true).setListener(i -> this.append(9)).setKeyBind(10, 73));
        this.add(new WButtonText(7, 91, 28, 20, "4", null, true).setListener(i -> this.append(4)).setKeyBind(5, 75));
        this.add(new WButtonText(39, 91, 28, 20, "5", null, true).setListener(i -> this.append(5)).setKeyBind(6, 76));
        this.add(new WButtonText(71, 91, 28, 20, "6", null, true).setListener(i -> this.append(6)).setKeyBind(7, 77));
        this.add(new WButtonText(7, 115, 28, 20, "1", null, true).setListener(i -> this.append(1)).setKeyBind(2, 79));
        this.add(new WButtonText(39, 115, 28, 20, "2", null, true).setListener(i -> this.append(2)).setKeyBind(3, 80));
        this.add(new WButtonText(71, 115, 28, 20, "3", null, true).setListener(i -> this.append(3)).setKeyBind(4, 81));
        this.add(new WButtonText(7, 139, 28, 20, "0", null, true).setListener(i -> this.append(0)).setKeyBind(11, 82));
        this.add(new WButtonText(39, 139, 28, 20, "00", null, true).setListener(i -> {
            this.append(0);
            this.append(0);
        }));
        this.add(new WButtonText(71, 139, 28, 20, ".", null, true).setListener(i -> this.dot()).setKeyBind(52, 83));
        this.add(new WButtonIcon(109, 67, 28, 20, Resource.WGT_ARR_L).setListener(i -> this.remove()).setKeyBind(14));
        this.add(new WButtonText(141, 67, 28, 20, "+", null, true).setListener(i -> this.operate(RecordMath.Operator.PLUS)).setKeyBind(13, 78));
        this.add(new WButtonText(109, 91, 28, 20, "C", null, true).setListener(i -> this.reset()).setKeyBind(211));
        this.add(new WButtonText(141, 91, 28, 20, "-", null, true).setListener(i -> this.operate(RecordMath.Operator.MINUS)).setKeyBind(74, 12));
        this.add(new WButtonText(109, 115, 28, 44, "=", null, true).setListener(i -> this.operate(RecordMath.Operator.EQUALS)).setKeyBind(28, 156, 141));
        this.add(new WButtonText(141, 115, 28, 20, "x", null, true).setListener(i -> this.operate(RecordMath.Operator.TIMES)).setKeyBind(40, 55));
        this.add(new WButtonText(141, 139, 28, 20, "/", null, true).setListener(i -> this.operate(RecordMath.Operator.DIVIDE)).setKeyBind(53, 181));
        this.add(new WLine(61), new WLine(103, 61, 98, false), new WLine.Joint(103, 61, false, true, true, true));
        RecordMath recordMath = Controller.getRMath();
        this.state = recordMath.state;
        this.operator = recordMath.operator;
        this.last = recordMath.last;
        this.dot = recordMath.getDot();
        this.sign = recordMath.getSign();
        this.numbers = recordMath.getNumbers();
        this.print();
    }

    private void print() {
        if (this.state == RecordMath.State.INPUT) {
            String s;
            String string = s = this.numbers.isEmpty() ? "0" : this.numbers.stream().map(Object::toString).collect(Collectors.joining());
            if (!this.sign) {
                s = '-' + Utilities.repeat(" ", 6 - s.length()) + s;
            }
            this.lcd.text = s;
            this.lcd.dot = this.dot;
        } else if (this.state == RecordMath.State.ERROR) {
            this.lcd.text = "Error";
            this.lcd.dot = -1;
        } else if (this.state == RecordMath.State.OUTPUT) {
            this.lcd.print(this.last);
        }
        this.lcd.operator = this.operator;
    }

    private void append(int i) {
        if (this.state != RecordMath.State.INPUT) {
            this.state = RecordMath.State.INPUT;
        }
        if (!(i == 0 && this.numbers.isEmpty() || this.numbers.size() >= (this.sign ? 7 : 6))) {
            this.numbers.add(new BigDecimal(i));
            if (this.dot != -1) {
                ++this.dot;
            }
        }
        this.print();
        this.sync();
    }

    private void sync() {
        Controller.setRMath(new RecordMath(this.state, this.operator, this.last, this.sign, this.dot, this.numbers));
    }

    private void operate(RecordMath.Operator operator) {
        if (this.state == RecordMath.State.INPUT && this.numbers.isEmpty() && operator == RecordMath.Operator.MINUS) {
            this.sign = !this.sign;
        } else {
            if (this.state == RecordMath.State.INPUT) {
                try {
                    this.last = this.operator.operate(this.last, this.convert());
                }
                catch (ArithmeticException e) {
                    this.state = RecordMath.State.ERROR;
                    this.operator = RecordMath.Operator.EQUALS;
                    this.print();
                    this.sync();
                    return;
                }
                finally {
                    this.numbers.clear();
                    this.dot = -1;
                    this.sign = true;
                }
            }
            this.operator = operator;
            this.state = RecordMath.State.OUTPUT;
        }
        this.print();
        this.sync();
    }

    private void dot() {
        if (this.state != RecordMath.State.INPUT) {
            this.state = RecordMath.State.INPUT;
        }
        if (this.numbers.size() == 0) {
            this.numbers.add(BigDecimal.ZERO);
        }
        this.dot = 0;
        this.print();
        this.sync();
    }

    private void remove() {
        if (this.state != RecordMath.State.INPUT) {
            this.reset();
        }
        if (this.numbers.size() > 0) {
            this.numbers.removeLast();
            if (this.dot != -1) {
                --this.dot;
            }
        }
        this.print();
        this.sync();
    }

    private void reset() {
        this.last = BigDecimal.ZERO;
        this.operator = RecordMath.Operator.EQUALS;
        this.numbers.clear();
        this.dot = -1;
        this.sign = true;
        this.state = RecordMath.State.INPUT;
        this.print();
        this.sync();
    }

    private BigDecimal convert() {
        BigDecimal f = new BigDecimal(0);
        for (BigDecimal i : this.numbers) {
            f = f.add(i).multiply(BigDecimal.TEN);
        }
        f = f.divide(BigDecimal.TEN.pow(Math.max(this.dot, 0) + 1), RecordMath.context);
        if (!this.sign) {
            f = f.negate();
        }
        return f;
    }
}

