/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.guis.Gui;
import me.towdium.jecalculation.gui.guis.pickers.IPicker;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WHelp;
import me.towdium.jecalculation.gui.widgets.WPage;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.polyfill.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.utils.wrappers.Wrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class GuiLabel
extends Gui {
    WContainer container = new WContainer();
    IPicker current;
    Consumer<ILabel> callback;
    LoadingCache<Integer, IPicker> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, IPicker>(){

        public IPicker load(Integer i) {
            ILabel.RegistryEditor.Record record = ILabel.EDITOR.getRecords().get(i);
            return record.editor.get().setCallback(GuiLabel.this.callback);
        }
    });

    public GuiLabel(Consumer<ILabel> callback) {
        this.callback = callback;
        Wrapper<Integer> index = new Wrapper<Integer>(0);
        ILabel.EDITOR.getRecords().forEach(r -> {
            int i = (Integer)index.value;
            this.add(new WPage(i, (ILabel.RegistryEditor.Record)r, false).setListener(j -> this.refresh(i)));
            index.value = (Integer)index.value + 1;
        });
        this.add(new WHelp("label"), new WPanel());
        this.add(this.container);
        this.refresh(0);
    }

    @Override
    public boolean acceptsLabel() {
        return this.current.acceptsLabel();
    }

    protected void refresh(int index) {
        this.container.clear();
        this.current = (IPicker)this.cache.getUnchecked((Object)index);
        this.container.add(this.current);
        this.container.add(new WPage(index, ILabel.EDITOR.getRecords().get(index), true));
    }
}

