/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.structure;

import java.util.LinkedList;
import java.util.List;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.IRecord;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RecordGroupCraft
implements IRecord {
    public static final String KEY_ITEMS = "items";
    LinkedList<ILabel> craftList = new LinkedList();

    public RecordGroupCraft(NBTTagCompound nbt) {
    }

    public void addLabel(ILabel l) {
        if (l == ILabel.EMPTY) {
            return;
        }
        this.craftList.remove(l);
        this.craftList.addFirst(l);
    }

    public void setAmount(int index, long amount) {
        if (index < 0 || index >= this.craftList.size()) {
            return;
        }
        ILabel l = this.craftList.get(index);
        if (l == ILabel.EMPTY) {
            return;
        }
        l.setAmount(amount);
    }

    public void removeLabel(int index) {
        if (index < 0 || index >= this.craftList.size()) {
            return;
        }
        this.craftList.remove(index);
    }

    public List<ILabel> getCraftList() {
        return this.craftList;
    }

    public ILabel getFirstOrEmpty() {
        return this.craftList.isEmpty() ? ILabel.EMPTY : this.craftList.getFirst();
    }

    @Override
    public NBTTagCompound serialize() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList items = new NBTTagList();
        this.craftList.forEach(l -> items.func_74742_a((NBTBase)ILabel.SERIALIZER.serialize((ILabel)l)));
        nbt.func_74782_a(KEY_ITEMS, (NBTBase)items);
        return nbt;
    }
}

