/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.structure.Calculation;
import me.towdium.jecalculation.polyfill.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractCostListService<LabelT, RecipeT, CostListT> {
    private final Dependencies<LabelT, RecipeT> d;
    private final CostLists<LabelT, CostListT> costLists;
    private final Class<CostListT> costListClass;

    AbstractCostListService(Dependencies<LabelT, RecipeT> dependencies, CostLists<LabelT, CostListT> costLists, Class<CostListT> costListClass) {
        this.d = dependencies;
        this.costLists = costLists;
        this.costListClass = costListClass;
    }

    public CostListT newNegatedCostList(List<LabelT> labels) {
        List negativeLabels = labels.stream().filter(this.d::isNotEmptyLabel).map(i -> this.d.multiplyLabel(this.d.copyLabel(i), -1.0f)).collect(Collectors.toList());
        return this.costLists.newCostList(negativeLabels);
    }

    public CostListT newPosNegCostList(List<LabelT> positive, List<LabelT> negative) {
        CostListT ret = this.newNegatedCostList(positive);
        this.multiply(ret, -1L);
        this.mergeInplace(ret, this.newNegatedCostList(negative), false);
        return ret;
    }

    public CostListT strictMergeCostList(CostListT a, CostListT b) {
        return this.mergeCostLists(a, b, false);
    }

    public List<LabelT> getLabels(CostListT costList) {
        return this.costLists.getLabels(costList);
    }

    public Calculation<LabelT> calculate(final CostListT costList) {
        final ArrayList procedure = new ArrayList();
        final ArrayList catalysts = new ArrayList();
        return new Calculation<LabelT>(){
            private Iterator<RecipeT> iterator;
            private int index;
            {
                this.iterator = AbstractCostListService.this.d.recipeIterator();
                HashSet<Object> set = new HashSet<Object>();
                set.add(costList);
                this.reset();
                Pair next = this.find();
                int count = 0;
                while (next != null) {
                    class 1ProcedureStep {
                        CostListT stillNeeded;
                        RecipeT recipe;
                        long multiplier;
                        CostListT multipliedRecipeOutputs;

                        1ProcedureStep() {
                        }
                    }
                    1ProcedureStep procedureStep = new 1ProcedureStep();
                    procedureStep.recipe = next.one;
                    procedureStep.multiplier = (Long)next.two;
                    Object original = this.getCurrent();
                    List outL = AbstractCostListService.this.d.getRecipeOutput(next.one).stream().filter(AbstractCostListService.this.d::isNotEmptyLabel).collect(Collectors.toList());
                    Object outC = AbstractCostListService.this.newNegatedCostList(outL);
                    AbstractCostListService.this.multiply(outC, -((Long)next.two).longValue());
                    procedureStep.multipliedRecipeOutputs = outC;
                    List inL = AbstractCostListService.this.d.getRecipeInput(next.one).stream().filter(AbstractCostListService.this.d::isNotEmptyLabel).collect(Collectors.toList());
                    Object inC = AbstractCostListService.this.newNegatedCostList(inL);
                    AbstractCostListService.this.multiply(inC, (Long)next.two);
                    Object result = AbstractCostListService.this.mergeCostLists(original, outC, false);
                    AbstractCostListService.this.mergeInplace(result, inC, false);
                    procedureStep.stillNeeded = result;
                    if (!set.contains(result)) {
                        set.add(result);
                        procedure.add(procedureStep);
                        this.addCatalyst(AbstractCostListService.this.d.getRecipeCatalyst(next.one));
                        this.reset();
                    }
                    next = this.find();
                    if (count++ <= 1000) continue;
                    AbstractCostListService.this.d.addMaxLoopChatMessage();
                    break;
                }
            }

            @Override
            public List<LabelT> getCatalysts() {
                return catalysts;
            }

            @Override
            public List<LabelT> getInputs() {
                return AbstractCostListService.this.getLabels(this.getCurrent()).stream().filter(i -> AbstractCostListService.this.d.getLabelAmount(i) < 0L).map(i -> AbstractCostListService.this.d.multiplyLabel(AbstractCostListService.this.d.copyLabel(i), -1.0f)).collect(Collectors.toList());
            }

            @Override
            public List<LabelT> getOutputs(List<LabelT> ignore) {
                return AbstractCostListService.this.getLabels(this.getCurrent()).stream().map(i -> AbstractCostListService.this.d.multiplyLabel(AbstractCostListService.this.d.copyLabel(i), -1.0f)).map(i -> ignore.stream().flatMap(j -> Utilities.stream(AbstractCostListService.this.d.mergeLabels(i, j))).findFirst().orElse(i)).filter(i -> AbstractCostListService.this.d.isNotEmptyLabel(i) && AbstractCostListService.this.d.getLabelAmount(i) < 0L).map(i -> AbstractCostListService.this.d.multiplyLabel(i, -1.0f)).collect(Collectors.toList());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public List<LabelT> getSteps(List<LabelT> givenInventory) {
                ArrayList startingInventory = new ArrayList(givenInventory);
                startingInventory.addAll(this.getInputs());
                Object inventory = AbstractCostListService.this.costLists.newCostList(startingInventory);
                ArrayList remainingProcedureSteps = new ArrayList(procedure);
                ArrayList optimizedSteps = new ArrayList();
                while (!remainingProcedureSteps.isEmpty()) {
                    void var8_8;
                    Object preferredRecipe = optimizedSteps.isEmpty() ? null : ((Pair)optimizedSteps.get((int)(optimizedSteps.size() - 1))).one;
                    Integer indexOfBestStep = null;
                    Object var8_9 = null;
                    int sizeOfInventoryAfterBestStep = Integer.MAX_VALUE;
                    for (int i2 = remainingProcedureSteps.size() - 1; i2 >= 0; --i2) {
                        ProcedureStep step = (ProcedureStep)remainingProcedureSteps.get(i2);
                        Object candidateInventory = AbstractCostListService.this.mergeCostLists(inventory, AbstractCostListService.this.recipeAsCostList(step.recipe, step.multiplier), false);
                        if (!this.isAllPositive(candidateInventory)) continue;
                        int inventorySize = AbstractCostListService.this.estimatedNumSlotsTakenBy(candidateInventory);
                        if (indexOfBestStep == null) {
                            indexOfBestStep = i2;
                            Object object = candidateInventory;
                            sizeOfInventoryAfterBestStep = inventorySize;
                            continue;
                        }
                        ProcedureStep bestStep = (ProcedureStep)remainingProcedureSteps.get(indexOfBestStep);
                        if (step.recipe.equals(preferredRecipe) && !bestStep.recipe.equals(preferredRecipe)) {
                            indexOfBestStep = i2;
                            Object object = candidateInventory;
                            break;
                        }
                        if (inventorySize >= sizeOfInventoryAfterBestStep) continue;
                        indexOfBestStep = i2;
                        Object object = candidateInventory;
                        sizeOfInventoryAfterBestStep = inventorySize;
                    }
                    if (indexOfBestStep == null) {
                        optimizedSteps = null;
                        break;
                    }
                    ProcedureStep bestStep = (ProcedureStep)remainingProcedureSteps.remove(indexOfBestStep);
                    inventory = var8_8;
                    if (!optimizedSteps.isEmpty() && bestStep.recipe.equals(preferredRecipe)) {
                        Pair latest = (Pair)optimizedSteps.get(optimizedSteps.size() - 1);
                        latest.two = (Long)latest.two + bestStep.multiplier;
                        continue;
                    }
                    optimizedSteps.add(new Pair(bestStep.recipe, bestStep.multiplier));
                }
                if (optimizedSteps != null) {
                    ArrayList retLabels = new ArrayList(optimizedSteps.size());
                    for (Pair pair : optimizedSteps) {
                        List outL = AbstractCostListService.this.d.getRecipeOutput(pair.one).stream().filter(AbstractCostListService.this.d::isNotEmptyLabel).collect(Collectors.toList());
                        Object outC = AbstractCostListService.this.newNegatedCostList(outL);
                        AbstractCostListService.this.multiply(outC, -((Long)pair.two).longValue());
                        retLabels.add(AbstractCostListService.this.costLists.getLabels(outC).get(0));
                    }
                    return retLabels;
                }
                List ret = procedure.stream().map(i -> AbstractCostListService.this.costLists.getLabels(i.multipliedRecipeOutputs).get(0)).collect(Collectors.toList());
                Collections.reverse(ret);
                Object cl = AbstractCostListService.this.multiply(AbstractCostListService.this.newNegatedCostList(ret), -1L);
                Object temp = AbstractCostListService.this.newNegatedCostList(new ArrayList());
                AbstractCostListService.this.mergeInplace(temp, cl, false);
                return AbstractCostListService.this.costLists.getLabels(temp);
            }

            private boolean isAllPositive(CostListT candidateInventory) {
                for (Object label : AbstractCostListService.this.costLists.getLabels(candidateInventory)) {
                    if (AbstractCostListService.this.d.getLabelAmount(label) >= 0L) continue;
                    return false;
                }
                return true;
            }

            private void reset() {
                this.index = 0;
                this.iterator = AbstractCostListService.this.d.recipeIterator();
            }

            @Nullable
            private Pair<RecipeT, Long> find() {
                List labels = AbstractCostListService.this.getLabels(this.getCurrent());
                while (this.index < labels.size()) {
                    Object label = labels.get(this.index);
                    if (AbstractCostListService.this.d.getLabelAmount(label) < 0L) {
                        while (this.iterator.hasNext()) {
                            Object r = this.iterator.next();
                            if (!AbstractCostListService.this.d.recipeOutputMatches(r, label).isPresent()) continue;
                            return new Pair(r, AbstractCostListService.this.d.multiplier(r, label));
                        }
                        this.iterator = AbstractCostListService.this.d.recipeIterator();
                    }
                    ++this.index;
                }
                return null;
            }

            private void addCatalyst(List<LabelT> labels) {
                labels.stream().filter(AbstractCostListService.this.d::isNotEmptyLabel).forEach(i -> catalysts.stream().filter(j -> AbstractCostListService.this.d.labelMatches(j, i)).findAny().map(j -> AbstractCostListService.this.d.setLabelAmount(j, Math.max(AbstractCostListService.this.d.getLabelAmount(i), AbstractCostListService.this.d.getLabelAmount(j)))).orElseGet(Utilities.fake(() -> catalysts.add(i))));
            }

            private CostListT getCurrent() {
                return procedure.isEmpty() ? costList : ((ProcedureStep)procedure.get((int)(procedure.size() - 1))).stillNeeded;
            }
        };
    }

    private CostListT mergeCostLists(CostListT a, CostListT b, boolean strict) {
        CostListT ret = this.copyCostList(a);
        this.mergeInplace(ret, b, strict);
        return ret;
    }

    private void mergeInplace(CostListT self, CostListT that, boolean strict) {
        List<LabelT> thisLabels = this.getLabels(self);
        this.getLabels(that).forEach(i -> thisLabels.add(this.d.copyLabel(i)));
        for (int i2 = 0; i2 < thisLabels.size(); ++i2) {
            for (int j = i2 + 1; j < thisLabels.size(); ++j) {
                if (strict) {
                    LabelT b;
                    LabelT a = thisLabels.get(i2);
                    if (!this.d.labelMatches(a, b = thisLabels.get(j))) continue;
                    thisLabels.set(i2, this.d.setLabelAmount(a, Math.addExact(this.d.getLabelAmount(a), this.d.getLabelAmount(b))));
                    thisLabels.set(j, this.d.getEmptyLabel());
                    continue;
                }
                Optional<LabelT> l = this.d.mergeLabels(thisLabels.get(i2), thisLabels.get(j));
                if (!l.isPresent()) continue;
                thisLabels.set(i2, l.get());
                thisLabels.set(j, this.d.getEmptyLabel());
            }
        }
        this.costLists.setLabels(self, thisLabels.stream().filter(this.d::isNotEmptyLabel).collect(Collectors.toList()));
    }

    private CostListT multiply(CostListT self, long i) {
        this.costLists.setLabels(self, this.costLists.getLabels(self).stream().map(j -> this.d.multiplyLabel(j, i)).collect(Collectors.toList()));
        return self;
    }

    boolean costListEquals(CostListT self, Object obj) {
        if (this.costListClass.isInstance(obj)) {
            Object c = obj;
            Object m = this.multiply(this.copyCostList(c), -1L);
            return this.getLabels(this.mergeCostLists(self, m, true)).isEmpty();
        }
        return false;
    }

    protected CostListT copyCostList(CostListT from) {
        CostListT ret = this.newNegatedCostList(Collections.emptyList());
        this.costLists.setLabels(ret, this.costLists.getLabels(from).stream().map(this.d::copyLabel).collect(Collectors.toList()));
        return ret;
    }

    private CostListT recipeAsCostList(RecipeT recipe, long multiplier) {
        List outL = this.d.getRecipeOutput(recipe).stream().filter(this.d::isNotEmptyLabel).collect(Collectors.toList());
        CostListT outC = this.newNegatedCostList(outL);
        this.multiply(outC, -multiplier);
        List inL = this.d.getRecipeInput(recipe).stream().filter(this.d::isNotEmptyLabel).collect(Collectors.toList());
        CostListT inC = this.newNegatedCostList(inL);
        this.multiply(inC, multiplier);
        return this.mergeCostLists(inC, outC, false);
    }

    private int estimatedNumSlotsTakenBy(CostListT costLisT) {
        int total = 0;
        for (LabelT label : this.costLists.getLabels(costLisT)) {
            total += (int)Math.ceil((double)this.d.getLabelAmount(label) / 64.0);
        }
        return total;
    }

    static interface CostLists<LabelT, CostListT> {
        public CostListT newCostList(List<LabelT> var1);

        public List<LabelT> getLabels(CostListT var1);

        public void setLabels(CostListT var1, List<LabelT> var2);
    }

    static interface Dependencies<LabelT, RecipeT> {
        public LabelT copyLabel(LabelT var1);

        public LabelT getEmptyLabel();

        public long getLabelAmount(LabelT var1);

        public boolean isNotEmptyLabel(LabelT var1);

        public boolean labelMatches(LabelT var1, LabelT var2);

        public Optional<LabelT> mergeLabels(LabelT var1, LabelT var2);

        public LabelT multiplyLabel(LabelT var1, float var2);

        public LabelT setLabelAmount(LabelT var1, long var2);

        public List<LabelT> getRecipeCatalyst(RecipeT var1);

        public List<LabelT> getRecipeInput(RecipeT var1);

        public List<LabelT> getRecipeOutput(RecipeT var1);

        public Optional<LabelT> recipeOutputMatches(RecipeT var1, LabelT var2);

        public long multiplier(RecipeT var1, LabelT var2);

        public Iterator<RecipeT> recipeIterator();

        public void addMaxLoopChatMessage();
    }
}

