/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.LItemStack;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.polyfill.mc.util.NonNullList;
import me.towdium.jecalculation.utils.ItemStackHelper;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

@ParametersAreNonnullByDefault
public class LOreDict
extends ILabel.Impl {
    public static final String IDENTIFIER = "oreDict";
    public static final String KEY_NAME = "name";
    public static final boolean MODE_FORCE = false;
    protected String name;

    public LOreDict(String name) {
        this(name, 1L);
    }

    public LOreDict(String name, long amount) {
        super(amount, false);
        this.name = name;
    }

    public LOreDict(LOreDict lod) {
        super(lod);
        this.name = lod.name;
    }

    public LOreDict(NBTTagCompound nbt) {
        super(nbt);
        this.name = nbt.func_74779_i(KEY_NAME);
    }

    public static boolean mergeSame(ILabel a, ILabel b) {
        if (a instanceof LOreDict && b instanceof LOreDict) {
            LOreDict lodA = (LOreDict)a;
            LOreDict lodB = (LOreDict)b;
            return lodA.getName().equals(lodB.getName());
        }
        return false;
    }

    public static boolean mergeFuzzy(ILabel a, ILabel b) {
        if (a instanceof LOreDict && b instanceof LItemStack) {
            LOreDict lod = (LOreDict)a;
            LItemStack lis = (LItemStack)b;
            if (lod.getAmount() * lis.getAmount() < 0L) {
                for (ItemStack ore : OreDictionary.getOres((String)lod.name)) {
                    if (!LItemStack.merge(ILabel.Converter.from(ore), lis)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<ILabel> suggest(List<ILabel> iss, @Nullable Class<?> context) {
        ILabel l = iss.get(0);
        if (!(l instanceof LItemStack)) {
            return new ArrayList<ILabel>();
        }
        LItemStack lis = (LItemStack)l;
        HashSet<Integer> ids = new HashSet<Integer>();
        long amount = lis.getAmount();
        for (int i2 : OreDictionary.getOreIDs((ItemStack)lis.getRep())) {
            if (!LOreDict.check(i2, iss, true)) continue;
            ids.add(i2);
        }
        return ids.stream().map(i -> new LOreDict(OreDictionary.getOreName((int)i), amount)).collect(Collectors.toList());
    }

    public static List<ILabel> fallback(List<ILabel> iss, @Nullable Class<?> context) {
        ILabel l = iss.get(0);
        if (!(l instanceof LItemStack)) {
            return new ArrayList<ILabel>();
        }
        LItemStack lis = (LItemStack)l;
        HashSet<Integer> ids = new HashSet<Integer>();
        long amount = lis.getAmount();
        for (int i2 : OreDictionary.getOreIDs((ItemStack)lis.getRep())) {
            if (!LOreDict.check(i2, iss, false)) continue;
            ids.add(i2);
        }
        return ids.stream().map(i -> new LOreDict(OreDictionary.getOreName((int)i), amount)).collect(Collectors.toList());
    }

    private static boolean check(int id, List<ILabel> labels, boolean biDir) {
        boolean noneMatch;
        ArrayList ores = OreDictionary.getOres((String)OreDictionary.getOreName((int)id));
        if (labels.size() == 1 && ores.size() == 1 && biDir) {
            return false;
        }
        Wrapper<Boolean> acceptable = new Wrapper<Boolean>(true);
        if (biDir) {
            for (ItemStack ore : ores) {
                noneMatch = true;
                for (ILabel label : labels) {
                    if (!LOreDict.checkMatch(label, ore)) continue;
                    noneMatch = false;
                    break;
                }
                if (!noneMatch) continue;
                acceptable.value = false;
                break;
            }
        }
        for (ILabel label : labels) {
            noneMatch = true;
            for (ItemStack ore : ores) {
                if (!LOreDict.checkMatch(label, ore)) continue;
                noneMatch = false;
                break;
            }
            if (!noneMatch) continue;
            acceptable.value = false;
            break;
        }
        return (Boolean)acceptable.value;
    }

    private static boolean checkMatch(ILabel l, ItemStack o) {
        return l instanceof LItemStack && OreDictionary.itemMatches((ItemStack)o, (ItemStack)((LItemStack)l).getRep(), (boolean)false);
    }

    @Nonnull
    public ItemStack getRepresentation() {
        NonNullList<ItemStack> list = NonNullList.create();
        for (ItemStack ore : OreDictionary.getOres((String)this.name)) {
            if (ore.func_77960_j() == Short.MAX_VALUE) {
                Item item = ore.func_77973_b();
                item.func_150895_a(item, CreativeTabs.field_78027_g, list);
                continue;
            }
            list.add(ore);
        }
        if (list.isEmpty()) {
            return ItemStackHelper.EMPTY_ITEM_STACK;
        }
        long index = System.currentTimeMillis() / 1500L;
        return (ItemStack)list.get((int)(index % (long)list.size()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return Utilities.I18n.get("label.ore_dict.name", this.name);
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean matches(Object l) {
        return l instanceof LOreDict && this.name.equals(((LOreDict)l).name) && super.matches(l);
    }

    @Override
    public LOreDict copy() {
        return new LOreDict(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawLabel(JecaGui gui) {
        gui.drawItemStack(0, 0, this.getRepresentation(), false);
    }

    @Override
    public NBTTagCompound toNbt() {
        NBTTagCompound ret = super.toNbt();
        ret.func_74778_a(KEY_NAME, this.name);
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        existing.add("\u00a79\u00a7oJust Enough Calculation");
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ super.hashCode();
    }

    public String getName() {
        return this.name;
    }
}

