/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.JecaConfig;
import me.towdium.jecalculation.JustEnoughCalculation;
import me.towdium.jecalculation.data.label.labels.LPlaceholder;
import me.towdium.jecalculation.data.structure.IRecord;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.data.structure.Recipes;
import me.towdium.jecalculation.data.structure.RecordCraft;
import me.towdium.jecalculation.data.structure.RecordGroupCraft;
import me.towdium.jecalculation.data.structure.RecordMath;
import me.towdium.jecalculation.data.structure.RecordPlayer;
import me.towdium.jecalculation.polyfill.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class Controller {
    public static final String KEY_MATH = "math";
    public static final String KEY_GROUPCRAFT = "groupCraft";
    public static final String KEY_CRAFT = "craft";
    public static final String KEY_PLAYER = "player";
    static RecordPlayer rPlayerClient;
    static RecordGroupCraft rGroupCraftClient;
    static RecordCraft rCraftClient;
    static RecordMath rMathClient;

    static Recipes getRecipes() {
        return Controller.rPlayerClient.recipes;
    }

    static Optional<ItemStack> getStack() {
        return Optional.empty();
    }

    public static List<Pair<String, Recipes>> discover() {
        File dir = JecaConfig.dataDir;
        File[] fs = dir.listFiles();
        if (fs == null) {
            return new ArrayList<Pair<String, Recipes>>();
        }
        Function<File, Recipes> read = f -> {
            NBTTagCompound nbt = Utilities.Json.read(f);
            if (nbt == null) {
                JustEnoughCalculation.logger.warn("File " + f.getAbsolutePath() + " contains invalid records.");
                return null;
            }
            return new Recipes(nbt);
        };
        return Arrays.stream(fs).map(i -> new Pair(i.getName(), read.apply((File)i))).filter(i -> i.two != null).collect(Collectors.toList());
    }

    public static void inport(Recipes recipes, String group) {
        ArrayList buffer = new ArrayList();
        recipes.getGroup(group).stream().filter(i -> !Controller.hasDuplicate(i)).forEach(buffer::add);
        for (Recipe r : buffer) {
            Controller.addRecipe(group, r);
        }
    }

    private static void export(String s, Function<Recipes, NBTTagCompound> r) {
        EntityClientPlayerMP player = Utilities.getPlayer();
        if (player == null) {
            return;
        }
        File f = JecaConfig.getDataFile(s);
        Utilities.Json.write(r.apply(Controller.getRecipes()), f);
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("jecalculation.chat.export", new Object[]{f.getAbsolutePath()}));
    }

    public static void export(String group) {
        Controller.export(group, i -> i.serialize(Collections.singleton(group)));
    }

    public static void export() {
        Controller.export("groups", Recipes::serialize);
    }

    @Nullable
    public static String getLast() {
        return Controller.rPlayerClient.last;
    }

    static void setLast(String last) {
        Controller.rPlayerClient.last = last;
    }

    public static List<String> getGroups() {
        return Controller.getRecipes().getGroups();
    }

    public static void setRecipe(String neu, String old, int index, Recipe recipe) {
        Controller.getRecipes().set(neu, old, index, recipe);
        Controller.setLast(neu);
        Controller.writeToLocal();
    }

    public static void renameGroup(String old, String neu) {
        Controller.getRecipes().renameGroup(old, neu);
        Controller.setLast(neu);
        Controller.writeToLocal();
    }

    public static void addRecipe(String group, Recipe recipe) {
        Controller.getRecipes().add(group, recipe);
        Controller.setLast(group);
        Controller.writeToLocal();
    }

    public static void setRecipe(String group, int index, Recipe recipe) {
        Controller.getRecipes().set(group, index, recipe);
        Controller.setLast(group);
        Controller.writeToLocal();
    }

    public static void removeRecipe(String group, int index) {
        Controller.getRecipes().remove(group, index);
        Controller.setLast(group);
        Controller.writeToLocal();
    }

    public static void removeGroup(String group) {
        Controller.getRecipes().remove(group);
        Controller.setLast(group);
    }

    public static Recipe getRecipe(String group, int index) {
        return Controller.getRecipes().getRecipe(group, index);
    }

    public static Stream<Pair<String, List<Recipe>>> stream() {
        return Controller.getRecipes().stream();
    }

    public static Recipes.RecipeIterator recipeIterator() {
        return Controller.getRecipes().recipeIterator();
    }

    public static Recipes.RecipeIterator recipeIterator(String group) {
        return Controller.getRecipes().recipeIterator(group);
    }

    public static void setRMath(RecordMath math) {
        Controller.setR(math, i -> {
            rMathClient = i;
        }, KEY_MATH);
    }

    public static void setRCraft(RecordCraft rc) {
        Controller.setR(rc, i -> {
            rCraftClient = i;
        }, KEY_CRAFT);
    }

    public static RecordCraft getRCraft() {
        return Controller.getR(rCraftClient, KEY_CRAFT, RecordCraft::new);
    }

    public static RecordGroupCraft getRGroupCraft() {
        return Controller.getR(rGroupCraftClient, KEY_GROUPCRAFT, RecordGroupCraft::new);
    }

    public static void setRGroupCraft(RecordGroupCraft rgc) {
        Controller.setR(rgc, i -> {
            rGroupCraftClient = i;
        }, KEY_GROUPCRAFT);
    }

    public static RecordMath getRMath() {
        return Controller.getR(rMathClient, KEY_MATH, RecordMath::new);
    }

    private static <T extends IRecord> void setR(T t, Consumer<T> c, String s) {
        c.accept(t);
    }

    public static <T> T getR(T t, String s, Function<NBTTagCompound, T> f) {
        return t;
    }

    public static boolean hasDuplicate(Recipe r, String group, int index) {
        Recipes.RecipeIterator ri = Controller.recipeIterator();
        return ri.stream().anyMatch(i -> {
            if (ri.getIndex() == index && ri.getGroup().equals(group)) {
                return false;
            }
            return i.equals(r);
        });
    }

    public static boolean hasDuplicate(Recipe r) {
        return Controller.recipeIterator().stream().anyMatch(i -> i.equals(r));
    }

    public static void loadFromLocal() {
        JecaConfig.dataDir.mkdirs();
        File file = JecaConfig.recordFile;
        NBTTagCompound nbt = Utilities.Json.read(file);
        boolean s = LPlaceholder.state;
        LPlaceholder.state = true;
        if (nbt != null) {
            rGroupCraftClient = new RecordGroupCraft(nbt.func_74775_l(KEY_GROUPCRAFT));
            rCraftClient = new RecordCraft(nbt.func_74775_l(KEY_CRAFT));
            rMathClient = new RecordMath(nbt.func_74775_l(KEY_MATH));
            rPlayerClient = nbt.func_74764_b(KEY_PLAYER) ? new RecordPlayer(nbt.func_74775_l(KEY_PLAYER)) : new RecordPlayer();
        } else {
            rPlayerClient = new RecordPlayer();
            rGroupCraftClient = new RecordGroupCraft(new NBTTagCompound());
            rCraftClient = new RecordCraft(new NBTTagCompound());
            rMathClient = new RecordMath(new NBTTagCompound());
        }
        LPlaceholder.state = s;
    }

    public static void writeToLocal() {
        File file = JecaConfig.recordFile;
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a(KEY_GROUPCRAFT, (NBTBase)rGroupCraftClient.serialize());
        nbt.func_74782_a(KEY_CRAFT, (NBTBase)rCraftClient.serialize());
        nbt.func_74782_a(KEY_PLAYER, (NBTBase)rPlayerClient.serialize());
        nbt.func_74782_a(KEY_MATH, (NBTBase)rMathClient.serialize());
        Utilities.Json.write(nbt, file);
    }
}

