/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner.components;

import Ic2ExpReactorPlanner.components.ReactorItem;
import java.awt.Image;
import java.util.ArrayList;

public class Vent
extends ReactorItem {
    private final int selfVent;
    private final int hullDraw;
    private final int sideVent;

    public Vent(int id, String baseName, String name, Image image, double maxDamage, double maxHeat, String sourceMod, int selfVent, int hullDraw, int sideVent) {
        super(id, baseName, name, image, maxDamage, maxHeat, sourceMod);
        this.selfVent = selfVent;
        this.hullDraw = hullDraw;
        this.sideVent = sideVent;
    }

    public Vent(Vent other) {
        super(other);
        this.selfVent = other.selfVent;
        this.hullDraw = other.hullDraw;
        this.sideVent = other.sideVent;
    }

    @Override
    public double dissipate() {
        double currentDissipation;
        double deltaHeat;
        this.currentHullCooling = deltaHeat = Math.min((double)this.hullDraw, this.parent.getCurrentHeat());
        this.parent.adjustCurrentHeat(-deltaHeat);
        this.adjustCurrentHeat(deltaHeat);
        this.currentVentCooling = currentDissipation = Math.min((double)this.selfVent, this.getCurrentHeat());
        this.parent.ventHeat(currentDissipation);
        this.adjustCurrentHeat(-currentDissipation);
        if (this.sideVent > 0) {
            ArrayList<ReactorItem> coolableNeighbors = new ArrayList<ReactorItem>(4);
            ReactorItem component = this.parent.getComponentAt(this.row - 1, this.col);
            if (component != null && component.isCoolable()) {
                coolableNeighbors.add(component);
            }
            if ((component = this.parent.getComponentAt(this.row, this.col + 1)) != null && component.isCoolable()) {
                coolableNeighbors.add(component);
            }
            if ((component = this.parent.getComponentAt(this.row + 1, this.col)) != null && component.isCoolable()) {
                coolableNeighbors.add(component);
            }
            if ((component = this.parent.getComponentAt(this.row, this.col - 1)) != null && component.isCoolable()) {
                coolableNeighbors.add(component);
            }
            for (ReactorItem coolableNeighbor : coolableNeighbors) {
                double rejectedCooling = coolableNeighbor.adjustCurrentHeat(-this.sideVent);
                double tempDissipatedHeat = (double)this.sideVent + rejectedCooling;
                this.parent.ventHeat(tempDissipatedHeat);
                this.currentVentCooling += tempDissipatedHeat;
            }
        }
        this.bestVentCooling = Math.max(this.bestVentCooling, this.currentVentCooling);
        return currentDissipation;
    }

    @Override
    public double getVentCoolingCapacity() {
        double result = this.selfVent;
        if (this.sideVent > 0) {
            ReactorItem component = this.parent.getComponentAt(this.row - 1, this.col);
            if (component != null && component.isCoolable()) {
                result += (double)this.sideVent;
            }
            if ((component = this.parent.getComponentAt(this.row, this.col + 1)) != null && component.isCoolable()) {
                result += (double)this.sideVent;
            }
            if ((component = this.parent.getComponentAt(this.row + 1, this.col)) != null && component.isCoolable()) {
                result += (double)this.sideVent;
            }
            if ((component = this.parent.getComponentAt(this.row, this.col - 1)) != null && component.isCoolable()) {
                result += (double)this.sideVent;
            }
        }
        return result;
    }

    @Override
    public double getHullCoolingCapacity() {
        return this.hullDraw;
    }

    @Override
    public double getCurrentOutput() {
        return this.currentVentCooling;
    }
}

