/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner.components;

import Ic2ExpReactorPlanner.components.ReactorItem;
import java.awt.Image;

public class Reflector
extends ReactorItem {
    private static String mcVersion = "1.12.2";

    public Reflector(int id, String baseName, String name, Image image, double maxDamage, double maxHeat, String sourceMod) {
        super(id, baseName, name, image, maxDamage, maxHeat, sourceMod);
    }

    public Reflector(Reflector other) {
        super(other);
    }

    @Override
    public boolean isNeutronReflector() {
        return !this.isBroken();
    }

    @Override
    public double generateHeat() {
        ReactorItem component = this.parent.getComponentAt(this.row - 1, this.col);
        if (component != null) {
            this.applyDamage(component.getRodCount());
        }
        if ((component = this.parent.getComponentAt(this.row, this.col + 1)) != null) {
            this.applyDamage(component.getRodCount());
        }
        if ((component = this.parent.getComponentAt(this.row + 1, this.col)) != null) {
            this.applyDamage(component.getRodCount());
        }
        if ((component = this.parent.getComponentAt(this.row, this.col - 1)) != null) {
            this.applyDamage(component.getRodCount());
        }
        return 0.0;
    }

    @Override
    public double getMaxDamage() {
        if (this.maxDamage > 1.0 && "1.7.10".equals(mcVersion)) {
            return this.maxDamage / 3.0;
        }
        return this.maxDamage;
    }

    public static void setMcVersion(String newVersion) {
        mcVersion = newVersion;
    }
}

