/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner.components;

import Ic2ExpReactorPlanner.Reactor;
import Ic2ExpReactorPlanner.components.Condensator;
import java.awt.Image;
import java.util.ResourceBundle;

public class ReactorItem {
    public final int id;
    public final String baseName;
    public final String name;
    public final Image image;
    protected double maxDamage;
    protected double maxHeat;
    public final String sourceMod;
    private double initialHeat = 0.0;
    private int automationThreshold = 9000;
    private int reactorPause = 0;
    protected Reactor parent = null;
    protected int row = -10;
    protected int col = -10;
    public final StringBuffer info = new StringBuffer(1000);
    protected double currentDamage = 0.0;
    protected double currentHeat = 0.0;
    protected double maxReachedHeat = 0.0;
    protected double currentEUGenerated = 0.0;
    protected double minEUGenerated = Double.MAX_VALUE;
    protected double maxEUGenerated = 0.0;
    protected double currentHeatGenerated = 0.0;
    protected double minHeatGenerated = Double.MAX_VALUE;
    protected double maxHeatGenerated = 0.0;
    protected double currentHullHeating = 0.0;
    protected double currentComponentHeating = 0.0;
    protected double currentHullCooling = 0.0;
    protected double currentVentCooling = 0.0;
    protected double bestVentCooling = 0.0;
    protected double currentCellCooling = 0.0;
    protected double bestCellCooling = 0.0;
    protected double currentCondensatorCooling = 0.0;
    protected double bestCondensatorCooling = 0.0;
    protected double explosionPowerMultiplier = 1.0;
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("Ic2ExpReactorPlanner/Bundle");

    public double getMaxDamage() {
        return this.maxDamage;
    }

    public double getMaxHeat() {
        return this.maxHeat;
    }

    public double getInitialHeat() {
        return this.initialHeat;
    }

    public void setInitialHeat(double value) {
        if (this.isHeatAcceptor() && value >= 0.0 && value < this.maxHeat) {
            this.initialHeat = value;
        }
    }

    public int getAutomationThreshold() {
        return this.automationThreshold;
    }

    public void setAutomationThreshold(int value) {
        if (this.maxHeat > 1.0 || this.maxDamage > 1.0) {
            this.automationThreshold = value;
        }
    }

    public int getReactorPause() {
        return this.reactorPause;
    }

    public void setReactorPause(int value) {
        if (this.maxHeat > 1.0 || this.maxDamage > 1.0) {
            this.reactorPause = value;
        }
    }

    public double getCurrentDamage() {
        return this.currentDamage;
    }

    public double getCurrentHeat() {
        return this.currentHeat;
    }

    public double getMaxReachedHeat() {
        return this.maxReachedHeat;
    }

    public double getCurrentEUGenerated() {
        return this.currentEUGenerated;
    }

    public double getMinEUGenerated() {
        return this.minEUGenerated;
    }

    public double getMaxEUGenerated() {
        return this.maxEUGenerated;
    }

    public double getCurrentHeatGenerated() {
        return this.currentHeatGenerated;
    }

    public double getMinHeatGenerated() {
        return this.minHeatGenerated;
    }

    public double getMaxHeatGenerated() {
        return this.maxHeatGenerated;
    }

    public double getCurrentHullHeating() {
        return this.currentHullHeating;
    }

    public double getCurrentComponentHeating() {
        return this.currentComponentHeating;
    }

    public double getCurrentHullCooling() {
        return this.currentHullCooling;
    }

    public double getCurrentVentCooling() {
        return this.currentVentCooling;
    }

    public double getBestVentCooling() {
        return this.bestVentCooling;
    }

    public double getCurrentCellCooling() {
        return this.currentCellCooling;
    }

    public double getBestCellCooling() {
        return this.bestCellCooling;
    }

    public double getCurrentCondensatorCooling() {
        return this.currentCondensatorCooling;
    }

    public double getBestCondensatorCooling() {
        return this.bestCondensatorCooling;
    }

    protected ReactorItem(int id, String baseName, String name, Image image, double maxDamage, double maxHeat, String sourceMod) {
        this.id = id;
        this.baseName = baseName;
        this.name = name;
        this.image = image;
        this.maxDamage = maxDamage;
        this.maxHeat = maxHeat;
        if (maxHeat > 1.0) {
            this.automationThreshold = (int)(maxHeat * 0.9);
        } else if (maxDamage > 1.0) {
            this.automationThreshold = (int)(maxDamage * 1.1);
        }
        this.sourceMod = sourceMod;
    }

    protected ReactorItem(ReactorItem other) {
        this.id = other.id;
        this.baseName = other.baseName;
        this.name = other.name;
        this.image = other.image;
        this.maxDamage = other.maxDamage;
        this.maxHeat = other.maxHeat;
        this.initialHeat = other.initialHeat;
        this.automationThreshold = other.automationThreshold;
        this.reactorPause = other.reactorPause;
        this.sourceMod = other.sourceMod;
    }

    public String toString() {
        String result = this.name;
        if (this.initialHeat > 0.0) {
            result = result + String.format(BUNDLE.getString("UI.InitialHeatDisplay"), (int)this.initialHeat);
        }
        return result;
    }

    public boolean isHeatAcceptor() {
        return this.maxHeat > 1.0 && !this.isBroken();
    }

    public boolean isCoolable() {
        return this.maxHeat > 1.0 && !(this instanceof Condensator);
    }

    public boolean isNeutronReflector() {
        return false;
    }

    public void preReactorTick() {
        this.currentHullHeating = 0.0;
        this.currentComponentHeating = 0.0;
        this.currentHullCooling = 0.0;
        this.currentVentCooling = 0.0;
        this.currentCellCooling = 0.0;
        this.currentCondensatorCooling = 0.0;
        this.currentEUGenerated = 0.0;
        this.currentHeatGenerated = 0.0;
    }

    public double generateHeat() {
        return 0.0;
    }

    public double generateEnergy() {
        return 0.0;
    }

    public double dissipate() {
        return 0.0;
    }

    public void transfer() {
    }

    public void addToReactor(Reactor parent, int row, int col) {
        this.removeFromReactor();
        this.parent = parent;
        this.row = row;
        this.col = col;
    }

    public void removeFromReactor() {
        this.parent = null;
        this.row = -10;
        this.col = -10;
    }

    public final void clearCurrentHeat() {
        this.currentHeat = this.initialHeat;
        this.bestVentCooling = 0.0;
        this.bestCondensatorCooling = 0.0;
        this.bestCellCooling = 0.0;
        this.minEUGenerated = Double.MAX_VALUE;
        this.maxEUGenerated = 0.0;
        this.minHeatGenerated = Double.MAX_VALUE;
        this.maxHeatGenerated = 0.0;
        this.maxReachedHeat = this.initialHeat;
    }

    public double adjustCurrentHeat(double heat) {
        if (this.isHeatAcceptor()) {
            double result = 0.0;
            double tempHeat = this.getCurrentHeat();
            if ((tempHeat += heat) > this.getMaxHeat()) {
                result = this.getMaxHeat() - tempHeat + 1.0;
                tempHeat = this.getMaxHeat();
            } else if (tempHeat < 0.0) {
                result = tempHeat;
                tempHeat = 0.0;
            }
            this.currentHeat = tempHeat;
            this.maxReachedHeat = Math.max(this.maxReachedHeat, this.currentHeat);
            return result;
        }
        return heat;
    }

    public final void clearDamage() {
        this.currentDamage = 0.0;
    }

    public final void applyDamage(double damage) {
        if (this.maxDamage > 1.0 && damage > 0.0) {
            this.currentDamage += damage;
        }
    }

    public boolean isBroken() {
        return this.currentHeat >= this.getMaxHeat() || this.currentDamage >= this.getMaxDamage();
    }

    public int getRodCount() {
        return 0;
    }

    public double getExplosionPowerOffset() {
        if (!this.isBroken()) {
            if (this.getRodCount() == 0 && this.isNeutronReflector()) {
                return -1.0;
            }
            return 2 * this.getRodCount();
        }
        return 0.0;
    }

    public double getExplosionPowerMultiplier() {
        return this.explosionPowerMultiplier;
    }

    public double getVentCoolingCapacity() {
        return 0.0;
    }

    public double getHullCoolingCapacity() {
        return 0.0;
    }

    public double getCurrentOutput() {
        return 0.0;
    }

    public boolean producesOutput() {
        return this.getVentCoolingCapacity() > 0.0 || this.getRodCount() > 0;
    }

    public boolean needsCoolantInjected() {
        return false;
    }

    public void injectCoolant() {
    }
}

