/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner.components;

import Ic2ExpReactorPlanner.components.FuelRod;
import Ic2ExpReactorPlanner.components.ReactorItem;
import java.awt.Image;

public class GGFuelRod
extends FuelRod {
    private final int rodCount;
    private final double energyMult;
    private final int heatBonus;
    private static boolean GTNHbehavior = false;

    public static void setGTNHBehavior(boolean value) {
        GTNHbehavior = value;
    }

    public GGFuelRod(int id, String baseName, String name, Image image, double maxDamage, double maxHeat, String sourceMod, int energyMult, double heatMult, int rodCount, boolean moxStyle, int heatBonus) {
        super(id, baseName, name, image, maxDamage, maxHeat, sourceMod, energyMult, heatMult, rodCount, moxStyle);
        this.energyMult = energyMult;
        this.rodCount = rodCount;
        this.heatBonus = heatBonus;
    }

    public GGFuelRod(GGFuelRod other) {
        super(other);
        this.energyMult = other.energyMult;
        this.rodCount = other.rodCount;
        this.heatBonus = other.heatBonus;
    }

    private int countNeutronNeighbors() {
        int neutronNeighbors = 0;
        ReactorItem component = this.parent.getComponentAt(this.row + 1, this.col);
        if (component != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        if ((component = this.parent.getComponentAt(this.row - 1, this.col)) != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        if ((component = this.parent.getComponentAt(this.row, this.col - 1)) != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        if ((component = this.parent.getComponentAt(this.row, this.col + 1)) != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        return neutronNeighbors;
    }

    @Override
    public double generateEnergy() {
        int pulses = this.countNeutronNeighbors() + 1 + this.rodCount / 2;
        double energy = this.energyMult * (double)pulses * (double)(1.0f + (float)this.heatBonus * ((float)this.parent.getCurrentHeat() / (float)this.parent.getMaxHeat()));
        if (GTNHbehavior || "GTNH".equals(this.sourceMod)) {
            energy *= 5.0;
        }
        this.minEUGenerated = Math.min(this.minEUGenerated, energy);
        this.maxEUGenerated = Math.max(this.maxEUGenerated, energy);
        this.currentEUGenerated = energy;
        this.parent.addEUOutput(energy);
        this.applyDamage(1.0);
        return energy;
    }
}

